/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.actions.comment;

import com.cenqua.crucible.actions.AjaxResponse;
import com.cenqua.crucible.actions.ReviewBaseAction;
import com.cenqua.crucible.configuration.metrics.MetricsConfig;
import com.cenqua.crucible.model.Comment;
import com.cenqua.crucible.model.managers.CommentManager;
import com.cenqua.crucible.model.managers.LogManager;
import com.cenqua.crucible.tags.ReviewUtil;
import com.cenqua.fisheye.util.StringUtil;

public class BaseCommentAction
extends ReviewBaseAction
implements AjaxResponse {
    protected String newText;
    protected boolean draft = false;
    protected boolean defect = false;
    private String errorMsg = "";
    private Integer commentId;
    protected boolean newComment = false;
    private boolean worked = true;

    public String getNewText() {
        return this.newText;
    }

    public void setNewText(String newText) {
        this.newText = newText.trim();
    }

    public void setDraft(boolean draft) {
        this.draft = draft;
    }

    public void setDefect(String[] defect) {
        this.defect = Boolean.valueOf(defect[0]);
    }

    public boolean isWorked() {
        return this.worked;
    }

    public boolean isAllowed() {
        return this.getReview().checkWriteAccess(this.getCurrentUser()) && ReviewUtil.canDoReviewAction("action:commentOnReview", this.getReview());
    }

    protected void setWorked(boolean worked) {
        this.worked = worked;
    }

    public String getErrorMsg() {
        return this.errorMsg;
    }

    protected void setErrorMsg(String errorMsg) {
        this.errorMsg = errorMsg;
        this.worked = StringUtil.nullOrEmpty(errorMsg);
    }

    public void setCommentId(Integer commentId) {
        this.commentId = commentId;
    }

    protected Comment makeComment() throws Exception {
        Comment comment;
        if (this.newText == null || this.newText.equals("")) {
            this.setErrorMsg("Your comment wasn't added because no text was provided.");
            return null;
        }
        if (this.commentId == null || this.commentId == -1) {
            comment = CommentManager.createComment(this.newText, this.getReview(), this.getCurrentUser());
            this.newComment = true;
        } else {
            comment = CommentManager.getById(this.commentId);
            this.newComment = false;
        }
        if (comment == null) {
            if (this.newComment) {
                this.setErrorMsg("There was a problem creating a new comment.");
            } else {
                this.setErrorMsg("There was a problem getting the comment to edit.");
            }
            return null;
        }
        if (!this.newComment) {
            if (!comment.isDraft()) {
                LogManager.log(this.getPermaId() + ": " + comment.getUser().getUserName() + " changed comment " + comment.getId() + ": \"" + comment.getMessage() + "\" to \"" + this.newText + "\"");
            }
            comment.setMessage(this.newText);
            if (this.draft && !comment.isDraft()) {
                LogManager.log(this.getPermaId() + ": " + comment.getUser().getUserName() + " changed comment back to draft.");
            }
        } else if (!this.draft) {
            LogManager.log(this.getPermaId() + ": " + comment.getUser().getUserName() + " added comment " + comment.getId());
        }
        comment.setDeleted(false);
        comment.setDraft(this.draft);
        comment.setDefectRaised(this.defect);
        MetricsConfig mc = this.getMetricsConfig();
        if (mc != null && mc.isValid()) {
            this.addFields(comment, mc.getCommentFields());
        }
        return comment;
    }
}

