/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.actions.create;

import com.atlassian.crucible.spi.TxCallback;
import com.cenqua.crucible.actions.AjaxResponse;
import com.cenqua.crucible.actions.ReviewBaseAction;
import com.cenqua.crucible.model.PermaIdFormatException;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.managers.LogManager;
import com.cenqua.crucible.model.managers.ReviewManager;
import com.cenqua.crucible.model.managers.UserActionManager;
import org.springframework.transaction.TransactionStatus;

public class LinkReviewAction
extends ReviewBaseAction
implements AjaxResponse {
    private String parentReviewId;
    private String errorMsg;
    private boolean worked;
    private boolean unlinkParent;

    public void setParentReviewId(String parentReviewId) {
        this.parentReviewId = parentReviewId;
    }

    public String execute() throws Exception {
        if (!this.isFileModifiable()) {
            UserActionManager userActionManager = UserActionManager.getInstance();
            this.errorMsg = userActionManager.getAction("action:modifyReviewFiles").getPermissionViolationMsg();
            this.worked = false;
            return "ajaxError";
        }
        return this.txTemplate.execute(new TxCallback<String>(){

            @Override
            public String doInTransaction(TransactionStatus status) throws Exception {
                try {
                    if (!(LinkReviewAction.this.worked = LinkReviewAction.this.linkReview())) {
                        return "ajaxError";
                    }
                }
                catch (PermaIdFormatException e2) {
                    LinkReviewAction.this.errorMsg = "Review Id " + LinkReviewAction.this.parentReviewId + " is invalid";
                    LinkReviewAction.this.worked = false;
                    return "ajaxError";
                }
                return "success";
            }
        });
    }

    private boolean linkReview() throws PermaIdFormatException {
        if (this.unlinkParent) {
            this.getReview().setParentReview(null);
        } else {
            Review parent = ReviewManager.getReviewByPermaId(this.parentReviewId);
            if (parent != null) {
                this.errorMsg = this.checkParentValid(this.getReview(), parent);
                if (this.errorMsg != null) {
                    return false;
                }
                this.getReview().setParentReview(parent);
                this.log(" changing parent review to \"" + this.parentReviewId + "\"");
            } else {
                this.errorMsg = "review " + this.parentReviewId + " doesn't exist";
                return false;
            }
        }
        return true;
    }

    private String checkParentValid(Review child, Review parent) {
        if (parent.isDescendantOf(child)) {
            return parent.getPermaId() + " is a child of " + child.getPermaId() + " and so cannot be set as a parent.";
        }
        return null;
    }

    private void log(String message) {
        LogManager.log(this.getCurrentUser().getDisplayName() + " altering " + this.getReview().getPermaId() + message);
    }

    public String getErrorMsg() {
        return this.errorMsg;
    }

    public boolean isWorked() {
        return this.worked;
    }

    public void setUnlinkParent(boolean unlinkParent) {
        this.unlinkParent = unlinkParent;
    }
}

