/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.actions.profile;

import com.cenqua.crucible.filters.CrucibleFilter;
import com.cenqua.crucible.hibernate.TxHelper;
import com.cenqua.crucible.model.CrucibleUser;
import com.cenqua.crucible.notification.DeliverySchedule;
import com.cenqua.fisheye.web.profile.actions.AbstractProfileAction;

public class EditCruciblePrefsAction
extends AbstractProfileAction {
    private TxHelper txHelper = new TxHelper();
    private boolean notifyStateChange;
    private boolean notifyComment;
    private boolean notifyGeneral;
    private boolean notifyComplete;
    private boolean notifyMyActions;
    private String email;

    public boolean isNotifyStateChange() {
        return this.notifyStateChange;
    }

    public void setNotifyStateChange(boolean notifyStateChange) {
        this.notifyStateChange = notifyStateChange;
    }

    public boolean isNotifyComment() {
        return this.notifyComment;
    }

    public void setNotifyComment(boolean notifyComment) {
        this.notifyComment = notifyComment;
    }

    public boolean isNotifyGeneral() {
        return this.notifyGeneral;
    }

    public void setNotifyGeneral(boolean notifyGeneral) {
        this.notifyGeneral = notifyGeneral;
    }

    public boolean isNotifyComplete() {
        return this.notifyComplete;
    }

    public void setNotifyComplete(boolean notifyComplete) {
        this.notifyComplete = notifyComplete;
    }

    public boolean isNotifyMyActions() {
        return this.notifyMyActions;
    }

    public void setNotifyMyActions(boolean notifyMyActions) {
        this.notifyMyActions = notifyMyActions;
    }

    public String getEmail() {
        return this.email;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String execute() throws Exception {
        CrucibleUser user = this.getCurrentUser();
        if (user != null) {
            this.email = user.getEmail();
            this.configChangePasswordEnabled(user.getUserName());
            try {
                this.txHelper.beginTx();
                user.setCommentEmailNotification(this.getState(this.notifyComment));
                user.setCompleteEmailNotification(this.getState(this.notifyComplete));
                user.setGeneralEmailNotification(this.getState(this.notifyGeneral));
                user.setStateChangeEmailNotification(this.getState(this.notifyStateChange));
                user.setDontSendMeMyNotifications(!this.notifyMyActions);
                this.txHelper.commitTx();
            }
            finally {
                this.txHelper.rollbackTxIfNotCommited();
            }
            return "success";
        }
        this.addActionError("Couldn't load user details");
        return "error";
    }

    public String doDefault() throws Exception {
        CrucibleUser user = this.getCurrentUser();
        if (user != null) {
            this.email = user.getEmail();
            this.configChangePasswordEnabled(user.getUserName());
            Integer commentEmails = user.getCommentEmailNotification();
            Integer completeEmails = user.getCompleteEmailNotification();
            Integer generalEmails = user.getGeneralEmailNotification();
            Integer stateChangeEmails = user.getStateChangeEmailNotification();
            Boolean noSelfNotifications = user.getDontSendMeMyNotifications();
            this.notifyComment = this.isOn(commentEmails);
            this.notifyComplete = this.isOn(completeEmails);
            this.notifyGeneral = this.isOn(generalEmails);
            this.notifyStateChange = this.isOn(stateChangeEmails);
            this.notifyMyActions = noSelfNotifications == false;
            return "success";
        }
        this.addActionError("Couldn't load user details");
        return "error";
    }

    private CrucibleUser getCurrentUser() {
        return CrucibleFilter.getCurrentUser();
    }

    private boolean isOn(Integer state) {
        return state.equals(DeliverySchedule.IMMEDIATE);
    }

    private Integer getState(boolean b2) {
        return b2 ? DeliverySchedule.IMMEDIATE : DeliverySchedule.DISABLE;
    }
}

