/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.actions.project;

import com.cenqua.crucible.actions.PagedSearch;
import com.cenqua.crucible.actions.chart.BaseSparklineCalculator;
import com.cenqua.crucible.actions.chart.CommentsPerReviewSparklineCalculator;
import com.cenqua.crucible.actions.chart.DaysToCompleteSparklineCalculator;
import com.cenqua.crucible.actions.chart.FilesPerReviewSparklineCalculator;
import com.cenqua.crucible.actions.chart.SparkLineCalculator;
import com.cenqua.crucible.actions.project.BaseProjectAction;
import com.cenqua.crucible.actions.project.ProjectDashboardPagedSearch;
import com.cenqua.crucible.actions.project.ProjectReviewCounts;
import com.cenqua.crucible.actions.project.ReviewAgeBuckets;
import com.cenqua.crucible.actions.project.ReviewStartCount;
import com.cenqua.crucible.actions.project.StatItem;
import com.cenqua.crucible.reports.SparkLineResultCache;
import com.cenqua.crucible.view.CommentReportDO;
import com.cenqua.crucible.view.FilterLink;
import com.cenqua.crucible.view.ReviewFilterState;
import com.cenqua.crucible.view.ReviewReportDO;
import com.cenqua.crucible.view.RowDetail;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.util.DateHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectDashboardAction
extends BaseProjectAction {
    private ReviewAgeBuckets reviewAgeBuckets = null;
    private CommentReportDO crDO;
    private ReviewReportDO rrDO;
    private ProjectReviewCounts reviewCounts;
    private PagedSearch pagedSearch;
    private ReviewFilterState filterState = new ReviewFilterState(this.getCurrentUser(), "allOpenReviews", "ProjectDashboardAction");
    private List<ReviewStartCount> reviewStartCounts;
    private List<StatItem> statItems;
    private SparkLineResultCache sparklineResultCache;

    public String execute() {
        this.filterState.setFilterFromSession();
        if (this.getProject() == null) {
            return "error";
        }
        return "success";
    }

    public CommentReportDO getCommentReportDO() {
        if (this.crDO == null) {
            this.crDO = new CommentReportDO();
            this.crDO.setProject(this.getProject());
        }
        return this.crDO;
    }

    public ReviewReportDO getReviewReportDO() {
        if (this.rrDO == null) {
            this.rrDO = new ReviewReportDO();
            this.rrDO.setProject(this.getProject());
            this.rrDO.setStateName("Review");
        }
        return this.rrDO;
    }

    public ReviewAgeBuckets getAgeBuckets() {
        if (this.reviewAgeBuckets == null) {
            this.reviewAgeBuckets = new ReviewAgeBuckets(this.getProject());
        }
        return this.reviewAgeBuckets;
    }

    public ProjectReviewCounts getReviewCounts() {
        if (this.reviewCounts == null) {
            this.reviewCounts = new ProjectReviewCounts(this.getPrincipal(), this.getProject());
        }
        return this.reviewCounts;
    }

    public PagedSearch getPagedSearch() {
        if (this.pagedSearch == null) {
            this.pagedSearch = new ProjectDashboardPagedSearch(this.getFilterState(), this.getReviewCounts().getCountForFilter(this.getFilterState().getFilterName()));
            this.setAttribute("this", (Object)this);
        }
        return this.pagedSearch;
    }

    public void setPage(int page) {
        this.getPagedSearch().setPage(page);
    }

    @Override
    public void setProjectKey(String projectKey) {
        super.setProjectKey(projectKey);
        this.filterState.setProject(this.getProject());
    }

    public void setFilter(String filter) {
        this.filterState.setFilter(filter);
    }

    public ReviewFilterState getFilterState() {
        return this.filterState;
    }

    public List<FilterLink> getFilterLinks() {
        return Arrays.asList(new FilterLink("draftReviews", "All Draft Reviews", "Draft"){

            public int getCount() {
                return ProjectDashboardAction.this.getReviewCounts().getCountDraftReviews();
            }
        }, new FilterLink("allOpenReviews", "All Open Reviews", "Open"){

            public int getCount() {
                return ProjectDashboardAction.this.getReviewCounts().getCountAllOpenReviews();
            }
        }, new FilterLink("allClosedReviews", "All Closed Reviews", "Closed"){

            public int getCount() {
                return ProjectDashboardAction.this.getReviewCounts().getCountAllClosedReviews();
            }
        }, new FilterLink("allReviews", "All Reviews", "All"){

            public int getCount() {
                return ProjectDashboardAction.this.getReviewCounts().getCountAllReviews();
            }
        });
    }

    public List<ReviewStartCount> getReviewStartCounts() {
        if (this.reviewStartCounts == null) {
            this.reviewStartCounts = new ArrayList<ReviewStartCount>();
            GregorianCalendar cal = DateHelper.getStartOfTodayAsCalendar(AppConfig.getsConfig().getTimezone());
            Date startOfToday = cal.getTime();
            this.reviewStartCounts.add(new ReviewStartCount(startOfToday, new Date(), "today", this.getProject()));
            cal.add(6, -7);
            Date startOfWeek = cal.getTime();
            this.reviewStartCounts.add(new ReviewStartCount(startOfWeek, startOfToday, "previous week", this.getProject()));
            cal = DateHelper.getStartOfTodayAsCalendar(AppConfig.getsConfig().getTimezone());
            cal.add(2, -1);
            Date startOfMonth = cal.getTime();
            this.reviewStartCounts.add(new ReviewStartCount(startOfMonth, startOfWeek, "previous month", this.getProject()));
        }
        return this.reviewStartCounts;
    }

    public List<StatItem> getStatItems() {
        if (this.statItems == null) {
            this.statItems = new ArrayList<StatItem>();
            double[] sparkSummaries = this.getSparkSummaries();
            this.statItems.add(new StatItem("Comments", "per review", sparkSummaries[0], "commentsperreviewsparkimg"));
            this.statItems.add(new StatItem("Days", "to complete", sparkSummaries[1], "daystocompletesparkimg"));
            this.statItems.add(new StatItem("Open", "reviews", this.getReviewCounts().getCountAllOpenReviews(), "openreviewssparkimg"));
            this.statItems.add(new StatItem("Files", "per review", sparkSummaries[2], "filesperreviewsparkimg"));
        }
        return this.statItems;
    }

    private double[] getSparkSummaries() {
        GregorianCalendar cal = DateHelper.getStartOfTodayAsCalendar(AppConfig.getsConfig().getTimezone());
        cal.add(6, 1);
        Date to = cal.getTime();
        cal.add(2, -1);
        Date from = cal.getTime();
        List<BaseSparklineCalculator> processors = Arrays.asList(new CommentsPerReviewSparklineCalculator(from, to), new DaysToCompleteSparklineCalculator(from, to), new FilesPerReviewSparklineCalculator(from, to));
        if (!this.sparklineResultCache.contains(this.getProject(), from, to, processors.get(0))) {
            this.sparklineResultCache.precalculate(this.getProject(), from, to, processors);
        }
        double[] result = new double[processors.size()];
        int i2 = 0;
        for (SparkLineCalculator sparkLineCalculator : processors) {
            result[i2++] = this.sparklineResultCache.get(this.getProject(), from, to, sparkLineCalculator).getSummary();
        }
        return result;
    }

    public void setSparklineResultCache(SparkLineResultCache sparklineResultCache) {
        this.sparklineResultCache = sparklineResultCache;
    }

    public String getReviewsStartedImageParams() {
        StringBuilder sb = new StringBuilder();
        String sep = "?";
        for (ReviewStartCount c2 : this.getReviewStartCounts()) {
            sb.append(sep).append("value=").append(c2.getCount());
            sep = "&";
        }
        return sb.toString();
    }

    public boolean isSomeReviewsStarted() {
        for (ReviewStartCount c2 : this.getReviewStartCounts()) {
            if (c2.getCount() <= 0) continue;
            return true;
        }
        return false;
    }

    public List<RowDetail> getFilteredReviewDetails() {
        return Collections.unmodifiableList(this.filterState.getFilteredReviewDetails(this.getPagedSearch()));
    }
}

