/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.actions.project;

import com.cenqua.crucible.actions.project.ReviewAgeBucket;
import com.cenqua.crucible.model.Project;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.managers.ReviewManager;
import com.cenqua.crucible.model.managers.StateManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReviewAgeBuckets {
    boolean empty = true;
    private List<ReviewAgeBucket> buckets = new ArrayList<ReviewAgeBucket>();

    public ReviewAgeBuckets(Project project) {
        this.buckets.add(new ReviewAgeBucket(1, "Today"));
        this.buckets.add(new ReviewAgeBucket(7, "Day+"));
        this.buckets.add(new ReviewAgeBucket(30, "Week+"));
        this.buckets.add(new ReviewAgeBucket(-1, "Month+"));
        long now = new Date().getTime();
        HashSet<String> states = new HashSet<String>();
        states.addAll(Arrays.asList(StateManager.INSTANCE.getOpenStateNames()));
        states.addAll(Arrays.asList(StateManager.INSTANCE.getDraftStateNames()));
        Collection<Review> reviews = ReviewManager.getReviewsInStates(project, states.toArray(new String[states.size()]));
        for (Review r : reviews) {
            this.addReviewToBucket(now, r);
        }
    }

    public boolean isAllBucketsEmpty() {
        return this.empty;
    }

    private void addReviewToBucket(long now, Review r) {
        this.empty = false;
        long ageInDays = (now - r.getCreateDate().getTime()) / 86400000L;
        ReviewAgeBucket rab = this.getReviewAgeBucket(ageInDays);
        rab.addReview(r);
    }

    private ReviewAgeBucket getReviewAgeBucket(long ageInDays) {
        for (ReviewAgeBucket rab : this.buckets) {
            if ((long)rab.getMaxAge() <= ageInDays && rab.getMaxAge() != -1) continue;
            return rab;
        }
        throw new RuntimeException("Failed to find review age bucket for age " + ageInDays);
    }

    public List<ReviewAgeBucket> getBuckets() {
        return this.buckets;
    }
}

