/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.interceptors;

import com.cenqua.crucible.actions.ReviewBaseAction;
import com.cenqua.crucible.filters.CrucibleFilter;
import com.cenqua.crucible.model.Principal;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.tags.ReviewUtil;
import com.cenqua.fisheye.logging.Logs;
import com.opensymphony.xwork.ActionInvocation;
import com.opensymphony.xwork.interceptor.Interceptor;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class ReviewInterceptor
implements Interceptor {
    public void destroy() {
    }

    public void init() {
    }

    public String intercept(ActionInvocation actionInvocation) throws Exception {
        String result = null;
        if (actionInvocation.getAction() instanceof ReviewBaseAction) {
            ReviewBaseAction action = (ReviewBaseAction)actionInvocation.getAction();
            Review review = action.getReview();
            if (review == null) {
                Map contextMap = actionInvocation.getInvocationContext().getContextMap();
                HttpServletRequest request = (HttpServletRequest)contextMap.get("com.opensymphony.xwork.dispatcher.HttpServletRequest");
                Logs.APP_LOG.warn((Object)("Unable to find requested review: " + request.getParameter("reviewid") + ", referer = " + request.getHeader("Referer")));
                result = "nosuchreview";
            } else if (!ReviewUtil.canDoReviewAction("action:viewReview", review)) {
                result = CrucibleFilter.getCurrentPrincipal().equals(Principal.Anonymous.ANON) ? "loginRequired" : "nopermission";
            }
        }
        if (result == null) {
            result = actionInvocation.invoke();
        }
        return result;
    }
}

