/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.model;

import com.cenqua.crucible.model.Comment;
import com.cenqua.crucible.model.CommentList;
import com.cenqua.crucible.model.CrucibleUser;
import com.cenqua.crucible.model.managers.CommentManager;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommentListImpl
implements CommentList {
    private Set<Comment> comments = new HashSet<Comment>();

    @Override
    public void addComment(Comment comment) {
        this.comments.add(comment);
    }

    @Override
    public int getCommentCount() {
        int count = 0;
        for (Comment comment : this.comments) {
            if (comment.isDeleted()) continue;
            ++count;
        }
        return count;
    }

    @Override
    public HashMap<String, Integer> getCommentStats() {
        return this.getCommentStats(this.comments);
    }

    public HashMap<String, Integer> getCommentStats(Set<Comment> comments) {
        int pos = 0;
        int neg = 0;
        int neutral = 0;
        int replies = 0;
        for (Comment comment : comments) {
            if (comment.isDeleted() || comment.isDraft()) continue;
            replies += comment.getCommentCount();
            if (comment.isNegative()) {
                ++neg;
                continue;
            }
            if (comment.isPositive()) {
                ++pos;
                continue;
            }
            ++neutral;
        }
        HashMap<String, Integer> stats = new HashMap<String, Integer>();
        stats.put("total", pos + neg + neutral);
        stats.put("positive", pos);
        stats.put("negative", neg);
        stats.put("neutral", neutral);
        stats.put("replies", replies);
        return stats;
    }

    @Override
    public Set<Comment> getComments() {
        return this.comments;
    }

    @Override
    public void setComments(Set<Comment> comments) {
        this.comments = comments;
    }

    @Override
    public boolean removeComment(Comment comment) {
        return this.comments.remove(comment);
    }

    @Override
    public Comment getCommentById(Integer id) {
        for (Comment comment : this.comments) {
            if (!comment.getId().equals(id)) continue;
            return comment;
        }
        return null;
    }

    @Override
    public void cleanUpComments() {
        this.cleanUpComments(null);
    }

    @Override
    public void cleanUpComments(CrucibleUser user) {
        HashSet<Comment> removeThese = new HashSet<Comment>();
        for (Comment comment : this.comments) {
            comment.cleanUpComments();
            if (user != null && !comment.getUser().equals(user) || !comment.isDeleted() && !comment.isDraft()) continue;
            removeThese.add(comment);
        }
        for (Comment comment : removeThese) {
            this.removeComment(comment);
            CommentManager.deleteComment(comment);
        }
    }
}

