/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.model;

import com.cenqua.crucible.model.RoleException;
import com.cenqua.crucible.model.State;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;

public class RoleInfo {
    private boolean readAccess = false;
    private boolean writeAccess = false;
    private LinkedHashMap actions = new LinkedHashMap();
    private List transitionScripts = new ArrayList();

    public boolean isAuthority() {
        return !this.actions.isEmpty();
    }

    public boolean isReadAccess() {
        return this.readAccess;
    }

    public void setReadAccess(boolean readAccess) {
        this.readAccess = readAccess;
    }

    public boolean isWriteAccess() {
        return this.writeAccess;
    }

    public void setWriteAccess(boolean writeAccess) {
        this.writeAccess = writeAccess;
    }

    public void addAction(String action, State nextState) {
        Object[] details = new Object[]{nextState, new ArrayList()};
        this.actions.put(action, details);
    }

    public State nextState(String action) {
        return this.getActionNextState(action);
    }

    private ArrayList getActionScriptArray(String action) {
        if (this.actions.containsKey(action)) {
            return (ArrayList)((Object[])this.actions.get(action))[1];
        }
        return null;
    }

    private State getActionNextState(String action) {
        if (this.actions.containsKey(action)) {
            return (State)((Object[])this.actions.get(action))[0];
        }
        return null;
    }

    public Set getActions() {
        return this.actions.keySet();
    }

    public void addTransitionScript(String script) {
        this.transitionScripts.add(script);
    }

    public List getTransitionScripts() {
        return this.transitionScripts;
    }

    public void addActionScript(String action, String script) throws RoleException {
        if (!this.actions.containsKey(action)) {
            throw new RoleException("Action " + action + " not in role");
        }
        this.getActionScriptArray(action).add(script);
    }

    public List getActionScripts(String action) {
        return this.getActionScriptArray(action);
    }
}

