/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.model;

import com.cenqua.crucible.model.CrucibleUser;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.Role;
import com.cenqua.crucible.model.StateTransition;
import com.cenqua.crucible.model.managers.ActionManager;
import com.cenqua.crucible.model.managers.StateManager;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class State {
    private String name;
    private String verbage;
    private StateManager.States stateType = StateManager.States.NONE_STATE;
    private StateManager.MetaState metaState;
    private LinkedList<StateTransition> transitions = new LinkedList();
    private LinkedList<String> entryScripts = new LinkedList();
    private LinkedList<Role> notify = new LinkedList();

    public State() {
    }

    public State(String name, String verbage, StateManager.States stateType, StateManager.MetaState metaState) {
        this.name = name;
        this.verbage = verbage;
        this.stateType = stateType;
        this.metaState = metaState;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getVerbage() {
        return this.verbage;
    }

    public void setVerbage(String verbage) {
        this.verbage = verbage;
    }

    public List<StateTransition> getStateProgressionActions() {
        return this.transitions;
    }

    public List<String> getEntryScripts() {
        return this.entryScripts;
    }

    public void addEntryScript(String script) {
        this.entryScripts.add(script);
    }

    public void processEntryScripts(CrucibleUser user, Review review) {
        List<String> actions = this.getEntryScripts();
        for (String action : actions) {
            ActionManager.INSTANCE.doAction(action, user, review);
        }
    }

    public void addStateChangeNotifactionRole(Role role) {
        this.notify.add(role);
    }

    public List getStateChangeNotificationRoles() {
        return this.notify;
    }

    public String toString() {
        return this.name;
    }

    public StateManager.States getStateType() {
        return this.stateType;
    }

    public void setStateType(StateManager.States stateType) {
        this.stateType = stateType;
    }

    public StateTransition addTransition(State nextState, String actionName, String verbage) {
        StateTransition trans = new StateTransition(this, nextState, actionName, verbage);
        this.transitions.add(trans);
        return trans;
    }

    public void addTransition(StateTransition stateTransition) {
        this.transitions.add(stateTransition);
    }

    public StateTransition getTransition(String actionName) {
        List<StateTransition> actions = this.getStateProgressionActions();
        for (StateTransition transition : actions) {
            if (!transition.getActionName().equals(actionName)) continue;
            return transition;
        }
        return null;
    }

    public boolean isDraftState() {
        return this.getStateType() == StateManager.States.DRAFT_STATE;
    }

    public boolean isApprovalState() {
        return this.getStateType() == StateManager.States.APPROVAL_STATE;
    }

    public boolean isReviewState() {
        return this.getStateType() == StateManager.States.REVIEW_STATE;
    }

    public boolean isSummarizeState() {
        return this.getStateType() == StateManager.States.SUMMARIZE_STATE;
    }

    public boolean isClosedState() {
        return this.getStateType() == StateManager.States.CLOSED_STATE;
    }

    public boolean isDeadState() {
        return this.getStateType() == StateManager.States.DEAD_STATE;
    }

    public boolean isRejectedState() {
        return this.getStateType() == StateManager.States.REJECTED_STATE;
    }

    public boolean isUnknown() {
        return this.getStateType() == StateManager.States.NONE_STATE;
    }

    public StateManager.MetaState getMetaState() {
        return this.metaState;
    }

    public boolean isDraftMetaState() {
        return this.metaState != null && this.metaState == StateManager.MetaState.DRAFT;
    }

    public boolean isOpenMetaState() {
        return this.metaState != null && this.metaState == StateManager.MetaState.OPEN;
    }

    public boolean isClosedMetaState() {
        return this.metaState != null && this.metaState == StateManager.MetaState.CLOSED;
    }

    public boolean isTrashMetaState() {
        return this.metaState != null && this.metaState == StateManager.MetaState.TRASH;
    }
}

