/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.model;

import com.cenqua.crucible.model.CrucibleUser;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.State;
import com.cenqua.crucible.model.managers.ActionManager;
import java.util.LinkedList;
import java.util.List;

public class StateTransition {
    private State state;
    private State nextState;
    private String actionName;
    private String verbage;
    private LinkedList scripts = new LinkedList();

    public StateTransition(State state, State nextState, String actionName, String verbage) {
        this.state = state;
        this.nextState = nextState;
        this.actionName = actionName;
        this.verbage = verbage;
    }

    public State getState() {
        return this.state;
    }

    public void setState(State state) {
        this.state = state;
    }

    public State getNextState() {
        return this.nextState;
    }

    public void setNextState(State nextState) {
        this.nextState = nextState;
    }

    public String getActionName() {
        return this.actionName;
    }

    public void setActionName(String actionName) {
        this.actionName = actionName;
    }

    public String getVerbage() {
        return this.verbage;
    }

    public void setVerbage(String verbage) {
        this.verbage = verbage;
    }

    public void addScript(String script) {
        this.scripts.add(script);
    }

    public List getScripts() {
        return this.scripts;
    }

    public void processScripts(CrucibleUser user, Review review) {
        ActionManager mgr = ActionManager.INSTANCE;
        for (String action : this.scripts) {
            mgr.doAction(action, user, review);
        }
    }
}

