/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.model.managers;

import com.cenqua.crucible.hibernate.HibernateUtil;
import com.cenqua.crucible.model.FileRevision;
import com.cenqua.fisheye.rep.RevInfoKey;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import org.hibernate.Query;
import org.hibernate.Session;

public class FileRevisionManager {
    private static Session session() {
        return HibernateUtil.currentSession();
    }

    public static FileRevision createRevision(String source, com.cenqua.fisheye.rep.FileRevision feRev) {
        return FileRevisionManager.createRevision(source, feRev.getPath().getPath(), feRev.getRevision(), feRev.getRevision(), feRev.getDateValue());
    }

    public static FileRevision createRevision(String source, RevInfoKey rk, Date createDate) {
        return FileRevisionManager.createRevision(source, rk.getPath().getPath(), rk.getRev(), rk.getRev(), createDate);
    }

    public static FileRevision createRevision(String source, String path, String revIdent, String revName, Date createDate) {
        FileRevision r = FileRevisionManager.findRevision(source, path, revIdent);
        if (r != null) {
            return r;
        }
        r = new FileRevision(source, path, revIdent, revName, createDate);
        FileRevisionManager.session().save((Object)r);
        return r;
    }

    public static FileRevision getById(Integer id) {
        return (FileRevision)FileRevisionManager.session().get(FileRevision.class, (Serializable)id);
    }

    public static FileRevision findRevision(String source, RevInfoKey rk) {
        return FileRevisionManager.findRevision(source, rk.getPath().getPath(), rk.getRev());
    }

    public static FileRevision findRevision(String source, String path, String rev) {
        Query q = FileRevisionManager.session().createQuery("select fileRevision from FileRevision fileRevision where fileRevision.spr.sourceName = :source and fileRevision.spr.path = :path and fileRevision.spr.revIdent = :rev");
        q.setString("source", source);
        q.setString("path", path);
        q.setString("rev", rev);
        return (FileRevision)q.uniqueResult();
    }

    public static List getRevisions() {
        return FileRevisionManager.session().createQuery("from FileRevision").list();
    }

    public static List getRevisions(String source, String path) {
        Query q = FileRevisionManager.session().createQuery("select fileRevision from FileRevision fileRevision where fileRevision.spr.sourceName = :source and fileRevision.spr.path = :path");
        q.setString("source", source);
        q.setString("path", path);
        return q.list();
    }
}

