/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.notification;

import com.cenqua.crucible.hibernate.HibernateUtil;
import com.cenqua.crucible.model.CrucibleUser;
import com.cenqua.crucible.notification.NotificationStore;
import com.cenqua.crucible.notification.Recipient;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.logging.Logs;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Notification
extends NotificationStore {
    public Notification() {
    }

    protected Notification(CrucibleUser actioner) {
        super(actioner);
    }

    protected abstract Integer getType();

    public String getEmailSubject() {
        return "[" + this.getReview().getPermaId() + "] " + this.getDescription() + ": " + this.getReview().getName();
    }

    public abstract String getLink();

    public final String getEmailNote() throws TemplateException, IOException {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        if (this.getActioner() == null) {
            Logs.APP_LOG.warn((Object)("Actioner doesn't exist. Notification: " + this.getId()));
        }
        attributes.put("notification", this);
        this.setupEmailContext(attributes);
        return this.getEmailNoteWithTemplate(this.getEmailTemplateName(), attributes);
    }

    protected abstract String getEmailTemplateName();

    protected void setupEmailContext(Map<String, Object> attribs) {
    }

    public abstract String getRSSNote() throws IOException, TemplateException;

    public abstract String getRSSTitle();

    public abstract String getDescription();

    public abstract List getRolesToNotify();

    public abstract Integer getEmailNotificationPref(CrucibleUser var1);

    public abstract Integer getRssNotificationPref(CrucibleUser var1);

    public void doNotify() {
        List roles = this.getRolesToNotify();
        Set<CrucibleUser> users = this.getReview().getUsersFromRoles(roles);
        for (CrucibleUser user : users) {
            if (!user.isActive() || user.getDontSendMeMyNotifications().booleanValue() && user.equals(this.getActioner())) continue;
            this.createAndAddRecipient(user);
        }
    }

    public void doNotify(CrucibleUser user) {
        this.createAndAddRecipient(user);
    }

    private Recipient createAndAddRecipient(CrucibleUser user) {
        Recipient r = new Recipient();
        r.setEmail(this.getEmailNotificationPref(user));
        r.setRss(this.getRssNotificationPref(user));
        r.setUser(user);
        r.setUiACK(null);
        r.setNotification(this);
        this.addRecipient(r);
        HibernateUtil.currentSession().save((Object)r);
        return r;
    }

    private Template getEmailTemplate(String filename) throws IOException {
        return AppConfig.getsConfig().getTemplateConfig().getTemplate(filename);
    }

    private String getEmailNoteWithTemplate(String templatename, Map attribs) throws IOException, TemplateException {
        StringWriter writer = new StringWriter();
        Template template = this.getEmailTemplate(templatename);
        template.process((Object)attribs, (Writer)writer);
        writer.flush();
        return writer.toString();
    }
}

