/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.reports.commentsDefects;

import com.cenqua.crucible.actions.search.comment.CommentSearchData;
import com.cenqua.crucible.model.managers.CommentManager;
import com.cenqua.crucible.reports.commentsDefects.DefectReportDO;
import org.jfree.data.general.DefaultPieDataset;

public class DefectRepDatasetMaker {
    private DefaultPieDataset defectDataSet;
    private String metric;
    private long totalComments = 0L;
    private long totalDefects = 0L;
    private CommentSearchData sd;

    public DefectRepDatasetMaker(CommentSearchData sd, String metric) {
        this.sd = sd;
        this.metric = metric;
    }

    public DefaultPieDataset getPieDataSet() {
        if (this.defectDataSet == null) {
            this.makePieDataset();
        }
        return this.defectDataSet;
    }

    public String getMetric() {
        return this.metric;
    }

    public CommentSearchData getSd() {
        return this.sd;
    }

    public long getTotalComments() {
        return this.totalComments;
    }

    public long getTotalDefects() {
        return this.totalDefects;
    }

    private void makePieDataset() {
        this.defectDataSet = new DefaultPieDataset();
        if (!this.sd.isDefects() && this.sd.isComments()) {
            return;
        }
        this.sd.setComments(false);
        this.sd.setDefects(true);
        for (CommentSearchData.MetricDO mdo : this.sd.getMetrics()) {
            if (!mdo.isSelected() || !mdo.getMetricName().equals(this.metric)) continue;
            DefectReportDO dr = CommentManager.getDefectReport(this.sd, mdo);
            this.defectDataSet.setValue((Comparable)((Object)dr.getName()), (Number)dr.getCount());
            return;
        }
        for (DefectReportDO dr : CommentManager.getDefectReports(this.sd, this.metric)) {
            this.defectDataSet.setValue((Comparable)((Object)dr.getName()), (Number)dr.getCount());
        }
    }
}

