/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.revision.diff;

import com.cenqua.fisheye.Path;

public class DiffRevisionsInfo {
    private Path path;
    private String fromRevisionName;
    private String toRevisionName;
    private int index = -1;
    private int fromLines = 0;
    private int toLines = 0;

    public DiffRevisionsInfo() {
    }

    public DiffRevisionsInfo(Path path, String fromRevisionName, String toRevisionName) {
        this.path = path;
        this.fromRevisionName = fromRevisionName;
        this.toRevisionName = toRevisionName;
    }

    public Path getPath() {
        return this.path;
    }

    public void setPath(Path path) {
        this.path = path;
    }

    public String getFromRevisionName() {
        return this.fromRevisionName;
    }

    public void setFromRevisionName(String fromRevisionName) {
        this.fromRevisionName = fromRevisionName;
    }

    public String getToRevisionName() {
        return this.toRevisionName;
    }

    public void setToRevisionName(String toRevisionName) {
        this.toRevisionName = toRevisionName;
    }

    public void setFromLines(int fromLines) {
        this.fromLines = fromLines;
    }

    public void setToLines(int toLines) {
        this.toLines = toLines;
    }

    public boolean isAdded() {
        return this.fromLines == 0 && this.fromRevisionName == null && this.toRevisionName != null;
    }

    public boolean isDeleted() {
        return this.toRevisionName == null && this.fromRevisionName != null;
    }

    public boolean isChanged() {
        return this.toRevisionName != null && this.fromRevisionName != null;
    }

    public boolean isCopied() {
        return this.fromLines != 0 && this.fromRevisionName == null && this.toRevisionName != null;
    }

    public boolean isMoved() {
        return false;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DiffRevisionsInfo that = (DiffRevisionsInfo)o;
        if (this.fromLines != that.fromLines) {
            return false;
        }
        if (this.index != that.index) {
            return false;
        }
        if (this.toLines != that.toLines) {
            return false;
        }
        if (this.fromRevisionName != null ? !this.fromRevisionName.equals(that.fromRevisionName) : that.fromRevisionName != null) {
            return false;
        }
        if (!this.path.equals(that.path)) {
            return false;
        }
        return !(this.toRevisionName != null ? !this.toRevisionName.equals(that.toRevisionName) : that.toRevisionName != null);
    }

    public int hashCode() {
        int result = this.path.hashCode();
        result = 31 * result + (this.fromRevisionName != null ? this.fromRevisionName.hashCode() : 0);
        result = 31 * result + (this.toRevisionName != null ? this.toRevisionName.hashCode() : 0);
        result = 31 * result + this.index;
        result = 31 * result + this.fromLines;
        result = 31 * result + this.toLines;
        return result;
    }

    public String toString() {
        return "(" + this.index + ")" + this.path.toString() + " (" + this.getFromRevisionName() + " - " + this.getToRevisionName() + ")" + "@@ " + this.fromLines + "," + this.toLines;
    }
}

