/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.tags;

import com.cenqua.fisheye.AppConfig;
import java.net.FileNameMap;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.SimpleTagSupport;

public class MimeLinkTag
extends SimpleTagSupport {
    private String fileName;
    private String src;

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public void setSrc(String src) {
        this.src = src;
    }

    public void doTag() throws JspException {
        try {
            JspWriter out = this.getJspContext().getOut();
            if (this.fileName == null || this.src == null || this.fileName.equals("") || this.src.equals("")) {
                out.print("Move along folks, nothing to see here.");
                return;
            }
            FileNameMap fnm = AppConfig.getsConfig().getRawMimeMap();
            String mime = fnm.getContentTypeFor(this.fileName.toLowerCase());
            out.print("<a href='" + this.src + "' title='" + this.fileName + "'>");
            if (mime != null && mime.startsWith("image")) {
                out.print("<img src='" + this.src + "' alt='Source Image: " + this.fileName + "'/>");
            } else {
                out.print("View File");
            }
            out.print("</a>");
        }
        catch (Exception e2) {
            throw new JspException("MimeLinkTag: " + e2.getMessage());
        }
    }
}

