/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.util;

import com.cenqua.crucible.model.CrucibleUser;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.Role;
import com.cenqua.crucible.model.managers.StateManager;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;

public class ReviewComparators {

    public static class RoleComparator
    implements Comparator {
        private List roles;
        private CrucibleUser user;

        public RoleComparator(List roleOrder, CrucibleUser user) {
            this.roles = roleOrder;
            this.user = user;
        }

        public int compare(Object o1, Object o2) {
            Review a2 = (Review)o1;
            Review b2 = (Review)o2;
            return this.roles.indexOf(this.getHighestRole(this.roles, a2.getUsersRoles(this.user))) - this.roles.indexOf(this.getHighestRole(this.roles, b2.getUsersRoles(this.user)));
        }

        private Role getHighestRole(List roleOrder, List userRoles) {
            for (Role role : roleOrder) {
                if (!userRoles.contains(role)) continue;
                return role;
            }
            return null;
        }
    }

    public static class StateComparator
    implements Comparator {
        public static final StateComparator INSTANCE = new StateComparator();
        private static List states = new LinkedList();

        public int compare(Object o1, Object o2) {
            Review a2 = (Review)o1;
            Review b2 = (Review)o2;
            return states.indexOf(a2.getState()) - states.indexOf(b2.getState());
        }

        static {
            states.addAll(StateManager.INSTANCE.getStates());
        }
    }

    public static class OldestFirstComparator
    implements Comparator {
        public static final OldestFirstComparator INSTANCE = new OldestFirstComparator();

        public int compare(Object o1, Object o2) {
            Review a2 = (Review)o1;
            Review b2 = (Review)o2;
            return a2.getCreateDate().compareTo(b2.getCreateDate());
        }
    }
}

