/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.api;

import com.cenqua.fisheye.api.ApiImplementation;
import com.cenqua.fisheye.api.BaseApiHandler;
import com.cenqua.fisheye.util.ISO8601DateHelper;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class RestApiHandler
extends BaseApiHandler {
    private static final Map<String, String> COMMAND_MAP = new HashMap<String, String>();

    public String parseCommand() throws IOException {
        String trans;
        String pi = this.context.getPathInfo();
        if (pi == null) {
            this.sendError("no command specified");
            return null;
        }
        if (pi.startsWith("/")) {
            pi = pi.substring(1);
        }
        if ((trans = COMMAND_MAP.get(pi)) != null) {
            pi = trans;
        }
        return pi;
    }

    public String getStringParam(int pos, String name) {
        String v = this.context.getParameter(name);
        return v;
    }

    public Long getDateParam(int pos, String name) {
        String v = this.context.getParameter(name);
        if (v == null) {
            return null;
        }
        try {
            return ISO8601DateHelper.parse(v).getTime();
        }
        catch (ISO8601DateHelper.InvalidDateException e2) {
            ApiImplementation.logApiException(e2);
            this.mErrorMessages.add("parameter '" + name + "' was not a date: " + e2.getMessage());
            return null;
        }
    }

    public Long getLongParam(int pos, String name) {
        String v = this.context.getParameter(name);
        if (v == null) {
            return null;
        }
        try {
            return new Long(v);
        }
        catch (NumberFormatException e2) {
            ApiImplementation.logApiException(e2);
            this.mErrorMessages.add("parameter '" + name + "' was not a long/integer: " + e2.getMessage());
            return null;
        }
    }

    public void openArrayMember(String s) {
        this.out.print("<");
        this.out.print(s);
        this.out.println(">");
    }

    public void closeArrayMember(String s) {
        this.out.print("</");
        this.out.print(s);
        this.out.println(">");
    }

    public void openArray() {
    }

    public void closeArray() {
    }

    public void openArrayValue() {
    }

    public void closeArrayValue() {
    }

    public void openStruct0(String s) {
        this.out.print("<");
        this.out.print(s);
    }

    public void openStruct1() {
        this.out.print(">");
    }

    public void closeStruct0(String s) {
        this.out.print("/>");
    }

    public void closeStruct(String s) {
        this.out.print("</");
        this.out.print(s);
        this.out.println(">");
    }

    protected void closeResponse() {
        this.out.println("</response>");
    }

    protected void openResponse() {
        this.out.print("<response>");
    }

    public void writeTextValue(String s) throws IOException {
        this.out.print("<string>");
        RestApiHandler.xmlEscape(this.out, s);
        this.out.println("</string>");
    }

    public void writeBooleanValue(boolean b2) {
        this.out.print("<boolean>");
        this.out.print(b2 ? "true" : "false");
        this.out.println("</boolean>");
    }

    public void writeTextMember(String name, String value) throws IOException {
        this.writeMember(name, value);
    }

    public void writeTextAttribute(String name, String value) throws IOException {
        this.writeAttribute(name, value);
    }

    public void writeBooleanAttribute(String name, boolean value) throws IOException {
        this.writeAttribute(name, value ? "true" : "false");
    }

    public void writeDateAttribute(String name, long value) throws IOException {
        this.writeAttribute(name, ISO8601DateHelper.toIsoDate(value));
    }

    public void writeDateMember(String name, long value) throws IOException {
        this.writeMember(name, ISO8601DateHelper.toIsoDate(value));
    }

    public void writeIntAttribute(String name, int value) throws IOException {
        this.writeAttribute(name, Integer.toString(value));
    }

    public void writeIntMember(String name, int value) throws IOException {
        this.writeMember(name, Integer.toString(value));
    }

    private void writeAttribute(String name, String value) throws IOException {
        this.out.print(" ");
        this.out.print(name);
        this.out.print("=\"");
        RestApiHandler.xmlEscape(this.out, value);
        this.out.print("\"");
    }

    private void writeMember(String name, String value) throws IOException {
        name = RestApiHandler.sanitizeName(name);
        this.out.write("<");
        this.out.write(name);
        this.out.write(">");
        RestApiHandler.xmlEscape(this.out, value);
        this.out.write("</");
        this.out.write(name);
        this.out.write(">");
    }

    private static String sanitizeName(String columnName) {
        StringBuffer sb = null;
        for (int i2 = 0; i2 < columnName.length(); ++i2) {
            boolean okay;
            char c2 = columnName.charAt(i2);
            boolean bl = i2 == 0 ? Character.isLetter(c2) || c2 == '_' : (okay = Character.isLetterOrDigit(c2) || c2 == '_' || c2 == '-' || c2 == '.');
            if (okay) continue;
            if (sb == null) {
                sb = new StringBuffer(columnName);
            }
            sb.setCharAt(i2, '_');
        }
        return sb == null ? columnName : sb.toString();
    }

    protected void writeError(String msg) throws IOException {
        this.out.write("<error>");
        RestApiHandler.xmlEscape(this.out, msg);
        this.out.write("</error>");
    }

    static {
        COMMAND_MAP.put("repositories", "listRepositories");
        COMMAND_MAP.put("paths", "listPaths");
        COMMAND_MAP.put("revision", "getRevision");
        COMMAND_MAP.put("pathHistory", "listPathHistory");
        COMMAND_MAP.put("changeset", "getChangeset");
        COMMAND_MAP.put("changesetBounds", "getChangesetBounds");
        COMMAND_MAP.put("changesets", "listChangesets");
        COMMAND_MAP.put("query", "query");
        COMMAND_MAP.put("tags", "listTagsForRevision");
    }
}

