/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.bucket;

import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.bucket.ParameterSet;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParameterSetRetrieve
extends ParameterSet {
    public final String[] authors;
    public final BreakdownOption breakdown;
    public final String[] extensions;

    public String getFormattedLabel() {
        return this.isTrunkLike() ? "(trunk)" : this.branch;
    }

    public boolean isTargetAuthor(String author) {
        for (String auth : this.authors) {
            if (!auth.equalsIgnoreCase(author)) continue;
            return true;
        }
        return false;
    }

    public boolean isNoBreakdown() {
        return this.breakdown == BreakdownOption.NONE;
    }

    public ParameterSetRetrieve(Path path, String branch, List<String> extensions, List<String> authors, BreakdownOption breakdown, boolean caseSensitive) {
        super(path, branch, caseSensitive);
        this.authors = this.checkAuthors(authors);
        this.breakdown = breakdown;
        this.extensions = this.checkExtensions(extensions);
    }

    public ParameterSetRetrieve(Path path, String branch, List<String> extensions, List<String> authors, boolean caseSensitive) {
        super(path, branch, caseSensitive);
        this.authors = this.checkAuthors(authors);
        this.breakdown = BreakdownOption.NONE;
        this.extensions = this.checkExtensions(extensions);
    }

    public ParameterSetRetrieve(Path path, String branch, List<String> extensions, boolean caseSensitive) {
        super(path, branch, caseSensitive);
        this.authors = new String[]{"__ALL_AUTHORS__"};
        this.breakdown = BreakdownOption.NONE;
        this.extensions = this.checkExtensions(extensions);
    }

    public ParameterSetRetrieve(Path path, String branch, String extension, String author, BreakdownOption breakdown, boolean caseSensitive) {
        super(path, branch, caseSensitive);
        this.authors = new String[]{this.checkAuthor(author)};
        this.breakdown = breakdown;
        this.extensions = new String[]{this.checkExtension(extension)};
    }

    public ParameterSetRetrieve(Path path, String branch, String extension, String author, boolean caseSensitive) {
        super(path, branch, caseSensitive);
        this.authors = new String[]{this.checkAuthor(author)};
        this.breakdown = BreakdownOption.NONE;
        this.extensions = new String[]{this.checkExtension(extension)};
    }

    public ParameterSetRetrieve(Path path, String branch, String extension, boolean caseSensitive) {
        super(path, branch, caseSensitive);
        this.authors = new String[]{"__ALL_AUTHORS__"};
        this.breakdown = BreakdownOption.NONE;
        this.extensions = new String[]{this.checkExtension(extension)};
    }

    public ParameterSetRetrieve(Path path, String branch, boolean caseSensitive) {
        super(path, branch, caseSensitive);
        this.authors = new String[]{"__ALL_AUTHORS__"};
        this.breakdown = BreakdownOption.NONE;
        this.extensions = new String[]{"__ALL_EXTENSIONS__"};
    }

    public ParameterSetRetrieve(Path path, boolean caseSensitive) {
        super(path, "__TRUNKLIKE__", caseSensitive);
        this.authors = new String[]{"__ALL_AUTHORS__"};
        this.breakdown = BreakdownOption.NONE;
        this.extensions = new String[]{"__ALL_EXTENSIONS__"};
    }

    @Override
    public String toString() {
        return "Parameters: path " + this.path + ", branch " + this.branch + ", authors " + Arrays.toString(this.authors) + ", extensions " + Arrays.toString(this.extensions) + ", breakdown " + (Object)((Object)this.breakdown);
    }

    private String[] checkAuthors(List<String> authors) {
        if (authors == null) {
            return new String[]{"__ALL_AUTHORS__"};
        }
        String[] authArray = new String[authors.size()];
        authors.toArray(authArray);
        for (int i2 = 0; i2 < authArray.length; ++i2) {
            authArray[i2] = this.checkAuthor(authArray[i2]);
        }
        return authArray;
    }

    private String checkAuthor(String author) {
        if (author == null) {
            return "__ALL_AUTHORS__";
        }
        if (author.equals("")) {
            return "__NO_AUTHOR__";
        }
        return author;
    }

    private String checkExtension(String extn) {
        if (extn == null) {
            return "__ALL_EXTENSIONS__";
        }
        if (extn.equals("")) {
            return "__NO_EXTENSION__";
        }
        return this.processExtension(extn);
    }

    private String[] checkExtensions(List<String> extns) {
        if (extns == null) {
            return new String[]{"__ALL_EXTENSIONS__"};
        }
        String[] extnArray = new String[extns.size()];
        extns.toArray(extnArray);
        for (int i2 = 0; i2 < extnArray.length; ++i2) {
            extnArray[i2] = this.checkExtension(extnArray[i2]);
        }
        return extnArray;
    }

    private String processExtension(String extension) {
        if (extension.equals("__NO_EXTENSION__") || extension.equals("__ALL_EXTENSIONS__")) {
            return extension;
        }
        int dot = extension.indexOf(".");
        if (dot > 0) {
            return extension.substring(dot);
        }
        if (dot < 0) {
            return "." + extension;
        }
        return extension;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum BreakdownOption {
        NONE,
        SUBDIR,
        AUTHOR,
        EXTN;

    }
}

