/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.bucket;

import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.util.Pair;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RenamingRules
implements Iterable<Pair<String, List<String>>> {
    private List<Pair<String, List<String>>> rules = new ArrayList<Pair<String, List<String>>>();

    public RenamingRules(String mRename) {
        try {
            this.rules = new ArrayList<Pair<String, List<String>>>();
            String rename = mRename + "";
            while (rename.contains("{")) {
                int open = rename.indexOf("{");
                int close = rename.indexOf("}");
                if (open > -1 && close > 0 && close > open) {
                    String sub = rename.substring(open + 1, close);
                    this.rules.add(this.parseRenameRule(sub));
                    rename = rename.substring(close + 1, rename.length());
                    continue;
                }
                rename = rename.substring(open + 1, rename.length());
            }
        }
        catch (RuntimeException e2) {
            Logs.APP_LOG.debug((Object)("Error parsing renaming rules string " + mRename), (Throwable)e2);
        }
    }

    private Pair<String, List<String>> parseRenameRule(String s) {
        int open = s.indexOf("(");
        int close = s.indexOf(")");
        String orig = s.substring(open + 1, close);
        ArrayList<String> list = new ArrayList<String>();
        while (orig.length() != 0) {
            int i2 = orig.indexOf("|");
            if (i2 < 0) {
                list.add(orig);
                orig = "";
                continue;
            }
            list.add(orig.substring(0, i2));
            orig = orig.substring(i2 + 1, orig.length());
        }
        return new Pair<String, List<String>>(s.substring(close + 1, s.length()), list);
    }

    @Override
    public Iterator<Pair<String, List<String>>> iterator() {
        return this.rules.iterator();
    }
}

