/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.cache;

import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.cache.RevisionCache;
import com.cenqua.fisheye.diff.Hunk;
import com.cenqua.fisheye.infinitydb.query3.AndQuery3;
import com.cenqua.fisheye.infinitydb.query3.AnyLongRangeQuery3;
import com.cenqua.fisheye.infinitydb.query3.Query3;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.lucene.LuceneConnection;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.DirInfo;
import com.cenqua.fisheye.rep.FileHistory;
import com.cenqua.fisheye.rep.FileRevision;
import com.cenqua.fisheye.rep.RevInfoKey;
import com.cenqua.fisheye.rep.impl.CommonDirInfoDAO;
import com.cenqua.fisheye.rep.impl.CommonQuery3Helper;
import com.cenqua.fisheye.rep.impl.CommonRevInfoDAO;
import com.cenqua.fisheye.rep.impl.CommonSchema;
import com.cenqua.fisheye.rep.impl.CommonStringTables;
import com.cenqua.fisheye.rep.impl.TagTreeVisitor;
import com.cenqua.obfuscate.idbk4uide._EntityClass;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseRevisionCache
implements RevisionCache {
    private final List<RevisionCache.CacheListener> listeners = new LinkedList<RevisionCache.CacheListener>();
    protected final RevisionCache.CacheListener eventMulticaster = new RevisionCache.CacheListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cacheUpdated() {
            List list = BaseRevisionCache.this.listeners;
            synchronized (list) {
                for (RevisionCache.CacheListener listener : BaseRevisionCache.this.listeners) {
                    listener.cacheUpdated();
                }
            }
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(RevisionCache.CacheListener l) {
        List<RevisionCache.CacheListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(l);
        }
    }

    @Override
    public FileRevision getLatestFileRevision(Path path) throws DbException {
        return null;
    }

    @Override
    public FileHistory getFileHistory(Path lpath) throws DbException {
        return this.getFileHistory(lpath, false);
    }

    @Override
    public FileHistory getFullFileHistory(Path lpath) throws DbException {
        return this.getFullFileHistory(lpath, false);
    }

    public RevisionCache.CacheListener getEventMulticaster() {
        return this.eventMulticaster;
    }

    @Override
    public List<String> findBranches(Path lpath) throws DbException {
        TreeSet<String> result = new TreeSet<String>();
        this.findMatchingStringTerms(lpath, CommonSchema.E_MOD_ON_BRANCH_TO_REVID, result);
        this.findMatchingStringTerms(lpath, CommonSchema.E_UNMOD_ON_BRANCH_TO_REVID, result);
        this.findMatchingStringTerms(lpath, CommonSchema.E_BP_ON_BRANCH_TO_REVID, result);
        return new ArrayList<String>(result);
    }

    @Override
    public List<String> findAuthors(Path lpath) throws DbException {
        LinkedList<String> result = new LinkedList<String>();
        this.findMatchingStringTerms(lpath, CommonSchema.E_AUTHOR_TO_REVID, result);
        return result;
    }

    private void findMatchingStringTerms(Path lpath, _EntityClass entity, final Collection<String> result) throws DbException {
        this.visitMatchingStringTerms(lpath, true, entity, new CommonQuery3Helper.StringVisitor(){

            public boolean visit(String term) {
                result.add(term);
                return true;
            }
        });
    }

    @Override
    public void visitMatchingStringTerms(Path dir, boolean findLogical, _EntityClass entity, CommonQuery3Helper.StringVisitor v) throws DbException {
        long t0 = System.currentTimeMillis();
        AndQuery3 q = this.findRevisionsUnderDirQuery3(dir, findLogical);
        CommonQuery3Helper.visitMatchingStringTerms(this.getInfDb().get(), q, entity, v);
        if (Logs.PERF_LOG.isDebugEnabled()) {
            long t1 = System.currentTimeMillis();
            Logs.PERF_LOG.debug((Object)("findMatching " + entity + " for /" + dir + (findLogical ? " logically" : "") + " computed in " + (t1 - t0) + "ms"));
        }
    }

    @Override
    public int countRevisions(Path path, long fromdate, long todate, Query3 matching) throws DbException {
        AndQuery3 query = CommonQuery3Helper.findRevisionsUnderDirQuery3(path, this.isCaseSensitive());
        query.addClause(new AnyLongRangeQuery3(CommonSchema.E_DATE_TO_REVID, fromdate, true, todate, true));
        if (matching != null) {
            query.addClause(matching);
        }
        LuceneConnection conn = null;
        return query.countMatches(this.getInfDb().get(), conn);
    }

    @Override
    public DirInfo findDirInfo(Path lpath) throws DbException {
        CommonDirInfoDAO dao = new CommonDirInfoDAO(this.getInfDb(), this.getCommonStringTables(), this.isCaseSensitive());
        return dao.load(lpath);
    }

    @Override
    public int findLastSuccessor(int revid) throws DbException {
        TagTreeVisitor v = new TagTreeVisitor(this.getInfDb().get());
        return v.findLastSuccessor(revid);
    }

    @Override
    public boolean isBefore(final int revIdA, int revIdB) throws DbException {
        TagTreeVisitor v = new TagTreeVisitor(this.getInfDb().get());
        final boolean[] result = new boolean[]{false};
        v.visitPredecessors(revIdB, new TagTreeVisitor.AncestorVisitor(){

            public boolean visitAncestor(int revid, int pred) {
                if (revid == revIdA) {
                    result[0] = true;
                    return false;
                }
                return true;
            }
        });
        return result[0];
    }

    @Override
    public boolean isAfter(int revIdA, int revIdB) throws DbException {
        if (revIdA == revIdB) {
            return false;
        }
        return this.isBefore(revIdB, revIdA);
    }

    @Override
    public List<Hunk> getHunks(RevInfoKey key) throws DbException {
        CommonRevInfoDAO dao = this.getCommonRevInfoDAO();
        int revid = dao.getRevId(key);
        return dao.getHunks(revid);
    }

    public abstract CommonStringTables getCommonStringTables();

    public abstract CommonRevInfoDAO getCommonRevInfoDAO() throws DbException;

    public abstract void touchLastModifiedDate() throws DbException;
}

