/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.cvsrep;

import com.cenqua.fisheye.cvsrep.ChangeTree;
import com.cenqua.fisheye.cvsrep.Chunk;
import com.cenqua.fisheye.cvsrep.ChunkList;
import com.cenqua.fisheye.cvsrep.Revision;
import com.cenqua.fisheye.cvsrep.RevisionEdge;
import com.cenqua.fisheye.rep.Blame;
import com.cenqua.fisheye.rep.FileHistory;
import com.cenqua.fisheye.rep.FileRevision;
import gnu.trove.TIntArrayList;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Annotator {
    private final ChangeTree mTree;
    private final List<FileRevision> mLines = new ArrayList<FileRevision>();
    private final TIntArrayList mOrigLineNumber = new TIntArrayList();
    private final List<Blame.BlameChunk> mChunks = new ArrayList<Blame.BlameChunk>();
    private final FileHistory hist;
    private Revision mRevision;

    public Annotator(FileHistory hist, ChangeTree aTree) {
        this.mTree = aTree;
        this.hist = hist;
    }

    public Revision getRevision() {
        return this.mRevision;
    }

    public void annotate(Revision aRev) {
        int i2;
        this.mRevision = aRev;
        List<Revision> ancestors = this.mTree.getAncestors(aRev);
        Revision r0 = ancestors.get(0);
        FileRevision info = this.hist.getRevision(r0.toString());
        int count = info.getLineCount();
        for (i2 = 0; i2 < count; ++i2) {
            this.mLines.add(info);
            this.mOrigLineNumber.add(i2);
        }
        for (i2 = 0; i2 < ancestors.size() - 1; ++i2) {
            Revision r1 = ancestors.get(i2);
            Revision r2 = ancestors.get(i2 + 1);
            this.annotateImpl(r1, r2);
        }
        Blame.BlameChunk last = null;
        int line = 0;
        for (int i3 = 0; i3 < this.mLines.size(); ++i3) {
            FileRevision r = this.mLines.get(i3);
            int originalLine = this.mOrigLineNumber.get(i3);
            if (last == null) {
                last = new Blame.BlameChunk(r, line, 0);
                this.mChunks.add(last);
            } else if (r == last.getInfo() && last.getLength() < 8000) {
                last.incLength(1);
            } else {
                last = new Blame.BlameChunk(r, line, originalLine);
                this.mChunks.add(last);
            }
            ++line;
        }
    }

    private void annotateImpl(Revision r1, Revision r2) {
        boolean reverse = false;
        RevisionEdge edge = new RevisionEdge(r1, r2);
        ChunkList hunks = this.mTree.getChange(edge);
        if (hunks == null) {
            reverse = true;
            edge = new RevisionEdge(r2, r1);
            hunks = this.mTree.getChange(edge);
        }
        assert (hunks != null) : "could not find edge between " + r1 + " and " + r2 + ", edge was " + edge;
        this.applyHunksToSpans(r2, hunks, reverse);
    }

    private void applyHunksToSpans(Revision aRev, ChunkList aHunks, boolean aReverse) {
        FileRevision info = this.hist.getRevision(aRev.toString());
        int doffset = aReverse ? 1 : 0;
        int aoffset = aReverse ? 0 : 1;
        int offset = 0;
        for (Chunk hunk : aHunks) {
            boolean isAdd = hunk.isAdd() ^ aReverse;
            int line = hunk.getLine() + offset - 1;
            int count = hunk.getCount();
            if (isAdd) {
                for (int j = 0; j < count; ++j) {
                    this.mLines.add(line + aoffset, info);
                    this.mOrigLineNumber.insert(line + aoffset, line + aoffset);
                    ++line;
                }
                offset += aReverse ? 0 : count;
                continue;
            }
            this.mLines.subList(line + doffset, line + count + doffset).clear();
            this.mOrigLineNumber.remove(line + doffset, count);
            offset -= aReverse ? 0 : count;
        }
    }

    public List<Blame.BlameChunk> getChunks() {
        return this.mChunks;
    }
}

