/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.cvsrep;

import com.cenqua.fisheye.cache.BaseRevisionCache;
import com.cenqua.fisheye.cache.RevisionCache;
import com.cenqua.fisheye.cache.RevisionCacheProperties;
import com.cenqua.fisheye.cvsrep.CvsRepository;
import com.cenqua.fisheye.cvsrep.CvsRepositoryConfig;
import com.cenqua.fisheye.cvsrep.cache.CachedCvsRepository;
import com.cenqua.fisheye.cvsrep.cache.CachedCvsRepositoryUpdater;
import com.cenqua.fisheye.cvsrep.cache.MutableRevisionInfoCache;
import com.cenqua.fisheye.cvsrep.cache.infdb.InfDbRevisionInfoCache;
import com.cenqua.fisheye.cvsrep.search.SearchManager;
import com.cenqua.fisheye.cvsrep.search.query.CVSQueryEvaluator;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.lucene.LuceneConnection;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.RepositoryEngine;
import java.io.File;
import java.io.IOException;
import org.apache.lucene.analysis.Analyzer;

public class CvsRepositoryEngine
extends RepositoryEngine {
    private static final String CACHE_VERSION = "13";
    private final CvsRepository mRepository;
    private final CvsRepositoryConfig mCvsCfg;
    private final File mIndexBaseDir;
    private final File mRevCacheDir;
    private final File mPropFile;
    private CachedCvsRepositoryUpdater mUpdater;
    private LuceneConnection mIndex;
    private InfDbRevisionInfoCache mRevCache;
    private CachedCvsRepository mRepositoryCache;
    private final SearchManager searchManager;
    private boolean wantInitialSlurp = false;

    public CvsRepositoryEngine(CvsRepositoryConfig cfg) {
        super(cfg);
        this.mCvsCfg = cfg;
        this.mRepository = new CvsRepository(cfg);
        this.mIndexBaseDir = new File(this.cacheDir, "idx");
        this.mRevCacheDir = new File(this.cacheDir, "revcache");
        this.mPropFile = new File(this.cacheDir, "cache.properties");
        this.searchManager = new SearchManager(new CVSQueryEvaluator(this));
    }

    public CvsRepositoryConfig getCvsCfg() {
        return this.mCvsCfg;
    }

    public void startEngine() throws IOException, DbException {
        this.upgradeIfNecessary();
        this.cacheDir.mkdirs();
        this.mRevCacheDir.mkdirs();
        CvsRepositoryEngine.checkIsDir(this.cacheDir);
        CvsRepositoryEngine.checkIsDir(this.mRevCacheDir);
        this.mIndex = new LuceneConnection(this.mIndexBaseDir, (Analyzer)this.cfg.getMasterAnalyzer(), 2);
        if (!this.mPropFile.exists()) {
            this.createdb();
            RevisionCacheProperties.createNew(this.mPropFile, CACHE_VERSION);
            this.wantInitialSlurp = true;
        } else {
            this.mIndex.killLuceneLocks();
        }
        this.mRevCache = new InfDbRevisionInfoCache();
        this.mRevCache.setCacheSize(this.getInfDbCacheSize());
        this.mRevCache.setCacheDir(this.mRevCacheDir);
        this.mRevCache.setCaseSensitive(true);
        this.mRevCache.open();
        this.mRepositoryCache = new CachedCvsRepository(this.mRevCache, this.mIndex, this.mRepository, this.getCfg().isContentIndexingEnabled());
        this.mRepositoryCache.setCacheSerialNumber(RevisionCacheProperties.readExisting(this.mPropFile).getSerial());
        this.mUpdater = new CachedCvsRepositoryUpdater(this);
    }

    protected boolean wantInitialSlurp() {
        return this.wantInitialSlurp;
    }

    public void rescan(String start, String end) throws UnsupportedOperationException, IllegalStateException {
        throw new UnsupportedOperationException("Rescan is not supported on CVS repositories");
    }

    public void doSlurp() {
        this.mUpdater.pingSlurp();
        this.getStatus().updateLastSlurpTime();
    }

    protected long getPollPeriod() {
        return 5000L;
    }

    private void createdb() throws DbException {
        Logs.APP_LOG.info((Object)("creating cache store for " + this.cfg.getName()));
        this.mIndex.createIndexes(true);
    }

    private void upgradeIfNecessary() throws IOException {
        RevisionCacheProperties props;
        if (this.mPropFile.isFile() && !CACHE_VERSION.equals((props = RevisionCacheProperties.readExisting(this.mPropFile)).getVersion())) {
            this.upgrade();
        }
    }

    private void upgrade() {
        Logs.APP_LOG.info((Object)("cache format has changed in this version, upgrading " + this.cacheDir));
        this.wantInitialSlurp = true;
        CvsRepositoryEngine.deleteCache(this.cfg);
    }

    public SearchManager getSearchManager() {
        return this.searchManager;
    }

    public CvsRepository getRepository() {
        return this.mRepository;
    }

    public MutableRevisionInfoCache makeDataCacheUpdater() throws DbException {
        return this.mRevCache;
    }

    public LuceneConnection getLuceneConnection() {
        return this.mIndex;
    }

    public CachedCvsRepository makeCachedCvsRepository() {
        return this.mRepositoryCache;
    }

    public RevisionCache getRevisionCache() {
        return this.mRepositoryCache;
    }

    protected BaseRevisionCache getBaseRevisionCache() {
        return this.mRepositoryCache;
    }

    public CachedCvsRepositoryUpdater getUpdater() {
        return this.mUpdater;
    }

    public void forceClose() {
        this.mIndex.close();
        this.mRevCache.reallyClose();
        Logs.APP_LOG.debug((Object)("Closed engine " + this.getName()));
    }

    public void requestFullscan() {
        this.getUpdater().requestFullscan();
    }
}

