/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.cvsrep;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Revision
implements Comparable<Revision> {
    private final int[] mNums;
    private final String mString;

    public Revision(String aNum) {
        this.mString = aNum;
        String[] strs = aNum.split("\\.");
        this.mNums = new int[strs.length];
        for (int i2 = 0; i2 < this.mNums.length; ++i2) {
            this.mNums[i2] = Integer.parseInt(strs[i2]);
        }
    }

    private Revision(int[] nums) {
        this.mNums = nums;
        StringBuffer str = new StringBuffer();
        String sep = "";
        for (int num : this.mNums) {
            str.append(sep).append(num);
            sep = ".";
        }
        this.mString = str.toString();
    }

    public Revision getMagicBranch() {
        if (this.mNums.length <= 1) {
            return this;
        }
        int[] nums = new int[this.mNums.length];
        System.arraycopy(this.mNums, 0, nums, 0, this.mNums.length);
        nums[this.mNums.length - 1] = nums[this.mNums.length - 2];
        nums[this.mNums.length - 2] = 0;
        return new Revision(nums);
    }

    Revision trimLast() {
        if (this.mNums.length <= 1) {
            return this;
        }
        int[] nums = new int[this.mNums.length - 1];
        System.arraycopy(this.mNums, 0, nums, 0, this.mNums.length - 1);
        return new Revision(nums);
    }

    Revision getBranchPointRevision2() {
        if (this.mNums.length == 0) {
            return this;
        }
        if (this.mNums.length <= 2) {
            return new Revision(Integer.toString(this.mNums[0]));
        }
        boolean odd = this.mNums.length % 2 == 1;
        long trim = odd ? 1L : 2L;
        StringBuffer str = new StringBuffer();
        String sep = "";
        int i2 = 0;
        while ((long)i2 < (long)this.mNums.length - trim) {
            int num = this.mNums[i2];
            str.append(sep).append(num);
            sep = ".";
            ++i2;
        }
        return new Revision(str.toString());
    }

    public boolean isBranchNumber() {
        return this.isNormalBranchNumber() || this.isMagicBranchNumber();
    }

    public boolean isNormalBranchNumber() {
        return this.mNums.length % 2 == 1;
    }

    public boolean isMagicBranchNumber() {
        return this.mNums.length % 2 == 0 && this.mNums[this.mNums.length - 2] == 0;
    }

    public String toString() {
        return this.mString;
    }

    public int hashCode() {
        return this.mString.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof Revision) {
            Revision o = (Revision)obj;
            return this.mString.equals(o.mString);
        }
        return false;
    }

    public int getNumCount() {
        return this.mNums.length;
    }

    @Override
    public int compareTo(Revision r) {
        int la = this.mNums.length;
        int lb = r.mNums.length;
        int minLen = Math.min(lb, la);
        for (int i2 = 0; i2 < minLen; ++i2) {
            int a2 = this.mNums[i2];
            int b2 = r.mNums[i2];
            if (a2 < b2) {
                return -1;
            }
            if (a2 <= b2) continue;
            return 1;
        }
        if (la < lb) {
            return -1;
        }
        if (la > lb) {
            return 1;
        }
        return 0;
    }

    public int commonPrefixCount(Revision aRevision) {
        int count;
        int[] otherNums = aRevision.mNums;
        int minLen = Math.min(this.mNums.length, otherNums.length);
        for (count = 0; count < minLen && this.mNums[count] == otherNums[count]; ++count) {
        }
        return count;
    }
}

