/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.cvsrep.quicksearch;

import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.cvsrep.quicksearch.FilenameQuickSearch;
import com.cenqua.fisheye.cvsrep.quicksearch.QuickSearchResults;
import com.cenqua.fisheye.infinitydb.UniqueStringTable;
import com.cenqua.fisheye.infinitydb.query3.AndQuery3;
import com.cenqua.fisheye.infinitydb.query3.TermQuery3;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.lucene.LuceneConnection;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.impl.CommonQuery3Helper;
import com.cenqua.fisheye.rep.impl.CommonSchema;
import com.cenqua.fisheye.svn.SvnLogicalPathMatcher;
import com.cenqua.fisheye.util.AntGlob;
import com.cenqua.obfuscate.idbk4uide._Cu;
import com.cenqua.obfuscate.idbk4uide._ItemSpace;
import gnu.trove.TLongHashSet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilenameSearch {
    private final _ItemSpace db;
    private final QuickSearchResults.TermResults matches;
    private final Path topPath;
    private final String term;
    private final SvnLogicalPathMatcher matcher;
    private final PathCollector filesFound;
    private final PathCollector dirsFound;
    private final AntGlob glob;
    private final String lcfilename;
    private final boolean containsDirSep;
    private boolean truncated = false;
    private boolean caseSensitive;

    public FilenameSearch(_ItemSpace db, QuickSearchResults.TermResults matches, Path topPath, String term, SvnLogicalPathMatcher matcher, boolean caseSensitive) {
        this.db = db;
        this.matches = matches;
        this.topPath = topPath;
        this.term = term;
        this.matcher = matcher;
        this.caseSensitive = caseSensitive;
        if (matcher == null) {
            this.filesFound = new NormalPathCollector();
            this.dirsFound = new NormalPathCollector();
        } else {
            this.filesFound = new LogicalPathCollector();
            this.dirsFound = new LogicalPathCollector();
        }
        this.glob = AntGlob.containsWildcards(term) ? new AntGlob(term) : new AntGlob("*" + term + "*");
        String filename = Path.parseName(term);
        this.lcfilename = filename.toLowerCase(Locale.US);
        this.containsDirSep = AntGlob.containsPathSeperator(term);
    }

    public void search() throws DbException, IOException {
        if (!this.containsDirSep) {
            long filenameid = UniqueStringTable.find(this.db, CommonSchema.E_LCFILENAMES, this.lcfilename);
            if (filenameid != -1L) {
                this.exactFilenameSearch(filenameid);
            } else {
                this.globFilenameSearch();
            }
        }
        if (this.containsDirSep || this.matches.getResultCount() == 0) {
            this.pathSearch();
        }
    }

    private void pathSearch() throws DbException {
        UniqueStringTable.Visitor v = new UniqueStringTable.Visitor(){
            _Cu row = _Cu.alloc();

            public boolean visit(long pathid, CharSequence str) {
                try {
                    if (FilenameSearch.this.glob.matches(str, false)) {
                        int type = FilenameSearch.this.fileTypeAtPath(this.row, pathid);
                        if (type == 1) {
                            FilenameSearch.this.filesFound.add(pathid, str);
                        } else if (type == 2) {
                            FilenameSearch.this.dirsFound.add(pathid, str);
                        }
                    }
                }
                catch (IOException e2) {
                    Logs.APP_LOG.info((Object)"problem in quicksearch", (Throwable)e2);
                }
                return FilenameSearch.this.keepSearching();
            }
        };
        UniqueStringTable.visit(this.db, CommonSchema.E_PATHS, v);
        this.addMatchingPaths(this.glob.pattern());
    }

    private void globFilenameSearch() throws DbException {
        UniqueStringTable.Visitor v = new UniqueStringTable.Visitor(){

            public boolean visit(long fnameid, CharSequence fname) {
                if (FilenameSearch.this.glob.matches(fname, false)) {
                    try {
                        FilenameSearch.this.mapFilenamesToPaths(fnameid);
                    }
                    catch (Exception e2) {
                        Logs.APP_LOG.info((Object)"problem doing quicksearch", (Throwable)e2);
                    }
                }
                return FilenameSearch.this.keepSearching();
            }
        };
        UniqueStringTable.visit(this.db, CommonSchema.E_LCFILENAMES, v);
        this.addMatchingPaths(this.glob.pattern());
    }

    private void exactFilenameSearch(long filenameid) throws DbException, IOException {
        this.mapFilenamesToPaths(filenameid);
        this.addMatchingPaths(this.term);
    }

    private void addMatchingPaths(String termUsed) {
        this.filesFound.addToMatches(termUsed, true);
        this.dirsFound.addToMatches(termUsed, false);
    }

    private int fileTypeAtPath(_Cu row, long pathid) throws IOException {
        row.clear();
        row.append(CommonSchema.E_PATH_ID_TO_REVID).append(pathid);
        int pl = row.length();
        if (this.db.next(row, pl)) {
            int revid = (int)row.longAt(pl);
            return this.fileTypeAtRev(row, revid);
        }
        row.clear().append(CommonSchema.DirInfo.ENTITY).append(pathid);
        pl = row.length();
        if (this.db.next(row, pl)) {
            return 2;
        }
        return -1;
    }

    private int fileTypeAtRev(_Cu row, int revid) throws IOException {
        row.clear();
        row.append(CommonSchema.RevInfo.ENTITY).append(revid).append(CommonSchema.RevInfo.A_FILETYPE);
        int pl = row.length();
        if (this.db.next(row, pl)) {
            return (int)row.longAt(pl);
        }
        return -1;
    }

    private void mapFilenamesToPaths(long filenameid) throws DbException, IOException {
        AndQuery3 q = CommonQuery3Helper.findRevisionsUnderDirQuery3(this.topPath, this.caseSensitive);
        q.addClause(new TermQuery3(CommonSchema.E_LCFILENAMEID_TO_REVID, filenameid, null));
        _ItemSpace revs = q.asItemSpace(this.db, (LuceneConnection)null);
        _Cu cu = _Cu.alloc();
        _Cu row = _Cu.alloc();
        while (revs.next(cu)) {
            int revid = (int)cu.longAt(0);
            row.clear();
            row.append(CommonSchema.RevInfo.ENTITY).append(revid).append(CommonSchema.RevInfo.A_REVKEY);
            int pl = row.length();
            if (this.db.next(row, pl)) {
                long pathid = row.longAt(pl);
                int type = this.fileTypeAtRev(row, revid);
                if (type == 1) {
                    this.filesFound.add(pathid);
                } else if (type == 2) {
                    this.dirsFound.add(pathid);
                }
            }
            if (this.keepSearching()) continue;
            break;
        }
    }

    private void addMatch(String term, List<Path> exactSubResults, boolean exactTruncated, boolean isFile, boolean sameLogicalsCollapsed) {
        FilenameQuickSearch.FilenameItemMatch match = new FilenameQuickSearch.FilenameItemMatch(term, exactSubResults.size(), exactSubResults, exactTruncated, isFile, sameLogicalsCollapsed);
        this.matches.addMatch(match);
    }

    private boolean keepSearching() {
        boolean stopSearching;
        boolean bl = stopSearching = this.filesFound.oversize || this.dirsFound.oversize;
        if (stopSearching) {
            this.truncated = true;
        }
        return !stopSearching;
    }

    class LogicalPathCollector
    extends PathCollector {
        LinkedHashMap<Path, List<Path>> map;

        LogicalPathCollector() {
            this.map = new LinkedHashMap();
        }

        int size() {
            return this.map.size();
        }

        void addImpl(long pathid, Path physicalPath) {
            Path logicalPath = FilenameSearch.this.matcher.getLogicalPath(physicalPath);
            Path key = logicalPath == null ? physicalPath : logicalPath;
            List<Path> l = this.map.get(key);
            if (l == null) {
                l = new LinkedList<Path>();
                l.add(physicalPath);
                this.map.put(key, l);
            } else if (FilenameSearch.this.matcher.getTrunk(physicalPath) != null) {
                l.add(0, physicalPath);
            } else {
                l.add(physicalPath);
            }
        }

        void addToMatches(String termUsed, boolean isfile) {
            if (!this.map.isEmpty()) {
                ArrayList<Path> result = new ArrayList<Path>(this.map.size());
                for (List<Path> l : this.map.values()) {
                    result.add(l.get(0));
                }
                boolean sameLogicalsCollapsed = result.size() != this.pathids.size();
                FilenameSearch.this.addMatch(termUsed, result, this.oversize || FilenameSearch.this.truncated, isfile, sameLogicalsCollapsed);
            }
        }
    }

    class NormalPathCollector
    extends PathCollector {
        final List<Path> paths;

        NormalPathCollector() {
            this.paths = new LinkedList<Path>();
        }

        int size() {
            return this.paths.size();
        }

        void addImpl(long pathid, Path path) {
            this.paths.add(path);
        }

        void addToMatches(String termUsed, boolean isfile) {
            if (!this.paths.isEmpty()) {
                FilenameSearch.this.addMatch(termUsed, this.paths, this.oversize || FilenameSearch.this.truncated, isfile, false);
            }
        }
    }

    abstract class PathCollector {
        final TLongHashSet pathids = new TLongHashSet();
        boolean oversize = false;

        PathCollector() {
        }

        abstract int size();

        abstract void addImpl(long var1, Path var3);

        abstract void addToMatches(String var1, boolean var2);

        void add(long pathid) throws DbException {
            String path = UniqueStringTable.get(FilenameSearch.this.db, CommonSchema.E_PATHS, pathid);
            this.add(pathid, path);
        }

        void add(long pathid, CharSequence path) {
            if (this.size() > 100) {
                this.oversize = true;
                return;
            }
            if (this.pathids.contains(pathid)) {
                return;
            }
            Path p = new Path(path);
            if (p.hasPrefix(FilenameSearch.this.topPath)) {
                this.pathids.add(pathid);
                this.addImpl(pathid, p);
            }
        }
    }
}

