/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.cvsrep.search;

import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.cache.RevisionCache;
import com.cenqua.fisheye.cvsrep.search.query.ReturnClause;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.FileRevision;
import com.cenqua.fisheye.util.StringUtil;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class SearchResults {
    protected final RevisionCache mRep;
    private int mPreTrunc = -1;
    private int mPostTrunc = -1;
    private ReturnClause metadata;

    protected SearchResults(RevisionCache mRep) {
        this.mRep = mRep;
    }

    public boolean isTruncated() {
        return this.mPreTrunc != -1;
    }

    public int getPreTruncateSize() {
        return this.isTruncated() ? this.mPreTrunc : this.size();
    }

    public int getPostTruncateSize() {
        return this.isTruncated() ? this.mPostTrunc : this.size();
    }

    public void wasTruncated(int oldSize, int newSize) {
        this.mPreTrunc = oldSize;
        this.mPostTrunc = newSize;
    }

    public abstract int size();

    public abstract RevisionResultsIterator iterateRevisions(int var1) throws DbException;

    public abstract boolean isGrouped();

    public void setMetaData(ReturnClause md) {
        this.metadata = md;
    }

    public ReturnClause getMetaData() {
        return this.metadata;
    }

    public boolean hasTabularResults() {
        return this.metadata != null;
    }

    public TabularResultsIterator iterateData(int start) throws DbException {
        if (!this.hasTabularResults()) {
            throw new DbException("Query has no return clause, so not tabular");
        }
        return new TabularResultsIterator(this.iterateRevisions(start));
    }

    public abstract String getType();

    public class TabularResultsIterator
    implements Iterator {
        private final RevisionResultsIterator i;

        public TabularResultsIterator(RevisionResultsIterator i2) {
            this.i = i2;
        }

        public boolean hasNext() {
            return this.i.hasNext();
        }

        public Object next() {
            try {
                return this.nextRow();
            }
            catch (Exception e2) {
                throw new RuntimeException(e2);
            }
        }

        public ResultRow nextRow() throws Exception {
            FileRevision fi = this.i.nextItem();
            return new ResultRow(fi);
        }

        public Object currentGroup() {
            return this.i.currentGroup();
        }

        public boolean isStartOfGroup() {
            return this.i.isStartOfGroup();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public class ResultRow {
        private final FileRevision fi;

        public ResultRow(FileRevision fi) {
            this.fi = fi;
        }

        public Object get(int i2) {
            return SearchResults.this.metadata.getField(i2).asObject(this.fi);
        }

        public Path getPath(int i2) {
            return SearchResults.this.metadata.getField(i2).asPath(this.fi);
        }

        public String getString(int i2) {
            return SearchResults.this.metadata.getField(i2).asString(this.fi);
        }

        public int getInt(int i2) {
            return SearchResults.this.metadata.getField(i2).asInt(this.fi);
        }

        public long getDate(int i2) {
            return SearchResults.this.metadata.getField(i2).asDate(this.fi);
        }

        public String[] getStringArray(int i2) {
            return SearchResults.this.metadata.getField(i2).asStringArray(this.fi);
        }

        public Map[] getMapArray(int i2) {
            return SearchResults.this.metadata.getField(i2).asMapArray(this.fi);
        }

        public List getList(int i2) {
            return SearchResults.this.metadata.getField(i2).asList(this.fi);
        }

        public String getStringFromArray(int i2) {
            String[] field = SearchResults.this.metadata.getField(i2).asStringArray(this.fi);
            return StringUtil.join(field, ", ");
        }
    }

    public abstract class RevisionResultsIterator
    implements Iterator {
        public Object next() {
            try {
                return this.nextItem();
            }
            catch (Exception e2) {
                throw new RuntimeException(e2);
            }
        }

        public abstract int nextItemId() throws Exception;

        public FileRevision nextItem() throws Exception {
            return SearchResults.this.mRep.getFileRevision(this.nextItemId());
        }

        public abstract Object currentGroup();

        public abstract boolean isStartOfGroup();

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

