/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.diff;

import com.cenqua.fisheye.diff.Diff;
import com.cenqua.fisheye.diff.Hunk;
import com.cenqua.fisheye.diff.HunkList;
import com.cenqua.fisheye.diff.RegionListDiffSequences;
import com.cenqua.fisheye.syntax.Region;
import com.cenqua.fisheye.syntax.RegionList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EDiff {
    private RegionListDiffSequences seq;
    private HunkList mHunks;
    private final List mA1;
    private final List mB1;

    public EDiff(CharSequence a2, CharSequence b2) {
        this.mA1 = this.makeBlock(a2);
        this.mB1 = this.makeBlock(b2);
        this.seq = new RegionListDiffSequences(this.mA1, a2, this.mB1, b2);
    }

    public void doDiff() {
        this.mHunks = Diff.diff(this.seq);
    }

    public int getTotalBlockLength() {
        return this.mA1.size() + this.mB1.size();
    }

    private List makeBlock(CharSequence a2) {
        ArrayList block = new ArrayList();
        this.splitInput(block, a2);
        return block;
    }

    private void splitInput(List positions, CharSequence input) {
        int i2 = 0;
        while (i2 < input.length()) {
            Region pos = null;
            char c2 = input.charAt(i2);
            if (EDiff.isWordChar(c2)) {
                int len = 1;
                while (i2 + len < input.length() && EDiff.isWordChar(input.charAt(i2 + len))) {
                    ++len;
                }
                pos = new Region(i2, i2 + len);
                positions.add(pos);
                i2 += len;
                continue;
            }
            if (Character.isWhitespace(c2)) {
                ++i2;
                continue;
            }
            pos = new Region(i2, i2 + 1);
            positions.add(pos);
            ++i2;
        }
    }

    public RegionList getOriginalRegions() throws IOException {
        HunkVisitor hv = new HunkVisitor(this.mA1){

            public void common(int fromStart, int toStart, int lenx, int leny, boolean skipPrevious) {
            }

            public void change(Hunk hunk) {
                this.process(hunk.getFrom(), hunk.getFromCount());
            }

            public void add(Hunk hunk) {
            }

            public void delete(Hunk hunk) {
                this.process(hunk.getFrom(), hunk.getFromCount());
            }
        };
        this.mHunks.visit(hv);
        return hv.regions;
    }

    public RegionList getRevisedRegions() throws IOException {
        HunkVisitor hv = new HunkVisitor(this.mB1){

            public void common(int fromStart, int toStart, int lenx, int leny, boolean skipPrevious) {
            }

            public void change(Hunk hunk) {
                this.process(hunk.getTo(), hunk.getToCount());
            }

            public void add(Hunk hunk) {
                this.process(hunk.getTo(), hunk.getToCount());
            }

            public void delete(Hunk hunk) {
            }
        };
        this.mHunks.visit(hv);
        return hv.regions;
    }

    private static boolean isWordChar(char c2) {
        return Character.isLetterOrDigit(c2);
    }

    private static abstract class HunkVisitor
    implements HunkList.Visitor {
        private final List mBlock;
        private RegionList regions = new RegionList();
        private final Map mChangeProps = new HashMap();

        public HunkVisitor(List block) {
            this.mBlock = block;
            this.mChangeProps.put("ediff", "changed");
        }

        protected void process(int start, int len) {
            for (int i2 = start; i2 < start + len; ++i2) {
                Region p = (Region)this.mBlock.get(i2);
                this.regions.add(new Region(p.getStart(), p.getEnd(), this.mChangeProps));
            }
        }
    }
}

