/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.infinitydb;

import com.cenqua.fisheye.infinitydb.CuPool;
import com.cenqua.fisheye.infinitydb.InfinityDbHandle;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.util.AntGlob;
import com.cenqua.fisheye.util.StringUtil;
import com.cenqua.fisheye.util.bitset.SegmentedIntSet;
import com.cenqua.fisheye.util.bitset.SortedIntSet;
import com.cenqua.obfuscate.idbk4uide._Attribute;
import com.cenqua.obfuscate.idbk4uide._CharacterLongObjectReader;
import com.cenqua.obfuscate.idbk4uide._CharacterLongObjectWriter;
import com.cenqua.obfuscate.idbk4uide._Cu;
import com.cenqua.obfuscate.idbk4uide._EntityClass;
import com.cenqua.obfuscate.idbk4uide._ItemSpace;
import com.cenqua.obfuscate.idbk4uide._k4uideIDB;
import gnu.trove.TLongArrayList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UniqueStringTable {
    public static final long NULL_ID = 0L;
    public static final long NOT_FOUND_ID = -1L;
    private static final _Attribute CURRENT_ID = new _Attribute(0L);
    private static final _Attribute PRIMARY = new _Attribute(1L);
    private static final _Attribute SECONDARY = new _Attribute(2L);
    private final Object ID_LOCK = new Object();
    private final InfinityDbHandle dbh;
    private final _EntityClass tableClass;

    public UniqueStringTable(InfinityDbHandle dbh, _EntityClass table) {
        this.dbh = dbh;
        this.tableClass = table;
    }

    public _EntityClass getTableClass() {
        return this.tableClass;
    }

    public List getAll(TLongArrayList ids) throws DbException {
        ArrayList<String> result = new ArrayList<String>(ids.size());
        for (int i2 = 0; i2 < ids.size(); ++i2) {
            long id = ids.get(i2);
            result.add(this.get(id));
        }
        return result;
    }

    public String get(long id) throws DbException {
        return UniqueStringTable.get(this.dbh.get(), this.tableClass, id);
    }

    public static String get(_ItemSpace db, _EntityClass tableClass, long id) throws DbException {
        try {
            if (id == 0L) {
                return null;
            }
            StringBuffer buf = new StringBuffer();
            UniqueStringTable.get(buf, db, tableClass, id);
            return buf.toString();
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void get(StringBuffer buf, _ItemSpace db, _EntityClass tableClass, long id) throws IOException {
        if (id == 0L) {
            return;
        }
        _Cu cu = null;
        try {
            int c2;
            cu = CuPool.alloc();
            cu.append(tableClass).append(PRIMARY).append(id);
            _CharacterLongObjectReader in = new _CharacterLongObjectReader(db, cu);
            while (-1 != (c2 = in.read())) {
                buf.append((char)c2);
            }
            in.close();
        }
        finally {
            CuPool.free(cu);
        }
    }

    public long find(String s) throws DbException {
        return UniqueStringTable.find(this.dbh.get(), this.tableClass, s);
    }

    public static long find(_ItemSpace db, _EntityClass tableClass, String s) throws DbException {
        if (s == null) {
            return 0L;
        }
        int hashcode = UniqueStringTable.hashcode(s);
        _Cu cu = _Cu.alloc();
        try {
            StringBuffer buf = new StringBuffer();
            cu.append(tableClass).append(SECONDARY).append(hashcode);
            int pkLen = cu.length();
            while (db.next(cu, pkLen)) {
                long sid = cu.longAt(pkLen);
                buf.setLength(0);
                UniqueStringTable.get(buf, db, tableClass, sid);
                if (!StringUtil.equal(s, buf)) continue;
                long l = sid;
                return l;
            }
            long l = -1L;
            return l;
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
        finally {
            cu.dispose();
        }
    }

    public SortedIntSet search(Pattern pat) throws DbException {
        return UniqueStringTable.search((_ItemSpace)this.dbh.get(), this.tableClass, pat);
    }

    public static SortedIntSet search(_ItemSpace db, _EntityClass tableClass, Pattern pat) throws DbException {
        final SegmentedIntSet result = new SegmentedIntSet();
        final Matcher matcher = pat.matcher("");
        UniqueStringTable.visit(db, tableClass, new Visitor(){

            public boolean visit(long id, CharSequence s) {
                if (s != null) {
                    matcher.reset(s);
                    if (matcher.find()) {
                        result.set((int)id);
                    }
                }
                return true;
            }
        });
        return result;
    }

    public SortedIntSet search(AntGlob pattern) throws DbException {
        return UniqueStringTable.search((_ItemSpace)this.dbh.get(), this.tableClass, pattern);
    }

    public static SortedIntSet search(_ItemSpace db, _EntityClass tableClass, final AntGlob pattern) throws DbException {
        final SegmentedIntSet result = new SegmentedIntSet();
        UniqueStringTable.visit(db, tableClass, new Visitor(){

            public boolean visit(long id, CharSequence str) {
                if (str != null && pattern.matches(str)) {
                    result.set((int)id);
                }
                return true;
            }
        });
        return result;
    }

    public static void visit(_ItemSpace db, _EntityClass tableClass, Visitor v) throws DbException {
        try {
            long t0 = System.currentTimeMillis();
            long max = UniqueStringTable.getMaxId(db, tableClass);
            StringBuffer buf = new StringBuffer();
            int id = 0;
            while ((long)id <= max) {
                buf.setLength(0);
                UniqueStringTable.get(buf, db, tableClass, id);
                boolean cont = v.visit(id, buf);
                if (!cont) break;
                ++id;
            }
            long t1 = System.currentTimeMillis();
            if (Logs.PERF_LOG.isDebugEnabled()) {
                Logs.PERF_LOG.debug((Object)("visited UST " + tableClass + "over " + id + " iterations in " + (t1 - t0) + "ms"));
            }
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long add(String s) throws DbException {
        try {
            Object object = this.ID_LOCK;
            synchronized (object) {
                long id = this.find(s);
                if (id != -1L) {
                    return id;
                }
                id = this.getNextID();
                this.addToPrimary(id, s);
                this.addToSecondary(id, s);
                return id;
            }
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    private void addToPrimary(long id, String s) throws IOException, DbException {
        _Cu cu = _Cu.alloc();
        cu.append(this.tableClass).append(PRIMARY).append(id);
        _CharacterLongObjectWriter out = new _CharacterLongObjectWriter(this.dbh.get(), cu);
        out.write(s);
        out.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToSecondary(long id, String s) throws DbException, IOException {
        int hashcode = UniqueStringTable.hashcode(s);
        _Cu cu = _Cu.alloc();
        try {
            _k4uideIDB db = this.dbh.get();
            cu.append(this.tableClass).append(SECONDARY);
            cu.append(hashcode).append(id);
            ((_ItemSpace)db).insert(cu);
        }
        finally {
            cu.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getNextID() throws DbException, IOException {
        Object object = this.ID_LOCK;
        synchronized (object) {
            long l;
            _Cu cu = _Cu.alloc();
            try {
                _k4uideIDB db = this.dbh.get();
                cu.append(this.tableClass).append(CURRENT_ID);
                int p1 = cu.length();
                long nextid = ((_ItemSpace)db).next(cu, p1) ? cu.longAt(p1) + 1L : 1L;
                cu.setLength(p1);
                cu.append(nextid);
                ((_ItemSpace)db).update(cu, p1);
                l = nextid;
                cu.dispose();
            }
            catch (Throwable throwable) {
                cu.dispose();
                throw throwable;
            }
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long getMaxId(_ItemSpace db, _EntityClass tableClass) throws IOException {
        _Cu cu = _Cu.alloc();
        try {
            cu.append(tableClass).append(CURRENT_ID);
            int p1 = cu.length();
            long nextid = db.next(cu, p1) ? cu.longAt(p1) + 1L : 1L;
            long l = nextid;
            return l;
        }
        finally {
            cu.dispose();
        }
    }

    private static int hashcode(String s) {
        int h2 = 0;
        int len = s.length();
        for (int i2 = 0; i2 < len; ++i2) {
            char c2 = s.charAt(i2);
            h2 = 31 * h2 + c2;
        }
        return h2;
    }

    public static interface Visitor {
        public boolean visit(long var1, CharSequence var3);
    }
}

