/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.license;

import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.config1.ConfigDocument;
import com.cenqua.fisheye.config1.LicenseType;
import com.cenqua.fisheye.license.LicenseException;
import com.cenqua.fisheye.license.LicenseHolder;
import com.cenqua.fisheye.license.LicenseInfo;
import com.cenqua.license.CenquaLicense;
import java.io.File;
import java.text.SimpleDateFormat;

public class LicenseLoader {
    private final File licenseDir;
    private final ConfigDocument.Config config;
    private boolean needsSave = false;

    public LicenseLoader(File licenseDir, ConfigDocument.Config config) {
        this.licenseDir = licenseDir;
        this.config = config;
    }

    public LicenseInfo loadAndValidate(boolean isCrucible) throws LicenseException {
        this.needsSave = false;
        LicenseHolder licenseHolder = this.readLicensesFromXml();
        if (!licenseHolder.hasFishEye()) {
            this.readFishEyeLicenseFromFileSystem(licenseHolder);
        }
        if (isCrucible && !licenseHolder.hasCrucible()) {
            this.readCrucibleLicenseFromFileSystem(licenseHolder);
        }
        this.validate(licenseHolder, isCrucible);
        return licenseHolder.toLicenseInfo();
    }

    public LicenseInfo updateLicensesFromXml(LicenseInfo info) throws LicenseException {
        LicenseHolder licenses = this.readLicensesFromXml();
        this.validate(licenses, AppConfig.isCrucible());
        if (licenses.hasCrucible() && licenses.hasFishEye()) {
            return new LicenseInfo(licenses.getFishEyeLicense(), licenses.getCrucibleLicense());
        }
        if (licenses.hasFishEye()) {
            return new LicenseInfo(licenses.getFishEyeLicense(), info.getCrucibleLicense());
        }
        if (licenses.hasCrucible()) {
            return new LicenseInfo(info.getFisheyeLicense(), licenses.getCrucibleLicense());
        }
        return info;
    }

    public boolean needsSave() {
        return this.needsSave;
    }

    protected void validate(LicenseHolder licenseHolder, boolean isCrucible) throws LicenseException {
        if (!licenseHolder.hasFishEye()) {
            throw new LicenseException("Could not find a FishEye license.");
        }
        if (!licenseHolder.canDecodeFishEye()) {
            throw new LicenseException("Your FishEye license is invalid.");
        }
        if (licenseHolder.isFishEyeTerminated()) {
            throw new LicenseException("Your FishEye license terminated on " + this.formatDate(licenseHolder.getFishEyeLicense().getSoftExpiry()));
        }
        if (!licenseHolder.isFishEyeValidForCurrentBuild()) {
            throw new LicenseException(licenseHolder.getFishEyeLicense().getInvalidBuildMessage());
        }
        if (isCrucible) {
            if (!licenseHolder.hasCrucible()) {
                throw new LicenseException("Could not find a Crucible license.");
            }
            if (!licenseHolder.canDecodeCrucible()) {
                throw new LicenseException("Your Crucible license is invalid.");
            }
            if (licenseHolder.isCrucibleTerminated()) {
                throw new LicenseException("Your Crucible license terminated on " + this.formatDate(licenseHolder.getCrucibleLicense().getSoftExpiry()));
            }
            if (!licenseHolder.isCrucibleValidForCurrentBuild()) {
                throw new LicenseException(licenseHolder.getCrucibleLicense().getInvalidBuildMessage());
            }
        }
    }

    private String formatDate(long expiredMs) {
        return new SimpleDateFormat("MMMM dd, yyyy").format(expiredMs);
    }

    protected void readFishEyeLicenseFromFileSystem(LicenseHolder licenseHolder) throws LicenseException {
        LicenseType licenseType;
        File fisheyeFile = new File(this.licenseDir, "fisheye.license");
        licenseHolder.setFeLicenseFile(fisheyeFile);
        if (licenseHolder.canDecodeFishEye() && !(licenseType = this.config.getLicense()).isSetFisheye() && !this.fromCenqua(licenseHolder.getFishEyeLicense())) {
            licenseType.setFisheye(licenseHolder.getFishEyeLicenseString());
            this.needsSave = true;
        }
    }

    protected void readCrucibleLicenseFromFileSystem(LicenseHolder licenseHolder) {
        LicenseType licenseType;
        File crucibleFile = new File(this.licenseDir, "crucible.license");
        licenseHolder.setCruLicenseFile(crucibleFile);
        if (licenseHolder.canDecodeCrucible() && !(licenseType = this.config.getLicense()).isSetCrucible() && !this.fromCenqua(licenseHolder.getCrucibleLicense())) {
            licenseType.setCrucible(licenseHolder.getCrucibleLicenseString());
            this.needsSave = true;
        }
    }

    protected LicenseHolder readLicensesFromXml() throws LicenseException {
        LicenseHolder licenseHolder = new LicenseHolder();
        LicenseType licenseConfig = this.config.getLicense();
        if (licenseConfig.isSetFisheye()) {
            licenseHolder.setFishEyeLicenseString(licenseConfig.getFisheye().trim());
        }
        if (licenseConfig.isSetCrucible()) {
            licenseHolder.setCrucibleLicenseString(licenseConfig.getCrucible().trim());
        }
        return licenseHolder;
    }

    private boolean fromCenqua(CenquaLicense license) {
        return "Cenqua".equals(license.getProperty("license.synthetic.license-origin"));
    }
}

