/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.mail;

import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.logging.Logs;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.apache.commons.lang.builder.ReflectionToStringBuilder;

public class MailMessage {
    public static final String CONTENT_TYPE_TEXT = "text/plain; charset=UTF-8";
    public static final String CONTENT_TYPE_HTML = "text/html; charset=UTF-8";
    private static final Pattern CUSTOM_SUBJECT_FORMAT = Pattern.compile("^Subject: *([^\\n\\r]*)(\\n\\r|\\r\\n|\\r|\\n){2}(.*)$", 32);
    private static final int SUBJECT_GROUP = 1;
    private static final int BODY_GROUP = 3;
    private String subject = "(no subject)";
    private String bodyText = "";
    private String contentType = "text/plain; charset=UTF-8";
    private List to = new LinkedList();
    private InternetAddress from;
    private String fromDisplayName;
    private boolean allowCustomBodyHeader = true;

    public void addRecipient(String address) {
        if (address != null) {
            this.to.add(address);
        }
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setBodyText(String contentType, String bodyText) {
        this.contentType = contentType;
        this.bodyText = bodyText;
    }

    public void overrideFromDisplayName(String fromDisplayName) {
        this.fromDisplayName = fromDisplayName;
    }

    public void setFrom(InternetAddress from) {
        this.from = from;
    }

    public void setAllowCustomBodyHeaders(boolean allow) {
        this.allowCustomBodyHeader = allow;
    }

    boolean send(Session session, InternetAddress defaultFrom) throws MessagingException {
        if (this.to.isEmpty()) {
            Logs.MAIL_LOG.info((Object)("No recipients specified for email with subject: " + this.subject));
            return false;
        }
        MimeMessage email = new MimeMessage(session);
        email.setHeader("X-Mailer", "Cenqua-" + AppConfig.getProductName());
        email.setSentDate(new Date());
        for (String addr : this.to) {
            email.addRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)addr, (boolean)false));
        }
        this.setupEmail(email);
        this.setupFrom(email, defaultFrom);
        Transport.send((Message)email);
        Logs.MAIL_LOG.info((Object)("Sent: to=" + Arrays.asList(email.getAllRecipients()) + ",from=" + Arrays.asList(email.getFrom()) + ",subject=''" + email.getSubject() + "'"));
        return true;
    }

    private void setupEmail(MimeMessage email) throws MessagingException {
        BodyHeaderParseResult result;
        email.setSubject(this.subject);
        email.setContent((Object)this.bodyText, this.contentType);
        if (this.allowCustomBodyHeader && (result = this.parseCustomBodyHeaders(this.bodyText)).hasSubjectHeader()) {
            email.setSubject(result.getSubject());
            email.setContent((Object)result.getBody(), this.contentType);
        }
    }

    private BodyHeaderParseResult parseCustomBodyHeaders(String bodyText) {
        Matcher matcher = CUSTOM_SUBJECT_FORMAT.matcher(bodyText);
        String customSubject = this.subject;
        String restofBody = this.bodyText;
        boolean hasCustomSubjectHeader = matcher.matches();
        if (hasCustomSubjectHeader) {
            customSubject = matcher.group(1);
            restofBody = matcher.group(3);
        }
        return new BodyHeaderParseResult(customSubject, restofBody, hasCustomSubjectHeader);
    }

    private void setupFrom(MimeMessage email, InternetAddress defaultFrom) throws MessagingException {
        InternetAddress addr;
        InternetAddress internetAddress = addr = this.from != null ? this.from : defaultFrom;
        if (addr != null) {
            if (this.fromDisplayName != null) {
                addr = (InternetAddress)addr.clone();
                try {
                    addr.setPersonal(this.fromDisplayName, "UTF-8");
                }
                catch (UnsupportedEncodingException e2) {
                    Logs.APP_LOG.warn((Object)"Character encoding problem setting personal from name.", (Throwable)e2);
                }
            }
            email.setFrom((Address)addr);
        }
    }

    public String toString() {
        return ReflectionToStringBuilder.reflectionToString((Object)this);
    }

    private static class BodyHeaderParseResult {
        private String subject;
        private String body;
        private boolean hasHeader = false;

        public BodyHeaderParseResult(String subject, String body, boolean hasHeader) {
            this.subject = subject;
            this.body = body;
            this.hasHeader = hasHeader;
        }

        public String getSubject() {
            return this.subject;
        }

        String getBody() {
            return this.body;
        }

        boolean hasSubjectHeader() {
            return this.hasHeader;
        }
    }
}

