/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.perforce.search;

import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.cache.RevisionCache;
import com.cenqua.fisheye.cvsrep.search.query.BaseQueryEvaluator;
import com.cenqua.fisheye.cvsrep.search.query.Clause;
import com.cenqua.fisheye.cvsrep.search.query.FishQuery;
import com.cenqua.fisheye.infinitydb.query3.AndQuery3;
import com.cenqua.fisheye.infinitydb.query3.Query3;
import com.cenqua.fisheye.lucene.LuceneConnection;
import com.cenqua.fisheye.perforce.P4Cache;
import com.cenqua.fisheye.perforce.search.P4QueryBuilder;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.impl.CommonQuery3Helper;
import java.io.IOException;

public class P4QueryEvaluator
extends BaseQueryEvaluator {
    private P4Cache cache;

    public P4QueryEvaluator(P4Cache cache) {
        this.cache = cache;
    }

    protected RevisionCache getRevisionCache() {
        return this.cache;
    }

    protected LuceneConnection getLuceneConnection() {
        return this.cache.getLuceneConnection();
    }

    protected AndQuery3 createQuery3(FishQuery query) throws IOException, DbException {
        Path fromPath = query.getFromPath();
        if (fromPath == null) {
            fromPath = new Path();
        }
        AndQuery3 bq = CommonQuery3Helper.findRevisionsUnderDirQuery3(fromPath, this.isCaseSensitive());
        Clause where = query.getWhereClause();
        if (where != null) {
            P4QueryBuilder qb = new P4QueryBuilder(this.cache);
            where.accept(qb);
            Query3 q = qb.getQuery();
            if (q != null) {
                bq.addClause(q);
            }
        }
        return bq;
    }
}

