/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.rep;

import com.cenqua.fisheye.cache.RevisionCache;
import com.cenqua.fisheye.cache.RevisionCacheProperties;
import com.cenqua.fisheye.config.ConfigException;
import com.cenqua.fisheye.cvsrep.search.SearchManager;
import com.cenqua.fisheye.infinitydb.InfinityDbHandle;
import com.cenqua.fisheye.infinitydb.InfinityDbUtil;
import com.cenqua.fisheye.io.IOHelper;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.lucene.LuceneConnection;
import com.cenqua.fisheye.rep.AuthorLinecountCalculator;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.RepositoryCache;
import com.cenqua.fisheye.rep.RepositoryClientException;
import com.cenqua.fisheye.rep.RepositoryIndexer;
import com.cenqua.fisheye.rep.RepositoryInfo;
import com.cenqua.fisheye.rep.RepositoryStatus;
import com.cenqua.fisheye.rep.RevListCache;
import com.cenqua.fisheye.rep.impl.UpgradeDataFilenameSearch;
import com.cenqua.fisheye.util.Timer;
import com.cenqua.fisheye.util.bitset.SortedIntSet;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.lucene.analysis.Analyzer;

public abstract class RepositoryScanner {
    private long commitBlockSize = 100L;
    private final RepositoryStatus statusReporter;
    private Analyzer masterAnalyzer;
    private LuceneConnection connection;
    private InfinityDbHandle dbh;
    private RepositoryIndexer indexer;
    private RepositoryCache cache;
    private File cacheDir;
    private File indexBaseDir;
    private File revCacheDir;
    private File propFile;
    private volatile boolean isPaused = false;
    private volatile boolean isStarted = false;
    private long pauseStartTime = -1L;
    private static final long PAUSE_PERIOD = 120000L;
    private String repoName;
    private volatile ReentrantLock repositoryAccess;
    private RevisionCache.CacheListener cacheListener;
    private long cacheSize = 0x500000L;
    private SearchManager searchManager;
    private final RepositoryInfo repositoryInfo;
    private RevListCache revListCache = new RevListCache();
    public static final String IMPORT_NONE = "none";
    public static final String IMPORT_WITHOUT_TAGS = "notags";
    private boolean caseSensitive;

    public RepositoryScanner(String name, RepositoryInfo repInfo, RepositoryStatus status, boolean caseSensitive) {
        this.repoName = name;
        this.repositoryInfo = repInfo;
        this.statusReporter = status;
        this.indexer = new RepositoryIndexer();
        this.repositoryAccess = new ReentrantLock();
        this.caseSensitive = caseSensitive;
    }

    protected void setCache(RepositoryCache cache) {
        this.cache = cache;
        this.setCacheListener(cache.getEventMulticaster());
    }

    public void setSearchManager(SearchManager searchManager) {
        this.searchManager = searchManager;
    }

    public void setMasterAnalyzer(Analyzer masterAnalyzer) {
        this.masterAnalyzer = masterAnalyzer;
    }

    public void setFailFast(boolean failFast) {
        this.indexer.setFailFast(failFast);
    }

    public void setCacheDir(File cacheDir) {
        this.cacheDir = cacheDir;
        this.indexBaseDir = new File(cacheDir, "idx");
        this.revCacheDir = new File(cacheDir, "revcache");
        this.propFile = new File(cacheDir, "cache.properties");
    }

    private void upgradeIfNecessary(File propsFile, String cacheVersion) throws IOException {
        RevisionCacheProperties props;
        String currentVersion;
        if (propsFile.isFile() && !cacheVersion.equals(currentVersion = (props = RevisionCacheProperties.readExisting(propsFile)).getVersion())) {
            this.upgrade();
        }
    }

    protected void notifyUpdate() {
        if (this.cacheListener != null) {
            this.cacheListener.cacheUpdated();
        }
    }

    private void upgrade() {
        Logs.APP_LOG.info((Object)("Repository cache format has changed in this version, upgrading " + this.cacheDir));
        IOHelper.recursiveDelete(this.cacheDir, 2);
    }

    public void start() throws IOException, DbException {
        this.upgradeIfNecessary(this.propFile, this.getCacheVersion());
        this.cacheDir.mkdirs();
        this.revCacheDir.mkdirs();
        this.connection = new LuceneConnection(this.indexBaseDir, this.masterAnalyzer, 2);
        if (!this.propFile.exists()) {
            RevisionCacheProperties.createNew(this.propFile, this.getCacheVersion());
            this.connection.createIndexes(true);
        } else {
            this.connection.killLuceneLocks();
        }
        File dbfile = new File(this.revCacheDir, "data.bin");
        InfinityDbUtil.createIfNeccessary(dbfile);
        this.dbh = new InfinityDbHandle(dbfile, this.cacheSize);
        this.isPaused = false;
        this.cache.setCacheSerialNumber(RevisionCacheProperties.readExisting(this.propFile).getSerial());
        this.cache.setDatabase(this.getDB());
        this.cache.setLuceneConnection(this.getLuceneConnection());
        this.cache.setMasterAnalyzer(this.getMasterAnalyzer());
        this.cache.start();
        this.indexer.setConnection(this.getLuceneConnection());
    }

    public RepositoryStatus getStatus() {
        return this.statusReporter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void optimize() throws DbException {
        this.statusReporter.setMessage("Optimizing index");
        try {
            this.connection.optimize();
        }
        finally {
            this.statusReporter.setMessage("");
        }
    }

    public boolean wantsInitialSlurp() {
        try {
            return !this.cache.isInitialScanDone();
        }
        catch (DbException e2) {
            return true;
        }
    }

    public void setCacheSize(long cacheSize) {
        this.cacheSize = cacheSize;
    }

    public LuceneConnection getLuceneConnection() {
        return this.connection;
    }

    public void forceClose() {
        this.connection.close();
        try {
            this.dbh.close();
        }
        catch (IOException e2) {
            Logs.APP_LOG.error((Object)"Unable to close database", (Throwable)e2);
        }
    }

    public Analyzer getMasterAnalyzer() {
        return this.masterAnalyzer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ping() throws DbException, ConfigException {
        try {
            this.getStatus().setRefreshing(true);
            this.getStatus().setMessage("Contacting repository.");
            if (!this.getStatus().isDoneFullSlurp()) {
                this.upgradeSearchData();
                Logs.CONSOLE.info((Object)("starting initial scan of repository " + this.repoName));
            }
            Logs.PERF_LOG.info((Object)("processing /" + this.repoName));
            long t0 = System.currentTimeMillis();
            boolean slurpSuccessful = this.slurp();
            long t1 = System.currentTimeMillis();
            Logs.PERF_LOG.info((Object)("done slurp for /" + this.repoName + " time = " + (t1 - t0) + "ms"));
            if (!this.getStatus().isDoneFullSlurp() && slurpSuccessful) {
                Logs.CONSOLE.info((Object)("finished initial scan of repository " + this.repoName + " in " + (t1 - t0) / 1000L + "s"));
                this.getStatus().setDoneFullSlurp(true);
            }
        }
        finally {
            this.getStatus().setRefreshing(false);
            this.getStatus().setMessage("");
        }
    }

    private void upgradeSearchData() throws DbException {
        UpgradeDataFilenameSearch up = new UpgradeDataFilenameSearch(this.repoName, this.getStatus(), this.cache.getInfDb(), this.cache.getCommonStringTables(), this.caseSensitive);
        up.upgradeIfNecessary();
        up.initAndUpgradeBuckets(this.cache);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean slurp() throws ConfigException, DbException {
        if (this.getStatus().isStopRequested()) {
            this.getStatus().setEngineError("");
            this.getStatus().setMessage("");
            return false;
        }
        boolean slurpComplete = false;
        if (!this.isStarted) {
            this.startRepo();
            if (!this.isStarted) {
                return false;
            }
        }
        if (!this.accessRepository(0L)) {
            Logs.APP_LOG.info((Object)"Slurp abandoned as repository is currently locked by another operation");
            return false;
        }
        boolean rollbackRequired = true;
        try {
            if (this.isPaused) {
                long pauseTime = System.currentTimeMillis() - this.pauseStartTime;
                if (pauseTime <= 120000L) {
                    long remaining = (120000L - pauseTime) / 1000L;
                    String error = remaining <= 1L ? "Repository scanner paused - resumption imminent" : "Repository scanner paused - resuming in " + remaining + " seconds";
                    this.getStatus().setEngineError(error);
                    Logs.CONSOLE.info((Object)(this.repositoryInfo.getRepositoryDescriptor() + error));
                    boolean bl = false;
                    return bl;
                }
                Logs.CONSOLE.info((Object)("Repository " + this.repositoryInfo.getRepositoryDescriptor() + " resuming from pause"));
                this.getStatus().setEngineError("");
                this.isPaused = false;
            }
            Logs.APP_LOG.info((Object)("Starting slurp of " + this.repositoryInfo.getRepositoryDescriptor()));
            this.slurpRepository();
            this.getStatus().setMessage(" ");
            if (!this.getStatus().isStopRequested()) {
                slurpComplete = true;
            }
            rollbackRequired = false;
        }
        catch (Throwable e2) {
            if (e2 instanceof ConfigException) {
                throw (ConfigException)e2;
            }
            Logs.APP_LOG.error((Object)("Problem processing revisions from repo " + this.repositoryInfo.getRepositoryDescriptor() + " due to " + e2.getClass() + " - " + e2.getMessage()), e2);
            Logs.APP_LOG.error((Object)"Repository scanner paused.");
            this.isPaused = true;
            this.getStatus().setEngineError("Repository paused due to error - " + e2.getClass() + ": " + e2.getMessage());
            this.pauseStartTime = System.currentTimeMillis();
        }
        finally {
            if (rollbackRequired) {
                Logs.APP_LOG.debug((Object)"Rolling back cache changes");
                this.cache.rollback();
            }
            this.releaseRepository();
        }
        if (this.getStatus().isStopRequested()) {
            try {
                Logs.APP_LOG.debug((Object)"Committing cache changes");
                this.dbh.commit();
            }
            catch (IOException e3) {
                throw new DbException(e3);
            }
        }
        return slurpComplete;
    }

    private void startRepo() {
        try {
            this.validateRepo();
            this.isStarted = true;
            this.getStatus().setEngineError("");
        }
        catch (Throwable t) {
            String message = "Unable to initialise repository " + this.repositoryInfo.getRepositoryDescriptor() + " due to " + t.getClass().getName() + ":" + t.getMessage();
            Logs.APP_LOG.error((Object)message, t);
            this.getStatus().setEngineError(message);
        }
    }

    protected boolean accessRepository(long waitTime) throws DbException {
        try {
            return this.repositoryAccess.tryLock(waitTime, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e2) {
            throw new DbException("Unable to acquire repository access ", e2);
        }
    }

    protected void releaseRepository() {
        this.repositoryAccess.unlock();
    }

    public InfinityDbHandle getDB() {
        return this.dbh;
    }

    public void setCacheListener(RevisionCache.CacheListener cacheListener) {
        this.cacheListener = cacheListener;
    }

    protected void slurpRepository() throws DbException, ConfigException, IOException, RepositoryClientException {
        this.validateAccess();
        long indexingState = this.cache.getIndexingPhase();
        boolean updateOccurred = false;
        if (indexingState == 0L) {
            if (this.processRevisions()) {
                updateOccurred = true;
            }
            indexingState = this.cache.getIndexingPhase();
        }
        if (indexingState == 1L) {
            if (this.processMetadata()) {
                updateOccurred = true;
            }
            indexingState = this.cache.getIndexingPhase();
        }
        if (indexingState == 2L && this.processContent()) {
            updateOccurred = true;
        }
        this.statusReporter.updateLastSlurpTime();
        if (updateOccurred) {
            new AuthorLinecountCalculator(this.cache, this.getStatus(), this.repoName).calcBlame();
            this.notifyUpdate();
        }
    }

    private boolean processRevisions() throws RepositoryClientException, DbException, ConfigException {
        boolean initalSlurp;
        long startRevision;
        boolean storeDiffs;
        boolean createOnDemand;
        long firstRev;
        boolean updateOccurred = false;
        RepositoryInfo repositoryInfo = this.getRepositoryInfo();
        if (this.cache.getPhase1Revision() == 0L) {
            firstRev = this.getFirstRevision();
            createOnDemand = this.determineCreateOnDemand(firstRev);
            if (firstRev < repositoryInfo.getStartRev()) {
                firstRev = repositoryInfo.getStartRev();
            }
            this.cache.setScanProperty("StoreDiffs", (storeDiffs = repositoryInfo.isStoreDiffs()) ? 1L : 0L);
            startRevision = firstRev;
            initalSlurp = true;
        } else {
            initalSlurp = false;
            startRevision = this.cache.getPhase1Revision() + 1L;
            if (this.cache.hasScanProperty("CreateOnDemand")) {
                createOnDemand = this.cache.getScanProperty("CreateOnDemand", 0L) == 1L;
            } else {
                firstRev = this.getFirstRevision();
                createOnDemand = this.determineCreateOnDemand(firstRev);
            }
            if (this.cache.hasScanProperty("StoreDiffs")) {
                storeDiffs = this.cache.getScanProperty("StoreDiffs", 0L) == 1L;
            } else {
                storeDiffs = false;
                this.cache.setScanProperty("StoreDiffs", 0L);
            }
        }
        repositoryInfo.setStoreDiffs(storeDiffs);
        this.setCreateOnDemand(createOnDemand);
        long latestRevision = this.getLatestRevision();
        if (repositoryInfo.getStartRev() > latestRevision) {
            throw new ConfigException("The start-rev value [" + repositoryInfo.getStartRev() + "] is not in the repository range [" + latestRevision + "]");
        }
        if (initalSlurp && createOnDemand && !repositoryInfo.getImportMode().equals(IMPORT_NONE)) {
            long start = startRevision - 1L;
            if (start < 0L) {
                start = 1L;
            }
            this.updateRevList(start, startRevision);
            this.createInitialImport(this.revListCache, startRevision);
        }
        this.updateRevList(startRevision, latestRevision);
        this.getStatus().setEngineError("");
        long commitBlockSize = this.getCommitBlockSize();
        while (!this.revListCache.isEmpty() && !this.getStatus().isStopRequested()) {
            long start = this.revListCache.getStartRevision();
            long end = this.revListCache.getBlockEnd(commitBlockSize);
            this.slurpRevisionBlock(start, end);
            if (!this.getStatus().isStopRequested()) {
                this.getStatus().setMessage("Committing changes from " + start + " - " + end);
                Logs.APP_LOG.debug((Object)("Committing changes up to revision " + end));
                this.cache.setPhase1Revision(end);
                this.cache.commit();
                updateOccurred = true;
                this.revListCache.removeUpto(end + 1L);
                if (!this.revListCache.isEmpty()) continue;
                this.updateRevList(end + 1L, latestRevision);
                continue;
            }
            this.cache.rollback();
        }
        if (!this.getStatus().isStopRequested() && this.processTags()) {
            this.cache.commit();
            updateOccurred = true;
        }
        if (!this.getStatus().isStopRequested() && updateOccurred) {
            this.cache.setIndexingPhase(1L);
            this.cache.commit();
        }
        return updateOccurred;
    }

    private boolean determineCreateOnDemand(long firstRev) throws DbException {
        boolean createOnDemand = firstRev < this.repositoryInfo.getStartRev();
        this.cache.setScanProperty("CreateOnDemand", createOnDemand ? 1L : 0L);
        return createOnDemand;
    }

    private boolean processMetadata() throws DbException, RepositoryClientException, IOException {
        long latestRevision;
        long startRevision;
        boolean updateOccurred = false;
        if (!this.getStatus().isStopRequested() && (startRevision = this.cache.getPhase2Revision() + 1L) <= (latestRevision = this.cache.getPhase1Revision())) {
            this.indexMetadata(startRevision, latestRevision);
            if (!this.getStatus().isStopRequested()) {
                this.cache.commit();
                updateOccurred = true;
            } else {
                this.cache.rollback();
            }
        }
        if (!this.getStatus().isStopRequested()) {
            this.cache.setIndexingPhase(2L);
            this.cache.commit();
        }
        return updateOccurred;
    }

    private boolean processContent() throws DbException, IOException {
        long latestRevision;
        long startRevision;
        boolean updateOccurred = false;
        if (!this.getStatus().isStopRequested() && (startRevision = this.cache.getPhase2Revision() + 1L) <= (latestRevision = this.cache.getPhase1Revision())) {
            this.indexContent(startRevision, latestRevision);
            if (!this.getStatus().isStopRequested()) {
                this.cache.setPhase2Revision(latestRevision);
                this.cache.commit();
                updateOccurred = true;
            } else {
                this.cache.rollback();
            }
        }
        if (!this.getStatus().isStopRequested()) {
            if (!this.cache.isInitialScanDone()) {
                this.cache.markInitialScanDone();
            }
            this.cache.setIndexingPhase(0L);
            this.cache.commit();
        }
        return updateOccurred;
    }

    private void updateRevList(long startRevision, long endRevision) throws RepositoryClientException {
        Map newEntries;
        this.revListCache.removeUpto(startRevision);
        long lastCached = this.revListCache.getEndRevision();
        if (lastCached == endRevision) {
            return;
        }
        long searchStart = lastCached == -1L ? startRevision : lastCached + 1L;
        if (searchStart <= endRevision && (newEntries = this.getRevList(searchStart, endRevision)) != null) {
            this.revListCache.add(newEntries);
        }
    }

    public RepositoryInfo getRepositoryInfo() {
        return this.repositoryInfo;
    }

    public RepositoryCache getCache() {
        return this.cache;
    }

    protected RepositoryIndexer getIndexer() {
        return this.indexer;
    }

    public SearchManager getSearchManager() {
        return this.searchManager;
    }

    protected void clearSetUpto(SortedIntSet set, long index) {
        int i2 = set.nextSetBit(0);
        while (i2 >= 0 && (long)i2 <= index) {
            set.clear(i2);
            i2 = set.nextSetBit(i2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void indexMetadata(long startRevision, long endRevision) throws DbException, RepositoryClientException {
        Timer timer = new Timer("Indexing revision metadata from changeset " + startRevision + ":" + endRevision);
        this.getStatus().setMessage("Indexing revision metadata from changeset " + startRevision + " to " + endRevision);
        SortedIntSet revids = this.getRevidsInChangeSetRange(startRevision, endRevision);
        long lastRevid = this.getCache().getScanProperty("LastMetadataRevid", -1L);
        if (lastRevid != -1L) {
            this.clearSetUpto(revids, lastRevid);
        }
        this.getIndexer().deleteMetaData(revids);
        boolean indexedOk = false;
        try {
            this.indexRevisions(revids);
            if (!this.getStatus().isStopRequested()) {
                indexedOk = true;
            }
        }
        finally {
            if (!indexedOk) {
                this.getIndexer().deleteMetaData(revids);
            }
        }
        timer.end();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void indexContent(long startRevision, long endRevision) throws DbException, IOException {
        Timer timer = new Timer("Indexing content " + startRevision + ":" + endRevision);
        if (this.getRepositoryInfo().isContentIndexingEnabled()) {
            this.getStatus().setMessage("Indexing content from changeset " + startRevision + " to " + endRevision);
            SortedIntSet physicalPaths = this.getPhysicalPaths(startRevision, endRevision);
            long lastPathId = this.getCache().getScanProperty("LastContentRevid", -1L);
            if (lastPathId != -1L) {
                this.clearSetUpto(physicalPaths, lastPathId);
            }
            boolean indexedOk = false;
            try {
                this.deleteContent(physicalPaths);
                this.indexUpdatedContent(physicalPaths);
                if (!this.getStatus().isStopRequested()) {
                    indexedOk = true;
                }
            }
            finally {
                if (!indexedOk) {
                    this.deleteContent(physicalPaths);
                }
            }
        }
        timer.end();
    }

    private void deleteContent(SortedIntSet physicalPaths) throws DbException {
        SortedIntSet outdatedRevids = this.getPathRevids(physicalPaths);
        this.getIndexer().deleteContent(outdatedRevids);
    }

    protected long getCommitBlockSize() {
        return this.commitBlockSize;
    }

    public void setCommitBlockSize(long commitBlockSize) {
        this.commitBlockSize = commitBlockSize;
    }

    protected abstract long slurpRevisionBlock(long var1, long var3) throws DbException, RepositoryClientException;

    protected abstract long getFirstRevision() throws RepositoryClientException;

    protected abstract String getCacheVersion();

    protected abstract void validateRepo() throws ConfigException;

    protected abstract long getLatestRevision() throws RepositoryClientException, ConfigException;

    protected abstract boolean processTags() throws RepositoryClientException, DbException;

    protected abstract void setCreateOnDemand(boolean var1);

    protected abstract void createInitialImport(RevListCache var1, long var2) throws DbException;

    protected abstract void validateAccess() throws ConfigException;

    protected abstract Map getRevList(long var1, long var3) throws RepositoryClientException;

    protected abstract void indexRevisions(SortedIntSet var1) throws DbException;

    protected abstract SortedIntSet getRevidsInChangeSetRange(long var1, long var3) throws DbException;

    protected abstract SortedIntSet getPathRevids(SortedIntSet var1) throws DbException;

    protected abstract SortedIntSet getPhysicalPaths(long var1, long var3) throws DbException;

    protected abstract void indexUpdatedContent(SortedIntSet var1) throws DbException, IOException;
}

