/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.rep.impl;

import com.cenqua.fisheye.infinitydb.InfinityDbHandle;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.impl.CommonSchema;
import com.cenqua.fisheye.rep.impl.CommonStringTables;

public class CommonUtilDAO {
    private final InfinityDbHandle dbh;
    private final CommonStringTables stringTables;

    public CommonUtilDAO(InfinityDbHandle dbh, CommonStringTables stringTables) {
        this.dbh = dbh;
        this.stringTables = stringTables;
    }

    public void setLongProperty(String key, long value) throws DbException {
        this.dbh.setLongProperty(CommonSchema.E_INDEXING_PROPS, this.stringTables.propKeyDB, key, value);
    }

    public long getLongProperty(String key, long defaultValue) throws DbException {
        return this.dbh.getLongProperty(CommonSchema.E_INDEXING_PROPS, this.stringTables.propKeyDB, key, defaultValue);
    }

    public boolean hasProperty(String key) throws DbException {
        return this.dbh.hasLongProperty(CommonSchema.E_INDEXING_PROPS, this.stringTables.propKeyDB, key);
    }
}

