/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.rep.impl;

import com.cenqua.fisheye.io.IOHelper;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.vis.LinecountCollator;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

public class LocCacheDAO {
    private final File mBaseDir;
    private static final String SUFFIX = ".bin";

    public LocCacheDAO(File baseDir) {
        if (baseDir == null || !baseDir.isDirectory() || !baseDir.exists()) {
            throw new IllegalArgumentException("Base directory: " + baseDir + " is not a valid directory.");
        }
        this.mBaseDir = baseDir;
    }

    public int save(int key, LinecountCollator collator) throws DbException {
        Logs.APP_LOG.debug((Object)("DAO.save(): " + key));
        return this.write(key, collator);
    }

    private int write(int key, LinecountCollator collator) throws DbException {
        int n;
        DataOutputStream out = null;
        try {
            File file = this.createFile(key);
            BufferedOutputStream fout = new BufferedOutputStream(new FileOutputStream(file, false));
            out = new DataOutputStream(fout);
            collator.toStream(out);
            n = key;
        }
        catch (IOException e2) {
            try {
                throw new DbException(e2.getMessage(), e2);
            }
            catch (Throwable throwable) {
                IOHelper.close(out);
                throw throwable;
            }
        }
        IOHelper.close(out);
        return n;
    }

    private File createFile(int key) {
        return new File(this.mBaseDir, key + SUFFIX);
    }

    public LinecountCollator read(int key) throws DbException {
        LinecountCollator linecountCollator;
        Logs.APP_LOG.debug((Object)("read(): key = " + key));
        DataInputStream dis = null;
        try {
            File file = this.createFile(key);
            BufferedInputStream fis = new BufferedInputStream(new FileInputStream(file));
            dis = new DataInputStream(fis);
            linecountCollator = LinecountCollator.fromStream(dis);
        }
        catch (IOException e2) {
            try {
                throw new DbException(e2.getMessage(), e2);
            }
            catch (Throwable throwable) {
                IOHelper.close(dis);
                throw throwable;
            }
        }
        IOHelper.close(dis);
        return linecountCollator;
    }

    public boolean delete(int key) {
        Logs.APP_LOG.debug((Object)("DAO.delete(): key = " + key));
        File file = this.createFile(key);
        return file.exists() && file.delete();
    }

    public void deleteAll() {
        Logs.APP_LOG.debug((Object)"DAO.deleteAll()");
        IOHelper.recursiveDelete(this.mBaseDir, 1, false);
    }
}

