/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.search;

import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.cvsrep.search.query.AbstractTermClause;
import com.cenqua.fisheye.cvsrep.search.query.AuthorsClause;
import com.cenqua.fisheye.cvsrep.search.query.BoolClause;
import com.cenqua.fisheye.cvsrep.search.query.Clause;
import com.cenqua.fisheye.cvsrep.search.query.CommentClause;
import com.cenqua.fisheye.cvsrep.search.query.CommentExactMatchClause;
import com.cenqua.fisheye.cvsrep.search.query.CommentRegexClause;
import com.cenqua.fisheye.cvsrep.search.query.ContentClause;
import com.cenqua.fisheye.cvsrep.search.query.CsidExactMatchClause;
import com.cenqua.fisheye.cvsrep.search.query.DateRangeClause;
import com.cenqua.fisheye.cvsrep.search.query.HeadClause;
import com.cenqua.fisheye.cvsrep.search.query.NotClause;
import com.cenqua.fisheye.cvsrep.search.query.OnBranchClause;
import com.cenqua.fisheye.cvsrep.search.query.P4FixesClause;
import com.cenqua.fisheye.cvsrep.search.query.P4FixesRegexClause;
import com.cenqua.fisheye.cvsrep.search.query.PathClause;
import com.cenqua.fisheye.cvsrep.search.query.Query3Clause;
import com.cenqua.fisheye.cvsrep.search.query.ReviewClause;
import com.cenqua.fisheye.cvsrep.search.query.TaggedExactClause;
import com.cenqua.fisheye.cvsrep.search.query.TaggedRangeClause;
import com.cenqua.fisheye.infinitydb.query3.AndQuery3;
import com.cenqua.fisheye.infinitydb.query3.AntGlobQuery3;
import com.cenqua.fisheye.infinitydb.query3.AnyLongRangeQuery3;
import com.cenqua.fisheye.infinitydb.query3.BooleanQuery3;
import com.cenqua.fisheye.infinitydb.query3.LuceneJoinQuery3;
import com.cenqua.fisheye.infinitydb.query3.NotQuery3;
import com.cenqua.fisheye.infinitydb.query3.OrQuery3;
import com.cenqua.fisheye.infinitydb.query3.Query3;
import com.cenqua.fisheye.infinitydb.query3.RegexQuery3;
import com.cenqua.fisheye.infinitydb.query3.TermLookupQuery3;
import com.cenqua.fisheye.infinitydb.query3.TermQuery3;
import com.cenqua.fisheye.lucene.SmartPhraseQuery;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.impl.CommonSchema;
import com.cenqua.fisheye.search.ClauseVisitor;
import com.cenqua.fisheye.search.EmptyQuery3;
import com.cenqua.fisheye.search.OpenTagRangeQuery3;
import com.cenqua.fisheye.search.ReviewQuery3;
import com.cenqua.fisheye.util.AntGlob;
import com.cenqua.obfuscate.idbk4uide._Cu;
import java.io.IOException;
import java.util.Iterator;
import java.util.Locale;
import java.util.regex.Pattern;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.Query;

public abstract class QueryBuilder
implements ClauseVisitor {
    private Query3 query;
    private Analyzer analyzer;
    private boolean caseSensitive;

    protected QueryBuilder(Analyzer analyzer, boolean caseSensitive) {
        this.analyzer = analyzer;
        this.caseSensitive = caseSensitive;
    }

    public Query3 getQuery() {
        return this.query;
    }

    protected Analyzer getAnalyzer() {
        return this.analyzer;
    }

    protected void setQuery(Query3 query) {
        this.query = query;
    }

    public void visitTermClause(AbstractTermClause termClause) {
        this.setQuery(termClause.asQuery3());
    }

    public void visitBoolClause(BoolClause boolClause) throws DbException, IOException {
        int numClauses = boolClause.getNumSubClases();
        if (numClauses == 0) {
            this.query = new OrQuery3();
        } else if (numClauses == 1) {
            Clause c2 = (Clause)boolClause.getSubClauses().next();
            c2.accept(this);
        } else {
            BooleanQuery3 bq = boolClause.isRequired() ? new AndQuery3() : new OrQuery3();
            Iterator i2 = boolClause.getSubClauses();
            while (i2.hasNext()) {
                Clause c3 = (Clause)i2.next();
                this.query = null;
                c3.accept(this);
                bq.addClause(this.query);
            }
            this.query = bq;
        }
    }

    public void visitAuthorsClause(AuthorsClause authorsClause) {
        OrQuery3 aq = new OrQuery3();
        Iterator i2 = authorsClause.getAuthors();
        while (i2.hasNext()) {
            String author = (String)i2.next();
            String au = author.toLowerCase(Locale.US);
            TermQuery3 t = new TermQuery3(CommonSchema.E_AUTHOR_TO_REVID, au, null);
            aq.addClause(t);
        }
        this.setQuery(aq);
    }

    public void visitCommentClause(CommentClause commentClause) throws IOException {
        PhraseQuery pq = SmartPhraseQuery.parsePhrase(this.analyzer, "comment", commentClause.getMatch());
        this.setQuery(new LuceneJoinQuery3((Query)pq, 0));
    }

    public void visitDateClause(DateRangeClause dateClause) {
        Long minDate = dateClause.getMinDate();
        Long maxDate = dateClause.getMaxDate();
        long from = minDate == null ? Long.MIN_VALUE : minDate;
        long to = maxDate == null ? Long.MAX_VALUE : maxDate;
        this.setQuery(new AnyLongRangeQuery3(CommonSchema.E_DATE_TO_REVID, from, dateClause.isMinInclusive(), to, dateClause.isMaxInclusive()));
    }

    public void visitQuery3Clause(Query3Clause clause) {
        this.setQuery(clause.getQuery());
    }

    public void visitHeadClause(HeadClause headClause) throws IOException {
        String branch = headClause.getBranch();
        if (branch != null) {
            this.setQuery(new TermQuery3(CommonSchema.E_HEAD_IN_BRANCH_TO_REVID, branch, null));
        } else {
            this.setQuery(new TermQuery3(CommonSchema.E_HEAD_IN_ANY_BRANCH_REVIDS, _Cu.alloc(), null));
        }
    }

    public void visitNotClause(NotClause notClause) throws IOException, DbException {
        notClause.getDelegate().accept(this);
        this.setQuery(new NotQuery3(this.getQuery()));
    }

    public void visitCommentExactMatchClause(CommentExactMatchClause commentExactMatchClause) throws DbException {
        String match = commentExactMatchClause.getMatch();
        this.setQuery(new TermLookupQuery3(CommonSchema.E_COMMENTS, CommonSchema.E_COMMENT_ID_TO_REVID, match, null));
    }

    public void visitCommentRegexClause(CommentRegexClause commentRegexClause) throws DbException {
        Pattern match = commentRegexClause.getMatch();
        this.setQuery(new RegexQuery3(CommonSchema.E_COMMENTS, CommonSchema.E_COMMENT_ID_TO_REVID, match));
    }

    public void visitPathClause(PathClause pathClause) {
        AntGlobQuery3 q = new AntGlobQuery3(CommonSchema.E_PATHS, CommonSchema.E_PATH_ID_TO_REVID, new AntGlob(pathClause.getPattern()));
        if (pathClause.isInvert()) {
            this.setQuery(new NotQuery3(q));
        } else {
            this.setQuery(q);
        }
    }

    public void visitOnBranchClause(OnBranchClause onBranchClause) {
        AndQuery3 q = new AndQuery3();
        String branch = onBranchClause.getBranch();
        if (onBranchClause.isModified()) {
            q.addClause(new TermQuery3(CommonSchema.E_MOD_ON_BRANCH_TO_REVID, branch, null));
        } else {
            OrQuery3 bq = new OrQuery3();
            bq.addClause(new TermQuery3(CommonSchema.E_MOD_ON_BRANCH_TO_REVID, branch, null));
            bq.addClause(new TermQuery3(CommonSchema.E_UNMOD_ON_BRANCH_TO_REVID, branch, null));
            bq.addClause(new TermQuery3(CommonSchema.E_BP_ON_BRANCH_TO_REVID, branch, null));
            q.addClause(bq);
        }
        if (onBranchClause.isAdded()) {
            q.addClause(new TermQuery3(CommonSchema.E_BRANCH_WITH_ADDS_TO_REVID, branch, null));
        }
        if (onBranchClause.isDeleted()) {
            q.addClause(new TermQuery3(CommonSchema.E_BRANCH_WITH_DELETES_TO_REVID, branch, null));
        }
        this.setQuery(q);
    }

    public void visitTaggedClause(TaggedExactClause taggedExactClause) throws IOException {
        TermLookupQuery3 q = new TermLookupQuery3(CommonSchema.E_TAGS, CommonSchema.E_TAG_TO_REVID, taggedExactClause.getTag(), null);
        this.setQuery(q);
    }

    public void visitTaggedRangeClause(TaggedRangeClause trc) throws IOException {
        AndQuery3 q = new AndQuery3();
        if (trc.getStartTag() != null) {
            q.addClause(new OpenTagRangeQuery3(trc.getStartTag(), trc.isStartInclusive(), true, false));
        }
        if (trc.getEndTag() != null) {
            q.addClause(new OpenTagRangeQuery3(trc.getEndTag(), trc.isEndInclusive(), false, true));
        }
        this.setQuery(q);
    }

    public void visitContentClause(ContentClause contentClause) throws IOException {
        PhraseQuery pq = SmartPhraseQuery.parsePhrase(this.getAnalyzer(), "contents", contentClause.getMatch());
        this.setQuery(new LuceneJoinQuery3((Query)pq, 1));
    }

    public void visitCsidExactMatchClause(CsidExactMatchClause csidExactMatchClause) throws IOException {
        TermQuery3 q = new TermQuery3(CommonSchema.E_CSID_TO_REVID, csidExactMatchClause.getMatch(), null);
        this.setQuery(q);
    }

    public void visitReviewClause(ReviewClause reviewClause) {
        if (AppConfig.isCrucible()) {
            this.setQuery(new ReviewQuery3(reviewClause.getPermaid(), reviewClause.getMetaStates(), reviewClause.isIn(), false, reviewClause.isBefore()));
        } else {
            this.setQuery(new EmptyQuery3());
        }
    }

    public void visitP4FixesClause(P4FixesClause p4FixesClause) throws IOException {
        this.setQuery(new EmptyQuery3());
    }

    public void visitP4FixesRegexClause(P4FixesRegexClause p4FixesRegexClause) {
        this.setQuery(new EmptyQuery3());
    }
}

