/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.svn;

import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.RepositoryClientException;
import com.cenqua.fisheye.util.Throttle;
import java.io.File;
import java.io.OutputStream;
import java.util.Timer;
import java.util.TimerTask;
import org.tigris.subversion.javahl.BlameCallback;
import org.tigris.subversion.javahl.ClientException;
import org.tigris.subversion.javahl.DirEntry;
import org.tigris.subversion.javahl.Info;
import org.tigris.subversion.javahl.Info2;
import org.tigris.subversion.javahl.LogMessage;
import org.tigris.subversion.javahl.PropertyData;
import org.tigris.subversion.javahl.Revision;
import org.tigris.subversion.javahl.SVNClientInterface;

public class SvnThrottledClient {
    private Throttle throttle;
    private SVNClientInterface client;
    private static final Timer timeoutTimer = new Timer("SvnTimeout");
    private TimerTask timeoutTask;
    private static final int RETRY_LIMIT = 2;
    private long timeout;
    private String repoDescriptor;
    private volatile Thread executingThread;
    private String operation;

    public SvnThrottledClient(String repoDescriptor, Throttle throttle, SVNClientInterface rawClient, long timeout) {
        this.throttle = throttle;
        this.client = rawClient;
        this.repoDescriptor = repoDescriptor;
        this.timeout = timeout == 0L ? 3600000L : timeout;
    }

    private void start(final String operationDescription) {
        this.throttle.apply();
        this.executingThread = Thread.currentThread();
        this.operation = operationDescription;
        Logs.APP_LOG.debug((Object)("Executing " + operationDescription));
        this.timeoutTask = new TimerTask(){

            public void run() {
                try {
                    Logs.APP_LOG.warn((Object)("Cancelling SVN Operation (" + operationDescription + ") on repository " + SvnThrottledClient.this.repoDescriptor + " due to timeout"));
                    SvnThrottledClient.this.doCancel();
                }
                catch (ClientException clientException) {
                    // empty catch block
                }
            }
        };
        timeoutTimer.schedule(this.timeoutTask, this.timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doCancel() throws ClientException {
        SvnThrottledClient svnThrottledClient = this;
        synchronized (svnThrottledClient) {
            this.client.cancelOperation();
            this.scheduleInterrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleInterrupt() {
        SvnThrottledClient svnThrottledClient = this;
        synchronized (svnThrottledClient) {
            this.timeoutTask = new TimerTask(){

                public void run() {
                    SvnThrottledClient.this.doInterrupt();
                }
            };
            timeoutTimer.schedule(this.timeoutTask, 60000L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doInterrupt() {
        SvnThrottledClient svnThrottledClient = this;
        synchronized (svnThrottledClient) {
            if (this.executingThread != null) {
                Logs.APP_LOG.warn((Object)("Interrupting SVN operation thread due to non-response: " + this.executingThread.getName() + ":" + this.executingThread.getId()));
                this.executingThread.interrupt();
                this.scheduleInterrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finish() {
        SvnThrottledClient svnThrottledClient = this;
        synchronized (svnThrottledClient) {
            this.timeoutTask.cancel();
            timeoutTimer.purge();
            this.executingThread = null;
            this.operation = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Info2[] info2(String repoPath, Revision revision, Revision pegRevision, boolean recurse) throws RepositoryClientException {
        ClientException ex = null;
        for (int i2 = 0; i2 < 2; ++i2) {
            try {
                this.start("info -r " + revision + " " + repoPath + "@" + pegRevision);
                Info2[] info2Array = this.client.info2(repoPath, revision, pegRevision, recurse);
                return info2Array;
            }
            catch (ClientException e2) {
                ex = e2;
                continue;
            }
            finally {
                this.finish();
            }
        }
        throw new RepositoryClientException(ex);
    }

    public LogMessage[] logMessages(String path, Revision start, Revision end) throws RepositoryClientException {
        this.start("log -v -r " + start + ":" + end + " " + path);
        try {
            LogMessage[] logMessageArray = this.client.logMessages(path, start, end);
            return logMessageArray;
        }
        catch (ClientException e2) {
            throw new RepositoryClientException(e2);
        }
        finally {
            this.finish();
        }
    }

    public LogMessage[] logMessages(String path, Revision startRevision, Revision endRevision, boolean stopOnCopy, boolean discoverPaths) throws RepositoryClientException {
        this.start("log -v -r " + startRevision + ":" + endRevision + " " + path);
        try {
            LogMessage[] logMessageArray = this.client.logMessages(path, startRevision, endRevision, stopOnCopy, discoverPaths);
            return logMessageArray;
        }
        catch (ClientException e2) {
            throw new RepositoryClientException(e2);
        }
        finally {
            this.finish();
        }
    }

    public LogMessage[] logMessages(String path, Revision startRevision, Revision endRevision, boolean stopOnCopy, boolean discoverPath, long limit) throws RepositoryClientException {
        this.start("log -v -r " + startRevision + ":" + endRevision + " " + path);
        try {
            LogMessage[] logMessageArray = this.client.logMessages(path, startRevision, endRevision, stopOnCopy, discoverPath, limit);
            return logMessageArray;
        }
        catch (ClientException e2) {
            throw new RepositoryClientException(e2);
        }
        finally {
            this.finish();
        }
    }

    public void diff(String target, Revision pegRevision, Revision startRevision, Revision endRevision, String outFileName, boolean recurse, boolean ignoreAncestry, boolean noDiffDeleted, boolean force) throws RepositoryClientException {
        this.start("diff -r " + startRevision + ":" + endRevision + " " + target + "@" + pegRevision);
        try {
            this.client.diff(target, pegRevision, startRevision, endRevision, outFileName, recurse, ignoreAncestry, noDiffDeleted, force);
        }
        catch (ClientException e2) {
            throw new RepositoryClientException(e2);
        }
        finally {
            this.finish();
        }
    }

    public DirEntry[] list(String url, Revision revision, Revision pegRevision, boolean recurse) throws RepositoryClientException {
        this.start("ls -r " + revision + " " + url + "@" + pegRevision);
        try {
            DirEntry[] dirEntryArray = this.client.list(url, revision, pegRevision, recurse);
            return dirEntryArray;
        }
        catch (ClientException e2) {
            throw new RepositoryClientException(e2);
        }
        finally {
            this.finish();
        }
    }

    public PropertyData propertyGet(String pathURL, String propertyName, Revision rev, Revision pegRevision) throws RepositoryClientException {
        this.start("propget " + propertyName + " -r " + rev + " " + pathURL + "@" + pegRevision);
        try {
            PropertyData propertyData = this.client.propertyGet(pathURL, propertyName, rev, pegRevision);
            return propertyData;
        }
        catch (ClientException e2) {
            throw new RepositoryClientException(e2);
        }
        finally {
            this.finish();
        }
    }

    public byte[] fileContent(String pathURL, Revision rev, Revision pegRevision) throws RepositoryClientException {
        this.start("cat -r " + rev + " " + pathURL + "@" + pegRevision);
        try {
            byte[] byArray = this.client.fileContent(pathURL, rev, pegRevision);
            return byArray;
        }
        catch (ClientException e2) {
            throw new RepositoryClientException(e2);
        }
        finally {
            this.finish();
        }
    }

    public void blame(String pathURL, Revision pegRevision, Revision start, Revision end, BlameCallback callback) throws RepositoryClientException {
        this.start("blame -r " + start + ":" + end + " " + pathURL + "@" + pegRevision);
        try {
            this.client.blame(pathURL, pegRevision, start, end, callback);
        }
        catch (ClientException e2) {
            throw new RepositoryClientException(e2);
        }
        finally {
            this.finish();
        }
    }

    public void doExport(String pathURL, String destPath, Revision rev, Revision pegRevision, boolean force, boolean ignoreExternals, boolean recurse, String nativeEOL) throws RepositoryClientException {
        this.start("cat -r " + rev + " " + pathURL + "@" + pegRevision);
        try {
            this.client.doExport(pathURL, destPath, rev, pegRevision, force, ignoreExternals, recurse, nativeEOL);
        }
        catch (ClientException e2) {
            throw new RepositoryClientException(e2);
        }
        finally {
            this.finish();
        }
    }

    public PropertyData[] properties(String path, Revision revision, Revision pegRevision) throws RepositoryClientException {
        File file = new File(path);
        if (!file.exists()) {
            this.start("proplist -r " + revision + " " + path);
        }
        try {
            PropertyData[] propertyDataArray = this.client.properties(path, revision, pegRevision);
            return propertyDataArray;
        }
        catch (ClientException e2) {
            throw new RepositoryClientException("Failed to get properties for " + path + ":" + revision, e2);
        }
        finally {
            this.finish();
        }
    }

    public void streamFileContent(String pathURL, Revision rev, OutputStream stream) throws RepositoryClientException {
        this.start("cat -r " + rev + " " + pathURL + "@" + rev);
        try {
            this.client.streamFileContent(pathURL, rev, rev, 1024, stream);
        }
        catch (ClientException e2) {
            throw new RepositoryClientException(e2);
        }
        finally {
            this.finish();
        }
    }

    public PropertyData[] revProperties(String url, Revision rev) throws RepositoryClientException {
        this.start("proplist --revprop -r " + rev + " " + url);
        try {
            PropertyData[] propertyDataArray = this.client.revProperties(url, rev);
            return propertyDataArray;
        }
        catch (ClientException e2) {
            throw new RepositoryClientException(e2);
        }
        finally {
            this.finish();
        }
    }

    public long checkout(String moduleName, String destPath, Revision rev, Revision pegRev, boolean recurse, boolean ignoreExternals) throws RepositoryClientException {
        this.start("co -r " + rev + " " + moduleName + "@" + pegRev);
        try {
            long l = this.client.checkout(moduleName, destPath, rev, pegRev, recurse, ignoreExternals);
            return l;
        }
        catch (ClientException e2) {
            throw new RepositoryClientException(e2);
        }
        finally {
            this.finish();
        }
    }

    public Info info(String localWorkingPath) throws RepositoryClientException {
        try {
            return this.client.info(localWorkingPath);
        }
        catch (ClientException e2) {
            throw new RepositoryClientException(e2);
        }
    }

    public PropertyData[] properties(String path) throws RepositoryClientException {
        try {
            return this.client.properties(path);
        }
        catch (ClientException e2) {
            throw new RepositoryClientException(e2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        try {
            SvnThrottledClient svnThrottledClient = this;
            synchronized (svnThrottledClient) {
                if (this.timeoutTask != null) {
                    Logs.APP_LOG.warn((Object)("Cancelling SVN Operation (" + this.operation + ") on repository " + this.repoDescriptor + " due to stop"));
                    this.doCancel();
                }
            }
        }
        catch (ClientException e2) {
            Logs.APP_LOG.warn((Object)"Error cancelling svn operation");
        }
    }
}

