/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.svn.diff;

import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.RepositoryClientException;
import com.cenqua.fisheye.svn.SvnRepositoryInfo;
import com.cenqua.fisheye.svn.SvnThrottledClient;
import com.cenqua.fisheye.svn.diff.ChangeInfo;
import com.cenqua.fisheye.util.Pair;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;
import org.tigris.subversion.javahl.ChangePath;
import org.tigris.subversion.javahl.Info2;
import org.tigris.subversion.javahl.LogMessage;
import org.tigris.subversion.javahl.PropertyData;
import org.tigris.subversion.javahl.Revision;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageInfo {
    private final Map<Path, ChangeInfo> changeInfos = new HashMap<Path, ChangeInfo>();
    private final Map<ChangePath, Path> localPathMap;
    private final Map<Path, ChangePath> inversePathMap;
    private final Map<Pair<Path, Long>, Info2> svnInfoCache = new HashMap<Pair<Path, Long>, Info2>();
    private PropertyData[] revProps;
    private long revisionNumber;
    private SvnRepositoryInfo repoInfo;

    public MessageInfo(SvnRepositoryInfo repInfo, LogMessage message) {
        this.repoInfo = repInfo;
        this.revisionNumber = message.getRevisionNumber();
        int length = message.getChangedPaths() != null ? message.getChangedPaths().length : 0;
        this.localPathMap = new HashMap<ChangePath, Path>(length);
        this.inversePathMap = new HashMap<Path, ChangePath>(length);
        if (length != 0) {
            for (ChangePath changePath : message.getChangedPaths()) {
                Path localPath = repInfo.getLocalPath(changePath.getPath(), message.getRevisionNumber());
                this.localPathMap.put(changePath, localPath);
                this.inversePathMap.put(localPath, changePath);
            }
        }
    }

    public Path getLocalPath(ChangePath path) {
        return this.localPathMap.get(path);
    }

    public ChangePath getChangePath(Path path) {
        return this.inversePathMap.get(path);
    }

    public void addChangeInfoMap(Map<Path, ChangeInfo> changeInfos) {
        this.changeInfos.putAll(changeInfos);
    }

    public void setChangeInfo(Path physicalPath, ChangeInfo changeInfo) {
        this.changeInfos.put(physicalPath, changeInfo);
    }

    public ChangeInfo getChangeInfo(Path physicalPath) {
        ChangeInfo info = null;
        if (this.changeInfos != null) {
            info = this.changeInfos.get(physicalPath);
        }
        return info;
    }

    public void setRevProps(PropertyData[] revProps) {
        this.revProps = revProps;
    }

    public PropertyData[] getRevProps() {
        return this.revProps;
    }

    public Map<Path, ChangeInfo> getChangeInfos() {
        return this.changeInfos;
    }

    public long getRevisionNumber() {
        return this.revisionNumber;
    }

    public Info2 getInfo(SvnThrottledClient client, Path path) throws RepositoryClientException {
        return this.getInfo(client, path, this.revisionNumber);
    }

    public Info2 getInfo(SvnThrottledClient client, Path path, long rev) throws RepositoryClientException {
        Pair<Path, Long> key;
        block12: {
            key = new Pair<Path, Long>(path, rev);
            if (!this.svnInfoCache.containsKey(key)) {
                Revision.Number revision = new Revision.Number(rev);
                try {
                    String url = this.repoInfo.getPathURL(path, rev);
                    Info2[] info = client.info2(url, (Revision)revision, (Revision)revision, false);
                    if (info.length == 1) {
                        this.svnInfoCache.put(key, info[0]);
                    }
                }
                catch (RepositoryClientException e2) {
                    Path parent = path.getParent();
                    if (path.equals(parent)) break block12;
                    String parentURL = this.repoInfo.getPathURL(parent, rev);
                    Info2[] upperInfos = client.info2(parentURL, (Revision)revision, (Revision)revision, true);
                    if (upperInfos.length < 100) {
                        for (Info2 upperInfo : upperInfos) {
                            try {
                                String url = upperInfo.getUrl();
                                url = URLDecoder.decode(url, "UTF-8");
                                String upperServerPath = url.substring(upperInfo.getReposRootUrl().length());
                                Path upperPath = this.repoInfo.getLocalPath(upperServerPath, rev);
                                Pair<Path, Long> upperKey = new Pair<Path, Long>(upperPath, rev);
                                this.svnInfoCache.put(upperKey, upperInfo);
                            }
                            catch (UnsupportedEncodingException e1) {
                                Logs.APP_LOG.error((Object)e1);
                            }
                        }
                    } else {
                        for (Info2 upperInfo : upperInfos) {
                            try {
                                String url = upperInfo.getUrl();
                                url = URLDecoder.decode(url, "UTF-8");
                                String upperServerPath = url.substring(upperInfo.getReposRootUrl().length());
                                Path upperPath = this.repoInfo.getLocalPath(upperServerPath, rev);
                                if (!path.equals(upperPath)) continue;
                                Pair<Path, Long> upperKey = new Pair<Path, Long>(upperPath, rev);
                                this.svnInfoCache.put(upperKey, upperInfo);
                                break;
                            }
                            catch (UnsupportedEncodingException e1) {
                                Logs.APP_LOG.error((Object)e1);
                            }
                        }
                    }
                    if (this.svnInfoCache.containsKey(key)) break block12;
                    throw e2;
                }
            }
        }
        return this.svnInfoCache.get(key);
    }
}

