/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.svn.dump;

import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.diff.Diff;
import com.cenqua.fisheye.diff.Hunk;
import com.cenqua.fisheye.diff.HunkList;
import com.cenqua.fisheye.diff.LineComparator;
import com.cenqua.fisheye.diff.TextFileDiffSequences;
import com.cenqua.fisheye.io.BufferedRandomAccessInputStream;
import com.cenqua.fisheye.io.IndexedLineReader;
import com.cenqua.fisheye.io.RandomAccessView;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.RepositoryClientException;
import com.cenqua.fisheye.rep.RevInfoKey;
import com.cenqua.fisheye.svn.SvnCache;
import com.cenqua.fisheye.svn.SvnContentProvider;
import com.cenqua.fisheye.svn.SvnRepositoryScanner;
import com.cenqua.fisheye.svn.db.SvnRevInfo;
import com.cenqua.fisheye.svn.diff.ChangeInfo;
import com.cenqua.fisheye.svn.diff.MessageInfo;
import com.cenqua.fisheye.svn.dump.DumpInputStream;
import com.cenqua.fisheye.svn.dump.PathInfo;
import com.cenqua.fisheye.svn.dump.RevisionInfo;
import com.cenqua.fisheye.svn.util.ChangePathUtil;
import com.cenqua.fisheye.util.ISO8601DateHelper;
import com.cenqua.fisheye.util.LineCountingOutputStream;
import com.cenqua.fisheye.util.Timer;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.charset.Charset;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.tigris.subversion.javahl.ChangePath;
import org.tigris.subversion.javahl.JavaHLFactory;
import org.tigris.subversion.javahl.LogMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DumpReader
implements SvnContentProvider {
    private static final String SVN_VERSION_HEADER = "SVN-fs-dump-format-version";
    private static final String UUID_HEADER = "UUID";
    private static final String REVISION_HEADER = "Revision-number";
    private static final String PROP_CONTENT_LEN_HEADER = "Prop-content-length";
    private static final String CONTENT_LEN_HEADER = "Content-length";
    public static final String PROPS_END_MARKER = "PROPS-END";
    public static final String NODE_PATH_HEADER = "Node-path";
    private String dumpLocation;
    private BufferedRandomAccessInputStream dumpFile;
    private BufferedRandomAccessInputStream dumpFileView;
    private SortedMap<Long, RevisionInfo> revisions = new TreeMap<Long, RevisionInfo>();
    private long lastLinePos = 0L;
    private SvnCache cache;
    private SvnRepositoryScanner scanner;

    public DumpReader(SvnRepositoryScanner svnRepositoryScanner) {
        this.scanner = svnRepositoryScanner;
        this.cache = (SvnCache)svnRepositoryScanner.getCache();
    }

    public void readDump(File inputFile) throws IOException, DbException, RepositoryClientException {
        String line;
        this.dumpLocation = inputFile.getAbsolutePath();
        RandomAccessFile raFile = new RandomAccessFile(inputFile, "r");
        this.dumpFile = new BufferedRandomAccessInputStream(inputFile, raFile, 512);
        RandomAccessFile raViewFile = new RandomAccessFile(inputFile, "r");
        this.dumpFileView = new BufferedRandomAccessInputStream(inputFile, raViewFile, 512);
        long version = this.readVersion();
        if (version > 1L) {
            String uuid = this.readUUID();
        }
        long firstRev = -1L;
        long lastRev = -1L;
        boolean createRoot = true;
        while ((line = this.readNonBlankLine()) != null) {
            lastRev = this.readLongHeader(REVISION_HEADER, line);
            if (firstRev == -1L) {
                firstRev = lastRev;
            }
            Logs.APP_LOG.info((Object)("Reading revision " + lastRev));
            Map<String, PathInfo> revPaths = this.readRevision(lastRev);
            long fp = this.dumpFile.getFilePointer();
            Timer timer = new Timer("Processing revision " + lastRev);
            this.processRevision(lastRev, revPaths, createRoot);
            createRoot = false;
            timer.end();
            this.dumpFile.seek(fp);
        }
        Logs.APP_LOG.info((Object)"Updating indexes");
        this.runUpdatePhase(firstRev, lastRev);
        this.revisions.clear();
        this.dumpFile.close();
        this.dumpFileView.close();
        this.lastLinePos = 0L;
        this.scanner.getStatus().reset();
    }

    private String readNonBlankLine() throws IOException {
        String line;
        this.lastLinePos = this.dumpFile.getFilePointer();
        while ((line = this.dumpFile.readLine()) != null && line.trim().length() == 0) {
        }
        return line;
    }

    private String peekNonBlankLine() throws IOException {
        long current = this.dumpFile.getFilePointer();
        String result = this.readNonBlankLine();
        this.dumpFile.seek(current);
        return result;
    }

    private void processRevision(long revNumber, Map<String, PathInfo> paths, boolean createRoot) throws DbException, IOException, RepositoryClientException {
        boolean hasPath = false;
        for (String path : paths.keySet()) {
            Path localPath = this.getLocalPath(path, revNumber);
            if (!this.cache.getRepositoryInfo().isPathInRepo(localPath)) continue;
            hasPath = true;
            break;
        }
        if (!hasPath) {
            return;
        }
        ChangePath[] changePaths = new ChangePath[paths.size()];
        int index = 0;
        HashMap<Path, ChangeInfo> changeInfos = new HashMap<Path, ChangeInfo>();
        for (String path : paths.keySet()) {
            int action;
            PathInfo pathInfo = paths.get(path);
            if (pathInfo.getAction().equals("add")) {
                action = 65;
            } else if (pathInfo.getAction().equals("change")) {
                action = 77;
            } else if (pathInfo.getAction().equals("delete")) {
                action = 68;
            } else if (pathInfo.getAction().equals("replace")) {
                action = 82;
            } else {
                throw new IOException(this.formatExceptionMessage("Unknown action: " + pathInfo.getAction()));
            }
            changePaths[index++] = JavaHLFactory.createChangePath(path, pathInfo.getCopyFromRev(), pathInfo.getCopyFromPath(), (char)action);
        }
        List<ChangePath> requiredDiffs = ChangePathUtil.getRequiredDiffs(this.cache.getRepositoryInfo(), changePaths, revNumber);
        for (ChangePath changePath : requiredDiffs) {
            PathInfo pathInfo = paths.get(changePath.getPath());
            ChangeInfo changeInfo = this.getDiffInfo(pathInfo, revNumber);
            if (changeInfo == null) continue;
            Path relativePath = this.getLocalPath(changePath.getPath(), revNumber);
            changeInfo.setFileDiff(true);
            changeInfos.put(relativePath, changeInfo);
        }
        RevisionInfo revInfo = (RevisionInfo)this.revisions.get(revNumber);
        Map<String, byte[]> properties = this.readProps(revInfo.getPropContentOffset(), revInfo.getPropContentLength());
        String message = null;
        if (properties.containsKey("svn:log")) {
            message = new String(properties.get("svn:log"));
        }
        Date revDate = new Date();
        if (properties.containsKey("svn:date")) {
            String dateString = new String(properties.get("svn:date"));
            try {
                revDate = ISO8601DateHelper.parse(dateString);
            }
            catch (ISO8601DateHelper.InvalidDateException e2) {
                Logs.APP_LOG.error((Object)"Error parsing revision date", (Throwable)e2);
            }
        }
        String author = null;
        if (properties.containsKey("svn:author")) {
            author = new String(properties.get("svn:author"));
        }
        LogMessage logMessage = JavaHLFactory.createLogMessage(message, revDate, revInfo.getRevNumber(), author, changePaths);
        MessageInfo messageInfo = new MessageInfo(this.cache.getRepositoryInfo(), logMessage);
        messageInfo.addChangeInfoMap(changeInfos);
        this.scanner.createChangeSet(logMessage, messageInfo);
    }

    private void runUpdatePhase(long firstRev, long lastRev) throws IOException, RepositoryClientException, DbException {
        this.scanner.indexMetadata(firstRev, lastRev);
        this.scanner.setContentProvider(this);
        this.scanner.indexContent(firstRev, lastRev);
        this.scanner.setContentProvider(null);
    }

    private ChangeInfo getDiffInfo(PathInfo pathInfo, long rev) throws IOException, DbException {
        if (!pathInfo.getType().equals("file")) {
            return null;
        }
        Timer timer = new Timer("Getting Diff Info for " + pathInfo);
        String path = pathInfo.getPath();
        Path localPath = this.getLocalPath(path, rev);
        SvnRevInfo latestRevision = this.cache.getLatestRevisionUpto(localPath, pathInfo.getRevisionNumber() - 1L);
        final ChangeInfo changeInfo = new ChangeInfo();
        long currentOffset = pathInfo.getTextContentOffset();
        long currentLength = pathInfo.getTextContentLength();
        if (latestRevision == null || latestRevision.isDead()) {
            String mimeType;
            Map<String, byte[]> props = this.readProps(pathInfo.getPropContentOffset(), pathInfo.getPropContentLength());
            for (Map.Entry<String, byte[]> entry : props.entrySet()) {
                String propName = entry.getKey();
                byte[] propValue = entry.getValue();
                changeInfo.updateProperty(propName, new String(propValue));
            }
            if (changeInfo.getUpdatedProperties().containsKey("svn:mime-type") && ChangePathUtil.isBinaryMimeType(mimeType = new String(changeInfo.getUpdatedProperties().get("svn:mime-type")))) {
                LineCountingOutputStream lcos = new LineCountingOutputStream();
                this.dumpFile.streamContent(currentOffset, (int)currentLength, 512, lcos);
                changeInfo.incAdded(lcos.getLineCount());
                changeInfo.addHunk(new Hunk(0, 1, 0, lcos.getLineCount()));
            }
        } else {
            String mimeType;
            long previousRevNumber = latestRevision.getSvnRevision();
            PathInfo previousPathInfo = this.getSourcePathInfo(path, previousRevNumber);
            Map<String, byte[]> currentProps = this.readProps(pathInfo.getPropContentOffset(), pathInfo.getPropContentLength());
            Map<String, byte[]> previousProps = this.readProps(previousPathInfo.getPropContentOffset(), previousPathInfo.getPropContentLength());
            this.addUpdatedProps(changeInfo, previousProps, currentProps);
            long previousOffset = previousPathInfo.getTextContentOffset();
            long previousLength = previousPathInfo.getTextContentLength();
            RandomAccessView currentView = new RandomAccessView(this.dumpFile, currentOffset, currentLength);
            RandomAccessView previousView = new RandomAccessView(this.dumpFileView, previousOffset, previousLength);
            IndexedLineReader currentReader = new IndexedLineReader(currentView);
            IndexedLineReader previousReader = new IndexedLineReader(previousView);
            if (changeInfo.getUpdatedProperties().containsKey("svn:mime-type") && ChangePathUtil.isBinaryMimeType(mimeType = changeInfo.getUpdatedProperties().get("svn:mime-type"))) {
                HunkList hunks = Diff.diff(new TextFileDiffSequences(previousReader, currentReader, LineComparator.IDENTICAL));
                hunks.visit(new HunkList.Visitor(){

                    public void common(int fromStart, int toStart, int lenx, int leny, boolean skipPrevious) {
                    }

                    public void change(Hunk hunk) {
                        changeInfo.incAdded(hunk.getToCount());
                        changeInfo.incRemoved(hunk.getFromCount());
                        changeInfo.addHunk(hunk);
                    }

                    public void add(Hunk hunk) {
                        changeInfo.incAdded(hunk.getToCount());
                        changeInfo.incRemoved(hunk.getFromCount());
                        changeInfo.addHunk(hunk);
                    }

                    public void delete(Hunk hunk) {
                        changeInfo.incAdded(hunk.getToCount());
                        changeInfo.incRemoved(hunk.getFromCount());
                        changeInfo.addHunk(hunk);
                    }
                });
            }
        }
        timer.end();
        return changeInfo;
    }

    private void addUpdatedProps(ChangeInfo changeInfo, Map<String, byte[]> previousProps, Map<String, byte[]> currentProps) {
        for (Map.Entry<String, byte[]> entry : currentProps.entrySet()) {
            String propName = entry.getKey();
            byte[] propValue = entry.getValue();
            String propValueStr = new String(propValue);
            if (!previousProps.containsKey(propName)) {
                changeInfo.updateProperty(propName, propValueStr);
                continue;
            }
            byte[] oldValue = previousProps.get(propName);
            String oldValueStr = new String(oldValue);
            if (oldValueStr.equals(propValueStr)) continue;
            changeInfo.updateProperty(propName, propValueStr);
        }
        for (String propName : previousProps.keySet()) {
            if (currentProps.containsKey(propName)) continue;
            changeInfo.removeProperty(propName);
        }
    }

    private PathInfo getSourcePathInfo(String path, long revNumber) throws IOException, DbException {
        SvnRevInfo revision;
        Path sourcePath = this.getLocalPath(path, revNumber);
        long sourceRev = revNumber;
        do {
            if ((revision = this.cache.getLatestRevisionUpto(sourcePath, sourceRev)) == null) {
                String message = "Unable to locate source revision for " + path + "@" + revNumber;
                throw new IOException(this.formatExceptionMessage(message));
            }
            RevInfoKey sourceKey = revision.getCopySource();
            if (sourceKey == null) {
                sourceRev = -1L;
                continue;
            }
            sourceRev = Long.parseLong(sourceKey.getRev());
            sourcePath = sourceKey.getPath();
        } while (sourceRev != -1L);
        String repoPath = this.getRepositoryPath(revision.getPath(), revNumber);
        Map<String, PathInfo> revPaths = this.getRevisionPaths(revision.getSvnRevision());
        return revPaths.get(repoPath);
    }

    private int readIntHeader(String header) throws IOException {
        return (int)this.readLongHeader(header);
    }

    private int readIntHeader(String header, String line) throws IOException {
        return (int)this.readLongHeader(header, line);
    }

    private long readLongHeader(String header) throws IOException {
        return this.readLongHeader(header, this.readNonBlankLine());
    }

    private long readLongHeader(String header, String line) throws IOException {
        return Long.parseLong(this.readStringHeader(header, line).trim());
    }

    private String readStringHeader(String header) throws IOException {
        return this.readStringHeader(header, this.readNonBlankLine());
    }

    private String readStringHeader(String header, String line) throws IOException {
        if (!line.startsWith(header)) {
            String message = "Expected \"" + header + "\" but got \"" + line + "\"";
            throw new IOException(this.formatExceptionMessage(message));
        }
        int headerLength = header.length();
        if (line.charAt(headerLength) == ':') {
            ++headerLength;
        }
        return line.substring(headerLength).trim();
    }

    private String formatExceptionMessage(String message) {
        return "Dump reading problem in dump " + this.dumpLocation + ": " + message;
    }

    private Map<String, PathInfo> readRevision(long revNumber) throws IOException {
        RevisionInfo revInfo = new RevisionInfo(revNumber);
        int propContentLength = this.readIntHeader(PROP_CONTENT_LEN_HEADER);
        long contentLength = this.readLongHeader(CONTENT_LEN_HEADER);
        this.dumpFile.readLine();
        revInfo.setPropContentOffset(this.dumpFile.getFilePointer());
        revInfo.setPropContentLength(propContentLength);
        if (propContentLength != 0) {
            this.dumpFile.skip(propContentLength);
        }
        revInfo.setPathDataOffset(this.dumpFile.getFilePointer());
        this.revisions.put(revNumber, revInfo);
        return this.getRevisionPaths(revNumber);
    }

    private Map<String, PathInfo> getRevisionPaths(long revNumber) throws IOException {
        RevisionInfo revInfo = (RevisionInfo)this.revisions.get(revNumber);
        this.dumpFile.seek(revInfo.getPathDataOffset());
        LinkedHashMap<String, PathInfo> paths = new LinkedHashMap<String, PathInfo>();
        String line = this.peekNonBlankLine();
        while (line != null && line.startsWith("Node-path:")) {
            PathInfo pathInfo = this.readNode(revNumber);
            paths.put(pathInfo.getPath(), pathInfo);
            line = this.peekNonBlankLine();
        }
        return paths;
    }

    private PathInfo readNode(long revision) throws IOException {
        String line;
        PathInfo pathInfo = new PathInfo(revision, this.readStringHeader(NODE_PATH_HEADER));
        while ((line = this.readNonBlankLine()) != null) {
            if (line.startsWith("Node-kind")) {
                pathInfo.setType(this.readStringHeader("Node-kind", line));
            } else if (line.startsWith("Node-action")) {
                pathInfo.setAction(this.readStringHeader("Node-action", line));
            } else if (line.startsWith("Node-copyfrom-rev")) {
                pathInfo.setCopyFromRev(this.readLongHeader("Node-copyfrom-rev", line));
            } else if (line.startsWith("Node-copyfrom-path")) {
                pathInfo.setCopyFromPath(this.readStringHeader("Node-copyfrom-path", line));
            } else if (line.startsWith("Text-copy-source-md5")) {
                pathInfo.setCopySourceMD5(this.readStringHeader("Text-content-md5", line));
            } else if (line.startsWith("Text-content-md5")) {
                pathInfo.setTextContentMD5(this.readStringHeader("Text-content-md5", line));
            } else if (line.startsWith("Text-content-length")) {
                pathInfo.setTextContentLength(this.readIntHeader("Text-content-length", line));
            } else if (line.startsWith(PROP_CONTENT_LEN_HEADER)) {
                pathInfo.setPropContentLength(this.readIntHeader(PROP_CONTENT_LEN_HEADER, line));
            }
            if (!line.startsWith(CONTENT_LEN_HEADER) && !line.startsWith(NODE_PATH_HEADER) && !line.startsWith(REVISION_HEADER)) continue;
        }
        if (line != null) {
            if (line.startsWith(NODE_PATH_HEADER) || line.startsWith(REVISION_HEADER)) {
                this.dumpFile.seek(this.lastLinePos);
            } else {
                long contentLength = this.readLongHeader(CONTENT_LEN_HEADER, line);
                this.dumpFile.readLine();
                pathInfo.setPropContentOffset(this.dumpFile.getFilePointer());
                if (pathInfo.getPropContentLength() != 0L) {
                    this.dumpFile.skip(pathInfo.getPropContentLength());
                }
                if (pathInfo.getTextContentLength() != 0L) {
                    pathInfo.setTextContentOffset(this.dumpFile.getFilePointer());
                    this.dumpFile.skip(pathInfo.getTextContentLength());
                    long newFP = this.dumpFile.getFilePointer();
                    System.out.println("New File Pointer = " + newFP);
                }
            }
        }
        return pathInfo;
    }

    private Map<String, byte[]> readProps(long offset, long length) throws IOException {
        HashMap<String, byte[]> props = new HashMap<String, byte[]>();
        if (length != 0L) {
            this.dumpFile.seek(offset);
            byte[] buffer = new byte[(int)length];
            this.dumpFile.read(buffer);
            DumpInputStream propStream = new DumpInputStream(new ByteArrayInputStream(buffer));
            String keyMarker = propStream.readNonBlankLine();
            while (!keyMarker.equals(PROPS_END_MARKER)) {
                int keySize = propStream.readIntHeader("K", keyMarker);
                byte[] keyBytes = new byte[keySize];
                propStream.read(keyBytes);
                String key = new String(keyBytes);
                int valueSize = propStream.readIntHeader("V");
                byte[] valueBytes = new byte[valueSize];
                propStream.read(valueBytes);
                props.put(key, valueBytes);
                keyMarker = propStream.readNonBlankLine();
            }
        }
        return props;
    }

    private String readUUID() throws IOException {
        return this.readStringHeader(UUID_HEADER).trim();
    }

    private long readVersion() throws IOException {
        return this.readLongHeader(SVN_VERSION_HEADER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean exportContent(Path physicalPath, File contentFile, long revision) throws IOException, DbException {
        String repoPath = this.getRepositoryPath(physicalPath, revision);
        FileOutputStream fos = new FileOutputStream(contentFile);
        PathInfo pathInfo = this.getSourcePathInfo(repoPath, revision);
        try {
            this.dumpFile.streamContent(pathInfo.getTextContentOffset(), (int)pathInfo.getTextContentLength(), 512, fos);
        }
        catch (Throwable e2) {
            this.getSourcePathInfo(repoPath, revision);
            e2.printStackTrace();
        }
        finally {
            fos.close();
        }
        return true;
    }

    private String getRepositoryPath(Path physicalPath, long rev) {
        String serverPath = this.cache.getRepositoryInfo().getServerPath(physicalPath, rev);
        return serverPath.substring(1);
    }

    private Path getLocalPath(String path, long rev) {
        return this.cache.getRepositoryInfo().getLocalPath(path, rev);
    }

    @Override
    public Charset getTextEncoding(RevInfoKey key) throws IOException, DbException {
        long revNumber = Long.parseLong(key.getRev());
        RevisionInfo revInfo = (RevisionInfo)this.revisions.get(revNumber);
        String repoPath = this.getRepositoryPath(key.getPath(), revNumber);
        PathInfo pathInfo = this.getSourcePathInfo(repoPath, revInfo.getRevNumber());
        Map<String, byte[]> pathProps = this.readProps(pathInfo.getPropContentOffset(), pathInfo.getPropContentLength());
        String mimeType = null;
        if (pathProps.containsKey("svn:mime-type")) {
            mimeType = new String(pathProps.get("svn:mime-type"));
        }
        return this.cache.getMimeTypeCharset(mimeType);
    }
}

