/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.syntax;

import com.cenqua.fisheye.syntax.Region;

public class InputState {
    private static final long MAX_TIME = 30000L;
    private final CharSequence sequence;
    private final String fileName;
    private int offset = 0;
    private final Context context;

    public InputState(CharSequence input) {
        this(input, "<stream>");
    }

    public InputState(CharSequence sequence, String fileName) {
        this(sequence, fileName, new Context());
    }

    private InputState(CharSequence sequence, String fileName, Context context) {
        this.sequence = sequence;
        this.fileName = fileName;
        this.context = context;
    }

    public boolean isOverTime() {
        return System.currentTimeMillis() - this.context.startTime > 30000L;
    }

    public CharSequence getRemainingChars() {
        return this.sequence.subSequence(this.offset, this.sequence.length());
    }

    public CharSequence getSubSequence(int start, int end) {
        return this.sequence.subSequence(start, end);
    }

    public int length() {
        return this.sequence.length();
    }

    public CharSequence getSubSequence(Region region) {
        return this.getSubSequence(region.getStart(), region.getEnd());
    }

    public void resetOffset(int off) {
        if (off > this.sequence.length()) {
            throw new IllegalStateException("Don't have " + off + " chars");
        }
        this.offset = off;
    }

    public void consume(int n) {
        if (this.offset + n > this.sequence.length()) {
            throw new IllegalStateException("Don't have " + n + " chars to consume.");
        }
        this.offset += n;
    }

    public void consume() {
        if (!this.hasMoreChars()) {
            throw new IllegalStateException("Nothing left to consume.");
        }
        ++this.offset;
    }

    public int getOffset() {
        return this.offset;
    }

    public boolean hasMoreChars() {
        return this.offset < this.sequence.length();
    }

    public String getFileName() {
        return this.fileName;
    }

    public CharSequence getFullChars() {
        return this.sequence;
    }

    public boolean getParserOverflowOccured() {
        return this.context.parserOverflowOccurred;
    }

    public void setParserOverflowOccured() {
        this.context.parserOverflowOccurred = true;
    }

    public InputState getSubInputState(Region submatchRegion) {
        return new InputState(this.getSubSequence(submatchRegion), this.getFileName(), this.context);
    }

    private static class Context {
        private long startTime = System.currentTimeMillis();
        private boolean parserOverflowOccurred = false;

        private Context() {
        }
    }
}

