/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.user;

import com.cenqua.fisheye.config.DB0EAV;
import com.cenqua.fisheye.infinitydb.EavEntityCu;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.user.FEUserEAV;
import com.cenqua.obfuscate.idbk4uide._Attribute;
import com.cenqua.obfuscate.idbk4uide._Cu;
import com.cenqua.obfuscate.idbk4uide._EntityClass;
import com.cenqua.obfuscate.idbk4uide._ItemSpace;
import com.cenqua.obfuscate.idbk4uide._k4uideIDB;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FEGroupEAV {
    public static final _EntityClass ENTITY = DB0EAV.FEGROUP;
    public static final _Attribute A_USER = new _Attribute(10L);
    private final _k4uideIDB db;

    public FEGroupEAV(_k4uideIDB db) {
        this.db = db;
    }

    public boolean groupExists(String group) throws DbException {
        try {
            _Cu cu = _Cu.alloc();
            cu.append(group);
            EavEntityCu ecu = new EavEntityCu((_ItemSpace)this.db, ENTITY, cu);
            return ecu.exists();
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    public void addGroup(String group) throws DbException {
        try {
            _Cu cu = _Cu.alloc();
            cu.append(group);
            EavEntityCu ecu = new EavEntityCu((_ItemSpace)this.db, ENTITY, cu);
            ecu.createPK();
            this.db.commit();
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    public void deleteGroup(String group) throws DbException {
        if (!this.groupExists(group)) {
            throw new DbException("Group does not exist");
        }
        List<String> usersInGroup = this.listUsersForGroup(group);
        for (String user : usersInGroup) {
            this.removeUserFromGroup(group, user);
        }
        _Cu cu = _Cu.alloc();
        try {
            cu.append(group);
            EavEntityCu ecu = new EavEntityCu((_ItemSpace)this.db, ENTITY, cu);
            ecu.deleteEntity();
            this.db.commit();
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
        finally {
            cu.dispose();
        }
    }

    public List<String> listGroups() throws DbException {
        try {
            _Cu cu = _Cu.alloc();
            LinkedList<String> result = new LinkedList<String>();
            cu.append(ENTITY);
            int pl = cu.length();
            while (this.db.next(cu, pl)) {
                String group = cu.stringAt(pl);
                result.add(group);
                cu.setLength(cu.skipString(pl));
                cu.incrementSuffix(pl);
            }
            return result;
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    public void addUserToGroup(String group, String username) throws DbException {
        try {
            if (!this.groupExists(group)) {
                throw new DbException("Group does not exist");
            }
            FEUserEAV userEav = new FEUserEAV(this.db);
            if (!userEav.usernameExists(username)) {
                throw new DbException("User does not exist");
            }
            _Cu cu = _Cu.alloc();
            cu.append(ENTITY).append(group).append(A_USER).append(username);
            this.db.insert(cu);
            cu.clear();
            cu.append(FEUserEAV.ENTITY).append(username).append(FEUserEAV.A_GROUP).append(group);
            this.db.insert(cu);
            this.db.commit();
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    public void removeUserFromGroup(String group, String username) throws DbException {
        try {
            _Cu cu = _Cu.alloc();
            cu.append(ENTITY).append(group).append(A_USER).append(username);
            this.db.delete(cu);
            cu.clear();
            cu.append(FEUserEAV.ENTITY).append(username).append(FEUserEAV.A_GROUP).append(group);
            this.db.delete(cu);
            this.db.commit();
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    public boolean isUserInGroup(String group, String username) throws DbException {
        try {
            _Cu cu = _Cu.alloc();
            cu.append(ENTITY).append(group).append(A_USER).append(username);
            return this.db.exists(cu);
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    public List<String> listGroupsForUser(String username) throws DbException {
        try {
            _Cu pk = _Cu.alloc();
            pk.append(username);
            EavEntityCu eav = new EavEntityCu((_ItemSpace)this.db, FEUserEAV.ENTITY, pk);
            return eav.getStrings(FEUserEAV.A_GROUP);
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    public List<String> listUsersForGroup(String group) throws DbException {
        try {
            _Cu pk = _Cu.alloc();
            pk.append(group);
            EavEntityCu eav = new EavEntityCu((_ItemSpace)this.db, ENTITY, pk);
            return eav.getStrings(A_USER);
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }
}

