/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.user;

import com.cenqua.fisheye.config.DB0EAV;
import com.cenqua.fisheye.infinitydb.EavEntityCu;
import com.cenqua.fisheye.infinitydb.InfinityDbUtil;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.user.FEGroupEAV;
import com.cenqua.fisheye.user.FEUser;
import com.cenqua.fisheye.web.UserProfile;
import com.cenqua.fisheye.web.UserProfileManager;
import com.cenqua.obfuscate.idbk4uide._Attribute;
import com.cenqua.obfuscate.idbk4uide._Cu;
import com.cenqua.obfuscate.idbk4uide._EntityClass;
import com.cenqua.obfuscate.idbk4uide._Inversion;
import com.cenqua.obfuscate.idbk4uide._ItemSpace;
import com.cenqua.obfuscate.idbk4uide._k4uideIDB;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FEUserEAV {
    public static final _EntityClass ENTITY = DB0EAV.FEUSER;
    public static final _Attribute A_EMAIL = new _Attribute(10L);
    public static final _Attribute A_PASSWORDHASH = new _Attribute(11L);
    public static final _Attribute A_AUTHTYPE = new _Attribute(12L);
    public static final _Attribute A_TIMEZONE = new _Attribute(13L);
    public static final _Attribute A_TABWIDTH = new _Attribute(14L);
    public static final _Attribute A_COOKIEPREFS = new _Attribute(15L);
    public static final _Attribute A_WATCHMODE = new _Attribute(16L);
    public static final _Attribute A_EMAILFORMAT = new _Attribute(17L);
    public static final _Attribute A_AUTHORMAPPING = new _Attribute(18L);
    public static final _Attribute A_CHANGESETSPERPAGE = new _Attribute(19L);
    public static final _Attribute A_MAXFILESPERCHANGESET = new _Attribute(20L);
    public static final _Attribute A_DISPLAYNAME = new _Attribute(21L);
    public static final _Attribute A_CRU_ENABLED = new _Attribute(22L);
    public static final _Attribute A_GROUP = new _Attribute(40L);
    public static final _Attribute IDX_EMAIL = new _Attribute(100L);
    public static final _Inversion INV_EMAIL = new _Inversion(DB0EAV.SCHEMA, ENTITY, A_EMAIL, DB0EAV.INDEX_EMAIL_TO_FEUSER, IDX_EMAIL);
    public static final _Inversion INV_EMAIL_SECONDARY = INV_EMAIL.getInverseInversion();
    static final String CRU_USER_UPGRADE_ALREADY_PERFORMED = "crucible.user.upgrade.performed";
    private final _k4uideIDB db;

    public FEUserEAV(_k4uideIDB db) {
        this.db = db;
    }

    public boolean usernameExists(String username) throws DbException {
        _Cu cu = _Cu.alloc();
        try {
            cu.append(username);
            EavEntityCu ecu = new EavEntityCu((_ItemSpace)this.db, ENTITY, cu);
            boolean bl = ecu.exists();
            return bl;
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
        finally {
            cu.dispose();
        }
    }

    public boolean emailExists(String email) throws DbException {
        return this.getUsernameForEmail(email) != null;
    }

    public String getUsernameForEmail(String email) throws DbException {
        _Cu val = _Cu.alloc();
        _Cu cu = _Cu.alloc();
        cu.append(email);
        try {
            if (INV_EMAIL_SECONDARY.next(this.db, cu, val)) {
                return val.stringAt(0);
            }
            return null;
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    public FEUser load(String username) throws DbException {
        _Cu cu = _Cu.alloc();
        try {
            cu.append(username);
            EavEntityCu ecu = new EavEntityCu((_ItemSpace)this.db, ENTITY, cu);
            if (!ecu.exists()) {
                FEUser fEUser = null;
                return fEUser;
            }
            FEUser user = new FEUser(username);
            user.setEmail(ecu.getString(A_EMAIL, null));
            user.setDisplayName(ecu.getString(A_DISPLAYNAME, null));
            user.setPasswordHash(ecu.getString(A_PASSWORDHASH, null));
            user.setAuthType(ecu.getInt(A_AUTHTYPE, 1));
            user.setCrucibleEnabled(ecu.getBoolean(A_CRU_ENABLED, false));
            FEUser fEUser = user;
            return fEUser;
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
        finally {
            cu.dispose();
        }
    }

    public void update(FEUser user) throws DbException {
        _Cu cu = _Cu.alloc();
        try {
            cu.append(user.getUsername());
            EavEntityCu ecu = new EavEntityCu((_ItemSpace)this.db, ENTITY, cu);
            ecu.createPK();
            ecu.updateStringInversion(INV_EMAIL, user.getEmail());
            ecu.updateString(A_DISPLAYNAME, user.getDisplayName());
            ecu.updateString(A_PASSWORDHASH, user.getPasswordHash());
            ecu.updateInt(A_AUTHTYPE, user.getAuthType());
            this.db.commit();
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
        finally {
            cu.dispose();
        }
    }

    public UserProfile loadProfile(String username) throws DbException {
        _Cu cu = _Cu.alloc();
        try {
            cu.append(username);
            EavEntityCu ecu = new EavEntityCu((_ItemSpace)this.db, ENTITY, cu);
            if (!ecu.exists()) {
                UserProfile userProfile = null;
                return userProfile;
            }
            UserProfile profile = new UserProfile(username);
            profile.setTimezone(ecu.getString(A_TIMEZONE, UserProfileManager.DEFAULT_PROFILE.getTimezone()));
            profile.setTabwidth(ecu.getInt(A_TABWIDTH, UserProfileManager.DEFAULT_PROFILE.getTabwidth()));
            profile.setCookiePrefs(ecu.getString(A_COOKIEPREFS, ""));
            profile.setWatchMode(ecu.getInt(A_WATCHMODE, UserProfileManager.DEFAULT_PROFILE.getWatchMode()));
            profile.setEmailFormat(ecu.getInt(A_EMAILFORMAT, UserProfileManager.DEFAULT_PROFILE.getEmailFormat()));
            profile.setAuthorMapping(UserProfile.AuthorMappings.fromString(ecu.getString(A_AUTHORMAPPING, "")));
            profile.setChangesetsPerPage(ecu.getInt(A_CHANGESETSPERPAGE, UserProfileManager.DEFAULT_PROFILE.getChangesetsPerPage()));
            profile.setMaxFilesPerChangeset(ecu.getInt(A_MAXFILESPERCHANGESET, UserProfileManager.DEFAULT_PROFILE.getMaxFilesPerChangeset()));
            UserProfile userProfile = profile;
            return userProfile;
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
        finally {
            cu.dispose();
        }
    }

    public void updateProfile(UserProfile profile) throws DbException {
        _Cu cu = _Cu.alloc();
        try {
            cu.append(profile.getUsername());
            EavEntityCu ecu = new EavEntityCu((_ItemSpace)this.db, ENTITY, cu);
            ecu.createPK();
            ecu.updateString(A_TIMEZONE, profile.getTimezone());
            ecu.updateInt(A_TABWIDTH, profile.getTabwidth());
            ecu.updateString(A_COOKIEPREFS, profile.getCookiePrefs());
            ecu.updateInt(A_WATCHMODE, profile.getWatchMode());
            ecu.updateInt(A_EMAILFORMAT, profile.getEmailFormat());
            ecu.updateString(A_AUTHORMAPPING, profile.getAuthorMappings().toString());
            ecu.updateInt(A_CHANGESETSPERPAGE, profile.getChangesetsPerPage());
            ecu.updateInt(A_MAXFILESPERCHANGESET, profile.getMaxFilesPerChangeset());
            this.db.commit();
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
        finally {
            cu.dispose();
        }
    }

    public List<String> listAllUserNames() throws DbException {
        _Cu cu = _Cu.alloc();
        try {
            LinkedList<String> result = new LinkedList<String>();
            cu.append(ENTITY);
            int pl = cu.length();
            while (this.db.next(cu, pl)) {
                String uname = cu.stringAt(pl);
                result.add(uname);
                cu.setLength(cu.skipString(pl));
                cu.incrementSuffix(pl);
            }
            LinkedList<String> linkedList = result;
            return linkedList;
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
        finally {
            cu.dispose();
        }
    }

    public void delete(String username) throws DbException {
        _Cu cu = _Cu.alloc();
        try {
            this.deleteUserFromAllGroups(username);
            cu.append(username);
            EavEntityCu ecu = new EavEntityCu((_ItemSpace)this.db, ENTITY, cu);
            ecu.deleteInversion(INV_EMAIL);
            ecu.deleteEntity();
            this.db.commit();
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
        finally {
            cu.dispose();
        }
    }

    private void deleteUserFromAllGroups(String username) throws DbException {
        FEGroupEAV geav = new FEGroupEAV(this.db);
        List<String> groups = geav.listGroupsForUser(username);
        for (String group : groups) {
            geav.removeUserFromGroup(group, username);
        }
    }

    public int countNumberOfCrucibleUsers() throws DbException {
        _Cu cu = _Cu.alloc();
        try {
            int count = 0;
            cu.append(ENTITY);
            int pl = cu.length();
            while (this.db.next(cu, pl)) {
                cu.setLength(cu.skipString(pl));
                cu.append(A_CRU_ENABLED).append(true);
                if (this.db.exists(cu)) {
                    ++count;
                }
                cu.setLength(cu.skipString(pl));
                cu.incrementSuffix(pl);
            }
            int n = count;
            return n;
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
        finally {
            cu.dispose();
        }
    }

    public List<String> listAllCrucibleUserNames() throws DbException {
        _Cu cu = _Cu.alloc();
        try {
            LinkedList<String> result = new LinkedList<String>();
            cu.append(ENTITY);
            int pl = cu.length();
            while (this.db.next(cu, pl)) {
                String uname = cu.stringAt(pl);
                cu.setLength(cu.skipString(pl));
                cu.append(A_CRU_ENABLED).append(true);
                if (this.db.exists(cu)) {
                    result.add(uname);
                }
                cu.setLength(cu.skipString(pl));
                cu.incrementSuffix(pl);
            }
            LinkedList<String> linkedList = result;
            return linkedList;
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
        finally {
            cu.dispose();
        }
    }

    public void setCrucibleEnabled(String username, boolean enabled) throws DbException {
        _Cu cu = _Cu.alloc();
        try {
            cu.append(username);
            EavEntityCu ecu = new EavEntityCu((_ItemSpace)this.db, ENTITY, cu);
            if (!ecu.exists()) {
                return;
            }
            ecu.updateBoolean(A_CRU_ENABLED, enabled);
            this.db.commit();
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
        finally {
            cu.dispose();
        }
    }

    public void updateInitialCrucibleUsers(int maxCruUsers) throws DbException {
        _Cu cu = _Cu.alloc();
        try {
            int enabledUsers;
            long val = InfinityDbUtil.getLong(this.db, DB0EAV.CONSTANTS, CRU_USER_UPGRADE_ALREADY_PERFORMED);
            if (val != 0L) {
                return;
            }
            cu.append(ENTITY);
            int pl = cu.length();
            for (enabledUsers = 0; this.db.next(cu, pl) && enabledUsers < maxCruUsers; ++enabledUsers) {
                cu.setLength(cu.skipString(pl));
                cu.append(A_CRU_ENABLED).append(true);
                this.db.insert(cu);
                cu.setLength(cu.skipString(pl));
                cu.incrementSuffix(pl);
            }
            Logs.APP_LOG.info((Object)("Enabled " + enabledUsers + " users as Crucible users."));
            InfinityDbUtil.incrementLong(this.db, DB0EAV.CONSTANTS, CRU_USER_UPGRADE_ALREADY_PERFORMED);
            this.db.commit();
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
        finally {
            cu.dispose();
        }
    }
}

