/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.vis;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.text.NumberFormat;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.CategoryItemEntity;
import org.jfree.chart.entity.ChartEntity;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.labels.CategoryToolTipGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.CategoryItemRendererState;
import org.jfree.chart.renderer.category.StackedBarRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.text.TextUtilities;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.TextAnchor;

public class ExtendedStackedBarRenderer
extends StackedBarRenderer {
    private boolean showPositiveTotal = true;
    private boolean showNegativeTotal = true;
    private Font totalLabelFont = new Font("SansSerif", 0, 10);
    private NumberFormat totalFormatter = NumberFormat.getInstance();

    public NumberFormat getTotalFormatter() {
        return this.totalFormatter;
    }

    public void setTotalFormatter(NumberFormat format) {
        if (format == null) {
            throw new IllegalArgumentException("Null format not permitted.");
        }
        this.totalFormatter = format;
    }

    public void drawItem(Graphics2D g2, CategoryItemRendererState state, Rectangle2D dataArea, CategoryPlot plot, CategoryAxis domainAxis, ValueAxis rangeAxis, CategoryDataset dataset, int row, int column, int pass) {
        EntityCollection entities;
        double translatedValue;
        double translatedBase;
        Number dataValue = dataset.getValue(row, column);
        if (dataValue == null) {
            return;
        }
        double value = dataValue.doubleValue();
        PlotOrientation orientation = plot.getOrientation();
        double barW0 = domainAxis.getCategoryMiddle(column, this.getColumnCount(), dataArea, plot.getDomainAxisEdge()) - state.getBarWidth() / 2.0;
        double positiveBase = 0.0;
        double negativeBase = 0.0;
        for (int i2 = 0; i2 < row; ++i2) {
            Number v = dataset.getValue(i2, column);
            if (v == null) continue;
            double d2 = v.doubleValue();
            if (d2 > 0.0) {
                positiveBase += d2;
                continue;
            }
            negativeBase += d2;
        }
        RectangleEdge location = plot.getRangeAxisEdge();
        if (value > 0.0) {
            translatedBase = rangeAxis.valueToJava2D(positiveBase, dataArea, location);
            translatedValue = rangeAxis.valueToJava2D(positiveBase + value, dataArea, location);
        } else {
            translatedBase = rangeAxis.valueToJava2D(negativeBase, dataArea, location);
            translatedValue = rangeAxis.valueToJava2D(negativeBase + value, dataArea, location);
        }
        double barL0 = Math.min(translatedBase, translatedValue);
        double barLength = Math.max(Math.abs(translatedValue - translatedBase), this.getMinimumBarLength());
        Rectangle2D.Double bar = null;
        bar = orientation == PlotOrientation.HORIZONTAL ? new Rectangle2D.Double(barL0, barW0, barLength, state.getBarWidth()) : new Rectangle2D.Double(barW0, barL0, state.getBarWidth(), barLength);
        Paint seriesPaint = this.getItemPaint(row, column);
        g2.setPaint(seriesPaint);
        g2.fill(bar);
        if (this.isDrawBarOutline() && state.getBarWidth() > 3.0) {
            g2.setStroke(this.getItemStroke(row, column));
            g2.setPaint(this.getItemOutlinePaint(row, column));
            g2.draw(bar);
        }
        if (value > 0.0) {
            if (this.showPositiveTotal && this.isLastPositiveItem(dataset, row, column)) {
                g2.setPaint(Color.black);
                g2.setFont(this.totalLabelFont);
                double total = this.calculateSumOfPositiveValuesForCategory(dataset, column);
                TextUtilities.drawRotatedString((String)this.totalFormatter.format(total), (Graphics2D)g2, (float)((float)bar.getCenterX()), (float)((float)(bar.getMinY() - 4.0)), (TextAnchor)TextAnchor.BOTTOM_CENTER, (double)0.0, (TextAnchor)TextAnchor.BOTTOM_CENTER);
            }
        } else if (this.showNegativeTotal && this.isLastNegativeItem(dataset, row, column)) {
            g2.setPaint(Color.black);
            g2.setFont(this.totalLabelFont);
            double total = this.calculateSumOfNegativeValuesForCategory(dataset, column);
            TextUtilities.drawRotatedString((String)String.valueOf(total), (Graphics2D)g2, (float)((float)bar.getCenterX()), (float)((float)(bar.getMaxY() + 4.0)), (TextAnchor)TextAnchor.TOP_CENTER, (double)0.0, (TextAnchor)TextAnchor.TOP_CENTER);
        }
        if (state.getInfo() != null && (entities = state.getEntityCollection()) != null) {
            String tip = null;
            CategoryToolTipGenerator tipster = this.getToolTipGenerator(row, column);
            if (tipster != null) {
                tip = tipster.generateToolTip(dataset, row, column);
            }
            String url = null;
            if (this.getItemURLGenerator(row, column) != null) {
                url = this.getItemURLGenerator(row, column).generateURL(dataset, row, column);
            }
            CategoryItemEntity entity = new CategoryItemEntity((Shape)bar, tip, url, dataset, row, (Object)dataset.getColumnKey(column), column);
            entities.add((ChartEntity)entity);
        }
    }

    private boolean isLastPositiveItem(CategoryDataset dataset, int row, int column) {
        boolean result = true;
        Number dataValue = dataset.getValue(row, column);
        if (dataValue == null) {
            return false;
        }
        for (int r = row + 1; r < dataset.getRowCount(); ++r) {
            dataValue = dataset.getValue(r, column);
            if (dataValue == null) continue;
            result = result && dataValue.doubleValue() <= 0.0;
        }
        return result;
    }

    private boolean isLastNegativeItem(CategoryDataset dataset, int row, int column) {
        boolean result = true;
        Number dataValue = dataset.getValue(row, column);
        if (dataValue == null) {
            return false;
        }
        for (int r = row + 1; r < dataset.getRowCount(); ++r) {
            dataValue = dataset.getValue(r, column);
            if (dataValue == null) continue;
            result = result && dataValue.doubleValue() >= 0.0;
        }
        return result;
    }

    private double calculateSumOfPositiveValuesForCategory(CategoryDataset dataset, int column) {
        double result = 0.0;
        for (int r = 0; r < dataset.getRowCount(); ++r) {
            double v;
            Number dataValue = dataset.getValue(r, column);
            if (dataValue == null || !((v = dataValue.doubleValue()) > 0.0)) continue;
            result += v;
        }
        return result;
    }

    private double calculateSumOfNegativeValuesForCategory(CategoryDataset dataset, int column) {
        double result = 0.0;
        for (int r = 0; r < dataset.getRowCount(); ++r) {
            double v;
            Number dataValue = dataset.getValue(r, column);
            if (dataValue == null || !((v = dataValue.doubleValue()) < 0.0)) continue;
            result += v;
        }
        return result;
    }
}

