/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.vis;

import com.cenqua.fisheye.cache.RevisionCache;
import com.cenqua.fisheye.infinitydb.query3.AndQuery3;
import com.cenqua.fisheye.infinitydb.query3.AnyLongRangeQuery3;
import com.cenqua.fisheye.infinitydb.query3.NotQuery3;
import com.cenqua.fisheye.infinitydb.query3.OrQuery3;
import com.cenqua.fisheye.infinitydb.query3.Query3;
import com.cenqua.fisheye.infinitydb.query3.TermQuery3;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.lucene.LuceneConnection;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.RepositoryEngine;
import com.cenqua.fisheye.rep.impl.CommonQuery3Helper;
import com.cenqua.fisheye.rep.impl.CommonSchema;
import com.cenqua.fisheye.vis.LinecountCollator;
import com.cenqua.fisheye.vis.QueryParams;
import com.cenqua.obfuscate.idbk4uide._Cu;
import com.cenqua.obfuscate.idbk4uide._ItemSpace;
import com.cenqua.obfuscate.idbk4uide._k4uideIDB;
import java.io.IOException;

public class LinecountCalculator {
    private QueryParams params = null;

    public void setParams(QueryParams params) {
        this.checkParams(params);
        this.params = params;
    }

    private void checkParams(QueryParams params) {
        if (params == null) {
            throw new IllegalArgumentException("QueryParams must not be null");
        }
    }

    public QueryParams getParams() {
        return this.params;
    }

    public boolean incrementalUpdateSupported() {
        return this.params.getBranch() == null;
    }

    void collectLineCounts(RepositoryEngine rep, Visitor v) throws DbException {
        this.checkParams(this.params);
        LuceneConnection conn = rep.getLuceneConnection();
        RevisionCache cache = rep.getRevisionCache();
        _k4uideIDB db = cache.getInfDb().get();
        AndQuery3 originQuery = null;
        boolean isDir = this.params.getPath() == null || cache.isDir(this.params.getPath());
        boolean isCvs = cache.getRepositoryType().equals("cvs");
        String branch = this.params.getBranch();
        if (isCvs && branch != null) {
            originQuery = this.getBasicQuery(isDir, cache.isCaseSensitive());
            originQuery.addClause(new TermQuery3(CommonSchema.E_BP_ON_BRANCH_TO_REVID, branch, null));
        }
        AndQuery3 tailQuery = this.getBasicQuery(isDir, cache.isCaseSensitive());
        if (branch != null) {
            tailQuery.addClause(this.makeBranchQuery(isCvs, branch));
        } else {
            tailQuery.addClause(CommonQuery3Helper.findTrunkLikeRevisionQuery());
        }
        LinecountCalculator.collectLineCounts(db, conn, originQuery, branch, tailQuery, v);
    }

    private Query3 makeBranchQuery(boolean isCvs, String branch) {
        TermQuery3 t = new TermQuery3(CommonSchema.E_MOD_ON_BRANCH_TO_REVID, branch, null);
        if (isCvs) {
            return t;
        }
        OrQuery3 q = new OrQuery3();
        q.addClause(t);
        q.addClause(new TermQuery3(CommonSchema.E_UNMOD_ON_BRANCH_TO_REVID, branch, null));
        return q;
    }

    public void updateLineCounts(RepositoryEngine rep, long fromDate, final Visitor v) throws DbException {
        this.checkParams(this.params);
        if (!this.incrementalUpdateSupported()) {
            throw new IllegalArgumentException("incremental update not supported for " + this.params);
        }
        LuceneConnection conn = rep.getLuceneConnection();
        RevisionCache cache = rep.getRevisionCache();
        _k4uideIDB db = cache.getInfDb().get();
        boolean isDir = this.params.getPath() == null || cache.isDir(this.params.getPath());
        try {
            AndQuery3 subtractExtantQuery = this.getBasicQuery(isDir, cache.isCaseSensitive());
            subtractExtantQuery.addClause(CommonQuery3Helper.findTrunkLikeRevisionQuery());
            subtractExtantQuery.addClause(new NotQuery3(new AnyLongRangeQuery3(CommonSchema.E_DATE_TO_REVID, fromDate, false, Long.MAX_VALUE, true)));
            subtractExtantQuery.addClause(new AnyLongRangeQuery3(CommonSchema.E_DATE_END_TO_REVID, fromDate, false, Long.MAX_VALUE, true));
            _ItemSpace subtractExtantSpace = subtractExtantQuery.asItemSpace((_ItemSpace)db, conn);
            LinecountCalculator.visitData(db, subtractExtantSpace, null, new DataVisitor(){

                public void visit(int revid, long t0, long t1, int total, int added, int removed) throws DbException {
                    if (t1 != Long.MAX_VALUE) {
                        v.updateEndDate(revid, t0, t1, total);
                    }
                }
            });
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
        AndQuery3 tailQuery = this.getBasicQuery(isDir, cache.isCaseSensitive());
        tailQuery.addClause(CommonQuery3Helper.findTrunkLikeRevisionQuery());
        tailQuery.addClause(new AnyLongRangeQuery3(CommonSchema.E_DATE_TO_REVID, fromDate, false, Long.MAX_VALUE, true));
        LinecountCalculator.collectLineCounts(db, conn, null, null, tailQuery, v);
    }

    private AndQuery3 getBasicQuery(boolean isDir, boolean caseSensitive) {
        AndQuery3 q = isDir ? CommonQuery3Helper.findRevisionsUnderDirQuery3(this.params.getPath(), caseSensitive) : CommonQuery3Helper.findRevisionsAtPathQuery3(this.params.getPath(), caseSensitive);
        if (this.params.isHeadOnly()) {
            if (this.params.getBranch() != null) {
                q.addClause(new TermQuery3(CommonSchema.E_HEAD_IN_BRANCH_TO_REVID, this.params.getBranch(), null));
            } else {
                q.addClause(new TermQuery3(CommonSchema.E_HEAD_IN_ANY_BRANCH_REVIDS, _Cu.alloc(), null));
            }
        }
        if (!this.params.getAuthors().isEmpty()) {
            OrQuery3 aq = new OrQuery3();
            for (String author : this.params.getAuthors()) {
                if (author == null) continue;
                aq.addClause(new TermQuery3(CommonSchema.E_AUTHOR_TO_REVID, author, null));
            }
            q.addClause(aq);
        }
        return q;
    }

    private static void collectLineCounts(_ItemSpace db, LuceneConnection conn, Query3 originQuery, String bp, Query3 tailQuery, final Visitor v) throws DbException {
        try {
            boolean hasTail;
            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            class TailVisitor
            implements DataVisitor {
                long mindate = Long.MAX_VALUE;
                final /* synthetic */ Visitor val$v;

                TailVisitor(Visitor visitor) {
                    this.val$v = visitor;
                }

                @Override
                public void visit(int revid, long t0, long t1, int total, int added, int removed) throws DbException {
                    this.val$v.visit(revid, t0, t1, total, false);
                    if (t0 < this.mindate) {
                        this.mindate = t0;
                    }
                }
            }
            TailVisitor tailv = new TailVisitor(v);
            _ItemSpace tailSpace = tailQuery.asItemSpace(db, conn);
            LinecountCalculator.visitData(db, tailSpace, null, tailv);
            boolean bl = hasTail = tailv.mindate != Long.MAX_VALUE;
            if (originQuery != null && hasTail) {
                final long originClampDate = tailv.mindate;
                _ItemSpace originSpace = originQuery.asItemSpace(db, conn);
                LinecountCalculator.visitData(db, originSpace, bp, new DataVisitor(){

                    public void visit(int revid, long t0, long t1, int total, int added, int removed) throws DbException {
                        if (t1 < originClampDate) {
                            return;
                        }
                        t0 = Math.max(t0, originClampDate - 1L);
                        v.visit(revid, t0, t1, total, true);
                    }
                });
            }
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    public static void visitData(_ItemSpace db, _ItemSpace revids, String bp, DataVisitor v) throws IOException, DbException {
        _Cu cu = _Cu.alloc();
        _Cu data = _Cu.alloc();
        data.append(CommonSchema.RevInfo.ENTITY);
        int datap0 = data.length();
        while (revids.next(cu)) {
            int revid = (int)cu.longAt(0);
            data.setLength(datap0).append(revid).append(CommonSchema.RevInfo.A_DATE);
            int pl = data.length();
            if (!db.next(data, pl)) {
                Logs.APP_LOG.warn((Object)("no date stored for revid " + revid));
                continue;
            }
            long date = data.longAt(pl);
            data.setLength(datap0).append(revid);
            if (bp == null) {
                data.append(CommonSchema.RevInfo.A_DATE_END);
            } else {
                data.append(CommonSchema.RevInfo.A_BRANCH_POINT_EXTENT).append(bp);
            }
            pl = data.length();
            if (!db.next(data, pl)) {
                Logs.APP_LOG.warn((Object)("no dateEnd stored for revid " + revid));
                continue;
            }
            long dateEnd = data.longAt(pl);
            data.setLength(datap0).append(revid).append(CommonSchema.RevInfo.A_LINEDATA);
            pl = data.length();
            if (!db.next(data, pl)) continue;
            int total = (int)data.longAt(pl);
            pl = data.skipLong(pl);
            int added = (int)data.longAt(pl);
            pl = data.skipLong(pl);
            int removed = (int)data.longAt(pl);
            v.visit(revid, date, dateEnd, total, added, removed);
        }
    }

    public static interface DataVisitor {
        public void visit(int var1, long var2, long var4, int var6, int var7, int var8) throws DbException;
    }

    public static class StandardVisitor
    implements Visitor {
        private final LinecountCollator lc;

        public StandardVisitor(LinecountCollator lc) {
            this.lc = lc;
        }

        public void visit(int revid, long t0, long t1, int total, boolean isOrigin) throws DbException {
            if (isOrigin) {
                this.lc.addDatapoint(t0, t1, total, 0L);
            } else {
                this.lc.addDatapoint(t0, t1, total, 1L);
            }
        }

        public void updateEndDate(int revid, long t0, long t1, int total) throws DbException {
            this.lc.updateEndPoint(t1, total);
        }
    }

    public static interface Visitor {
        public void visit(int var1, long var2, long var4, int var6, boolean var7) throws DbException;

        public void updateEndDate(int var1, long var2, long var4, int var6) throws DbException;
    }
}

