/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.vis;

import com.cenqua.fisheye.util.ScalerUtil;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import javax.imageio.ImageIO;

public class TimeframeVisualiser {
    private final long mStart;
    private final long mEnd;
    private final long mSelectedStart;
    private final long mSelectedEnd;

    public TimeframeVisualiser(long start, long end, long selectedStart, long selectedEnd) {
        this.mStart = start;
        this.mEnd = end;
        this.mSelectedStart = selectedStart;
        this.mSelectedEnd = selectedEnd;
    }

    public String getImageContentType() {
        return "image/png";
    }

    public void renderTimeline(int width, int height, OutputStream out) throws IOException {
        BufferedImage img = new BufferedImage(width, height, 2);
        Graphics2D g2 = img.createGraphics();
        Color bg = new Color(240, 240, 240);
        Color tf = new Color(161, 255, 161);
        Color tfBorder = new Color(4, 128, 4);
        int tickHeight = 3;
        ScalerUtil scale = new ScalerUtil();
        scale.setDomainMin(this.mStart);
        scale.setDomainMax(this.mEnd);
        scale.setPixelUpperClamp(width);
        scale.setPixelWidth(width);
        scale.setDomainValue(this.mSelectedStart);
        int x0 = scale.getValue();
        scale.setDomainValue(this.mSelectedEnd);
        int x1 = scale.getValue();
        int tfw = Math.max(x1 - x0, 4);
        if (x0 + tfw > width) {
            x0 = width - tfw;
        }
        int h2 = height - 3;
        g2.setColor(bg);
        g2.fillRect(0, 0, width, h2);
        g2.setColor(Color.GRAY);
        g2.drawRect(0, 0, width - 1, h2 - 1);
        g2.setColor(tf);
        g2.fillRect(x0, 0, tfw, h2 - 1);
        g2.setColor(tfBorder);
        g2.drawRect(x0, 0, tfw - 1, h2 - 1);
        g2.setColor(Color.GRAY);
        g2.drawLine(0, h2, 0, height);
        g2.drawLine(width - 1, h2, width - 1, height);
        g2.dispose();
        ImageIO.write((RenderedImage)img, "PNG", out);
    }
}

