/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web;

import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.config.DB0EAV;
import com.cenqua.fisheye.infinitydb.EavEntityCu;
import com.cenqua.fisheye.infinitydb.InfinityDbUtil;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.RevInfoKey;
import com.cenqua.fisheye.web.CommandString;
import com.cenqua.fisheye.web.Watch;
import com.cenqua.fisheye.web.WaybackSpec;
import com.cenqua.obfuscate.idbk4uide._Attribute;
import com.cenqua.obfuscate.idbk4uide._Cu;
import com.cenqua.obfuscate.idbk4uide._EntityClass;
import com.cenqua.obfuscate.idbk4uide._Inversion;
import com.cenqua.obfuscate.idbk4uide._ItemSpace;
import com.cenqua.obfuscate.idbk4uide._k4uideIDB;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WatchEAV {
    public static final _EntityClass ENTITY = DB0EAV.WATCH;
    public static final _Attribute A_USER = new _Attribute(10L);
    public static final _Attribute A_REP = new _Attribute(11L);
    public static final _Attribute A_PATH = new _Attribute(12L);
    public static final _Attribute A_CONSTRAINT = new _Attribute(13L);
    public static final _Attribute A_LASTCHECKED = new _Attribute(14L);
    public static final _Attribute A_LASTREVISION_PATH = new _Attribute(16L);
    public static final _Attribute A_LASTREVISION_REV = new _Attribute(17L);
    public static final _Attribute A_CSN_LASTREVISION = new _Attribute(18L);
    public static final _Attribute IDX_USER = new _Attribute(100L);
    public static final _Attribute IDX_REP = new _Attribute(101L);
    public static final _Inversion INV_USER = new _Inversion(DB0EAV.SCHEMA, ENTITY, A_USER, DB0EAV.INDEX_USER_TO_WATCH, IDX_USER);
    public static final _Inversion INV_USER_SECONDARY = INV_USER.getInverseInversion();
    public static final _Inversion INV_REP = new _Inversion(DB0EAV.SCHEMA, ENTITY, A_REP, DB0EAV.INDEX_REP_TO_WATCH, IDX_REP);
    public static final _Inversion INV_REP_SECONDARY = INV_REP.getInverseInversion();
    private final _k4uideIDB db;

    public WatchEAV(_k4uideIDB db) {
        this.db = db;
    }

    private long makeId() throws DbException {
        try {
            return InfinityDbUtil.incrementLong(this.db, DB0EAV.CONSTANTS, "watch.counter");
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    public long add(Watch watch) throws DbException {
        _Cu cu = _Cu.alloc();
        try {
            long id = this.makeId();
            cu.append(id);
            EavEntityCu ecu = new EavEntityCu((_ItemSpace)this.db, ENTITY, cu);
            ecu.createPK();
            ecu.updateStringInversion(INV_REP, watch.getRep());
            ecu.updateStringInversion(INV_USER, watch.getUser());
            ecu.updateString(A_PATH, watch.getPath().toString());
            if (watch.getConstraint() != null) {
                ecu.updateString(A_CONSTRAINT, watch.getConstraint().toCommandString().toString());
            }
            ecu.updateLong(A_LASTCHECKED, watch.getLastChecked());
            RevInfoKey lastRevision = watch.getLastRevisionSent();
            if (lastRevision != null) {
                ecu.updateString(A_LASTREVISION_PATH, lastRevision.getPath().getPath());
                ecu.updateString(A_LASTREVISION_REV, lastRevision.getRev());
            }
            ecu.updateLong(A_CSN_LASTREVISION, watch.getCacheSerialOfLastRevisionSent());
            this.db.commit();
            long l = id;
            return l;
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
        finally {
            cu.dispose();
        }
    }

    public void delete(long watchid) throws DbException {
        _Cu cu = _Cu.alloc();
        try {
            cu.append(watchid);
            EavEntityCu ecu = new EavEntityCu((_ItemSpace)this.db, ENTITY, cu);
            ecu.deleteInversion(INV_REP);
            ecu.deleteInversion(INV_USER);
            ecu.deleteEntity();
            this.db.commit();
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
        finally {
            cu.dispose();
        }
    }

    public List getWatchesForRep(String rep) throws DbException {
        _Cu val = _Cu.alloc();
        _Cu cu = _Cu.alloc();
        ArrayList<Watch> watches = new ArrayList<Watch>();
        cu.append(rep);
        try {
            while (INV_REP_SECONDARY.next(this.db, cu, val)) {
                long watchID = val.longAt(0);
                watches.add(this.load(watchID));
            }
            return watches;
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    public List<Watch> getWatchesForUser(String username) throws DbException {
        _Cu val = _Cu.alloc();
        _Cu cu = _Cu.alloc();
        ArrayList<Watch> watches = new ArrayList<Watch>();
        cu.append(username);
        try {
            while (INV_USER_SECONDARY.next(this.db, cu, val)) {
                long watchID = val.longAt(0);
                watches.add(this.load(watchID));
            }
            return watches;
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    public Watch load(long watchID) throws DbException {
        _Cu cu = _Cu.alloc();
        try {
            cu.append(watchID);
            EavEntityCu ecu = new EavEntityCu((_ItemSpace)this.db, ENTITY, cu);
            if (!ecu.exists()) {
                Watch watch = null;
                return watch;
            }
            Watch watch = new Watch(watchID);
            watch.setUser(ecu.getString(A_USER, null));
            watch.setRep(ecu.getString(A_REP, null));
            watch.setPath(new Path(ecu.getString(A_PATH, null)));
            watch.setConstraint(WaybackSpec.fromCommandString(new CommandString(ecu.getString(A_CONSTRAINT, ""))));
            watch.setLastChecked(ecu.getLong(A_LASTCHECKED, 0L));
            String lastRevPath = ecu.getString(A_LASTREVISION_PATH, null);
            if (lastRevPath != null) {
                String rev = ecu.getString(A_LASTREVISION_REV, null);
                RevInfoKey rik = new RevInfoKey(new Path(lastRevPath), rev);
                watch.setLastRevisionSent(rik);
            }
            watch.setCacheSerialOfLastRevisionSent(ecu.getLong(A_CSN_LASTREVISION, 1L));
            Watch watch2 = watch;
            return watch2;
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
        finally {
            cu.dispose();
        }
    }

    public void update(Watch watch) throws DbException {
        _Cu cu = _Cu.alloc();
        try {
            cu.append(watch.getId());
            EavEntityCu ecu = new EavEntityCu((_ItemSpace)this.db, ENTITY, cu);
            ecu.createPK();
            ecu.updateStringInversion(INV_REP, watch.getRep());
            ecu.updateStringInversion(INV_USER, watch.getUser());
            ecu.updateString(A_PATH, watch.getPath().toString());
            if (watch.getConstraint() != null) {
                ecu.updateString(A_CONSTRAINT, watch.getConstraint().toCommandString().toString());
            } else {
                ecu.deleteValues(A_CONSTRAINT);
            }
            ecu.updateLong(A_LASTCHECKED, watch.getLastChecked());
            RevInfoKey lastRevision = watch.getLastRevisionSent();
            if (lastRevision != null) {
                ecu.updateString(A_LASTREVISION_PATH, lastRevision.getPath().getPath());
                ecu.updateString(A_LASTREVISION_REV, lastRevision.getRev());
            } else {
                ecu.deleteValues(A_LASTREVISION_PATH);
                ecu.deleteValues(A_LASTREVISION_REV);
            }
            ecu.updateLong(A_CSN_LASTREVISION, watch.getCacheSerialOfLastRevisionSent());
            this.db.commit();
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
        finally {
            cu.dispose();
        }
    }
}

