/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web;

import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.bucket.ParameterSetRetrieve;
import com.cenqua.fisheye.bucket.RenamingRules;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.RepositoryEngine;
import com.cenqua.fisheye.util.DateHelper;
import com.cenqua.fisheye.util.MultiMap;
import com.cenqua.fisheye.web.ChartOption;
import com.cenqua.fisheye.web.CommandString;
import com.cenqua.fisheye.web.FishEyePathInfo;
import com.cenqua.fisheye.web.WaybackSpec;
import com.cenqua.fisheye.web.tags.ExpressionUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import javax.servlet.http.HttpServletRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WaybackSpecChart
extends WaybackSpec {
    private String chartType = "Area";
    private String stackType = "None";
    private String date1Str;
    private String date2Str;
    private String rename;
    private Integer maxItems;
    private List<String> authors;
    private List<String> extns;
    private Long date1;
    private Long date2;
    List<ChartOption> chartTypeOptions;
    List<ChartOption> stackTypeOptions;
    List<ChartOption> authorOptions;
    List<ChartOption> extnOptions;
    private TimeZone tz = TimeZone.getDefault();
    private boolean showAuthorLinecount;

    public WaybackSpecChart() {
    }

    public WaybackSpecChart(boolean showAuthorLinecount) {
        this.showAuthorLinecount = showAuthorLinecount;
    }

    public void setDate1(String dateStr) {
        this.date1 = DateHelper.parseDate(dateStr, System.currentTimeMillis(), this.tz);
        if (this.date1 != null) {
            this.date1Str = dateStr;
        }
    }

    public void setDate1(long date) {
        this.date1 = date;
        this.date1Str = DateHelper.toGmtString(new Date(date));
    }

    public void setDate2(String dateStr) {
        this.date2 = DateHelper.parseDate(dateStr, System.currentTimeMillis(), this.tz);
        if (this.date2 != null) {
            this.date2Str = dateStr;
        }
    }

    public void setDate2(long date) {
        this.date2 = date;
        this.date2Str = DateHelper.toGmtString(new Date(date));
    }

    @Override
    public String getUrlCommandParams() {
        String sep;
        StringBuffer buf = new StringBuffer(super.getUrlCommandParams());
        String string = sep = buf.length() == 0 ? "" : ",";
        if (this.chartType != null) {
            buf.append(sep);
            buf.append("charttype=").append(ExpressionUtil.urlEncode(this.chartType));
            sep = ",";
        }
        if (this.date1Str != null) {
            buf.append(sep);
            buf.append("date1=").append(ExpressionUtil.urlEncode(this.date1Str));
            sep = ",";
        }
        if (this.date2Str != null) {
            buf.append(sep);
            buf.append("date2=").append(ExpressionUtil.urlEncode(this.date2Str));
            sep = ",";
        }
        if (this.stackType != null) {
            buf.append(sep);
            buf.append("stacktype=").append(ExpressionUtil.urlEncode(this.stackType));
            sep = ",";
        }
        if (this.extns != null && this.extns.size() != 0) {
            for (String extn : this.extns) {
                buf.append(sep);
                buf.append("extn=").append(ExpressionUtil.urlEncode(extn));
                sep = ",";
            }
        }
        if (this.authors != null && this.authors.size() != 0) {
            for (String author : this.authors) {
                buf.append(sep);
                buf.append("author=").append(ExpressionUtil.urlEncode(author));
                sep = ",";
            }
        }
        if (this.maxItems != null) {
            buf.append(sep);
            buf.append("maxitems=").append(ExpressionUtil.urlEncode(this.maxItems));
            sep = ",";
        }
        if (this.rename != null) {
            buf.append(sep);
            buf.append("rename=").append(ExpressionUtil.urlEncode(this.rename));
            sep = ",";
        }
        return buf.toString();
    }

    @Override
    public String getDisplayString() {
        StringBuffer buf = new StringBuffer(super.getDisplayString());
        String sep = "";
        if (this.chartType != null) {
            buf.append(sep);
            buf.append("charttype=").append(ExpressionUtil.escapeString(this.chartType));
            sep = ",";
        }
        if (this.stackType != null) {
            buf.append(sep);
            buf.append("stacktype=").append(ExpressionUtil.escapeString(this.stackType));
            sep = ",";
        }
        if (this.date1Str != null) {
            buf.append(sep);
            buf.append("date1=").append(ExpressionUtil.escapeString(this.date1Str));
            sep = ",";
        }
        if (this.date2Str != null) {
            buf.append(sep);
            buf.append("date2=").append(ExpressionUtil.escapeString(this.date2Str));
            sep = ",";
        }
        if (this.extns != null && this.extns.size() != 0) {
            for (String extn : this.extns) {
                buf.append(sep);
                buf.append("extn=").append(ExpressionUtil.escapeString(extn));
                sep = ",";
            }
        }
        if (this.authors != null && this.authors.size() != 0) {
            for (String auth : this.authors) {
                buf.append(sep);
                buf.append("author=").append(ExpressionUtil.escapeString(auth));
                sep = ",";
            }
        }
        if (this.maxItems != null) {
            buf.append(sep);
            buf.append("maxitems=").append(ExpressionUtil.escapeString(this.maxItems.toString()));
            sep = ",";
        }
        if (this.rename != null) {
            buf.append(sep);
            buf.append("rename=").append(ExpressionUtil.escapeString(this.rename));
            sep = ",";
        }
        return buf.toString();
    }

    public static WaybackSpecChart fromRequest(HttpServletRequest req) {
        String wbrename;
        String wbmaxitems;
        String[] wbauthors;
        String[] wbextn;
        String wbdate2;
        String wbdate1;
        String wbstack;
        WaybackSpecChart wb = new WaybackSpecChart();
        WaybackSpec.fromRequest(req, wb);
        String wbtype = req.getParameter("wbtype");
        if (!WaybackSpecChart.isEmpty(wbtype)) {
            wb.setChartType(wbtype.trim());
        }
        if (!WaybackSpecChart.isEmpty(wbstack = req.getParameter("wbstack"))) {
            wb.setStackType(wbstack.trim());
        }
        if (!WaybackSpecChart.isEmpty(wbdate1 = req.getParameter("wbdate1"))) {
            wbdate1 = wbdate1.trim();
            wb.setDate1(wbdate1);
        }
        if (!WaybackSpecChart.isEmpty(wbdate2 = req.getParameter("wbdate2"))) {
            wbdate2 = wbdate2.trim();
            wb.setDate2(wbdate2);
        }
        if (!WaybackSpecChart.isEmpty(wbextn = req.getParameterValues("wbextn"))) {
            wb.setExtns(wbextn);
        }
        if (!WaybackSpecChart.isEmpty(wbauthors = req.getParameterValues("wbauthors"))) {
            wb.setAuthors(wbauthors);
        }
        if (!WaybackSpecChart.isEmpty(wbmaxitems = req.getParameter("wbmaxitems"))) {
            wb.setMaxItems(wbmaxitems.trim());
        }
        if (!WaybackSpecChart.isEmpty(wbrename = req.getParameter("wbrename"))) {
            wb.setRename(wbrename.trim());
        }
        return wb;
    }

    private void setMaxItems(String s) {
        try {
            this.maxItems = Integer.parseInt(s);
        }
        catch (NumberFormatException e2) {
            this.maxItems = null;
        }
    }

    private static boolean isEmpty(String[] wbbr) {
        return wbbr == null || wbbr.length == 0 || wbbr.length == 1 && wbbr[0].trim().length() == 0;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        WaybackSpecChart that = (WaybackSpecChart)o;
        if (this.chartType != null ? !this.chartType.equals(that.chartType) : that.chartType != null) {
            return false;
        }
        if (this.stackType != null ? !this.stackType.equals(that.stackType) : that.stackType != null) {
            return false;
        }
        if (this.date1Str != null ? !this.date1Str.equals(that.date1Str) : that.date1Str != null) {
            return false;
        }
        if (this.date2Str != null ? !this.date2Str.equals(that.date2Str) : that.date2Str != null) {
            return false;
        }
        if (this.extns != null ? !Arrays.equals(this.extns.toArray(), that.extns.toArray()) : that.extns != null) {
            return false;
        }
        if (this.maxItems != null ? !this.maxItems.equals(that.maxItems) : that.maxItems != null) {
            return false;
        }
        return !(this.rename != null ? !this.rename.equals(that.rename) : that.rename != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 29 * result + (this.chartType != null ? this.chartType.hashCode() : 0);
        result = 29 * result + (this.stackType != null ? this.stackType.hashCode() : 0);
        result = 29 * result + (this.date1Str != null ? this.date1Str.hashCode() : 0);
        result = 29 * result + (this.date2Str != null ? this.date2Str.hashCode() : 0);
        result = 29 * result + (this.extns != null ? ((Object)this.extns).hashCode() : 0);
        result = 29 * result + (this.maxItems != null ? this.maxItems.hashCode() : 0);
        result = 29 * result + (this.rename != null ? this.rename.hashCode() : 0);
        return result;
    }

    public static WaybackSpecChart fromPathInfo(FishEyePathInfo pi) {
        return WaybackSpecChart.fromCommandString(pi.getCommandString());
    }

    public static WaybackSpecChart fromCommandString(CommandString cs) {
        List<String> vals;
        if (cs == null) {
            return null;
        }
        WaybackSpecChart wb = new WaybackSpecChart();
        boolean okay = false;
        String s = cs.getCommandParam("br");
        if (s != null) {
            wb.setBranch(s);
            okay = true;
        }
        if ((vals = cs.getCommandParams("author")) != null) {
            wb.setAuthors(vals);
            okay = true;
        }
        if ((s = cs.getCommandParam("charttype")) != null) {
            wb.setChartType(s);
            okay = true;
        }
        if ((s = cs.getCommandParam("stacktype")) != null) {
            wb.setStackType(s);
            okay = true;
        }
        if ((s = cs.getCommandParam("date1")) != null) {
            wb.setDate1(s);
            okay = true;
        }
        if ((s = cs.getCommandParam("date2")) != null) {
            wb.setDate2(s);
            okay = true;
        }
        if ((vals = cs.getCommandParams("extn")) != null) {
            wb.setExtns(vals);
            okay = true;
        }
        if ((s = cs.getCommandParam("maxitems")) != null) {
            wb.setMaxItems(s);
            okay = true;
        }
        if ((s = cs.getCommandParam("rename")) != null) {
            wb.setRename(s);
            okay = true;
        }
        return okay ? wb : null;
    }

    @Override
    public CommandString toCommandString() {
        MultiMap<String, String> params = super.getCommandParams();
        if (this.chartType != null) {
            params.add("charttype", this.chartType);
        }
        if (this.stackType != null) {
            params.add("stacktype", this.stackType);
        }
        if (this.date1Str != null) {
            params.add("date1", this.date1Str);
        }
        if (this.date2Str != null) {
            params.add("date2", this.date2Str);
        }
        if (this.extns != null && this.extns.size() != 0) {
            for (String extn : this.extns) {
                params.add("extn", extn);
            }
        }
        if (this.authors != null && this.authors.size() != 0) {
            for (String auth : this.authors) {
                params.add("author", auth);
            }
        }
        if (this.maxItems != null) {
            params.add("maxitems", this.maxItems.toString());
        }
        if (this.rename != null) {
            params.add("rename", this.rename);
        }
        return new CommandString(null, params);
    }

    public String getChartType() {
        return this.chartType;
    }

    public void setChartType(String mChartType) {
        this.chartType = mChartType;
    }

    public String getStackType() {
        return this.stackType;
    }

    public void setStackType(String mStackType) {
        this.stackType = mStackType;
    }

    public String getDate1Str() {
        return this.date1Str;
    }

    public String getDate2Str() {
        return this.date2Str;
    }

    public long getDate1() {
        return this.date1;
    }

    public long getDate2() {
        return this.date2;
    }

    public List<String> getExtn() {
        return this.extns;
    }

    public void setExtns(String[] extns) {
        this.extns = Arrays.asList(extns);
    }

    public void setExtns(List<String> extns) {
        this.extns = extns;
    }

    void setupChartDropdowns(Path path, RepositoryEngine engine) throws DbException {
        this.showAuthorLinecount = engine.getRevisionCache().showAuthorLinecount();
        this.chartTypeOptions = this.setupChartTypesDropdown();
        this.stackTypeOptions = this.setupStackTypesDropdown(this.showAuthorLinecount);
        List<String> authors = engine.getRevisionCache().findAuthors(path);
        authors.remove("");
        this.authorOptions = WaybackSpecChart.setupDropdown(authors, this.authors);
        this.extnOptions = WaybackSpecChart.setupDropdown(engine.getBucketGraph().getAvailableExtensions(path), this.extns);
        this.extnOptions.add(0, new ChartOption("None", this.extns != null && this.extns.contains("__NO_EXTENSION__"), false, "__NO_EXTENSION__"));
    }

    private static List<ChartOption> setupDropdown(List<String> strings, List<String> selected) {
        ArrayList<ChartOption> types = new ArrayList<ChartOption>();
        for (String s : strings) {
            types.add(new ChartOption(s, false, false));
        }
        if (selected != null) {
            for (String s : selected) {
                int index = strings.indexOf(s);
                if (index < 0) {
                    strings.add(0, s);
                    types.add(0, new ChartOption(s, true, false));
                    continue;
                }
                ((ChartOption)types.get(index)).setSelected(true);
            }
        }
        return types;
    }

    List<ChartOption> setupChartTypesDropdown() {
        ArrayList<ChartOption> chartTypes = new ArrayList<ChartOption>();
        ChartOption optionArea = new ChartOption("Area");
        ChartOption optionLine = new ChartOption("Line");
        ChartOption optionPie = new ChartOption("Pie");
        chartTypes.add(optionArea);
        chartTypes.add(optionLine);
        chartTypes.add(optionPie);
        if (this.chartType == null) {
            optionArea.setSelected(true);
        } else {
            for (ChartOption option : chartTypes) {
                if (!option.getText().equalsIgnoreCase(this.chartType)) continue;
                option.setSelected(true);
            }
        }
        if (this.getStackType() == null || this.getStackType().equalsIgnoreCase("None")) {
            optionPie.setDisabled(true);
        }
        return chartTypes;
    }

    List<ChartOption> setupStackTypesDropdown(boolean showAuthorLinecount) {
        ArrayList<ChartOption> stackTypes = new ArrayList<ChartOption>();
        ChartOption optionNone = new ChartOption("None");
        ChartOption optionSubdir = new ChartOption("Subdirectory");
        ChartOption optionAuthor = new ChartOption("Author");
        ChartOption optionExtn = new ChartOption("Extension");
        stackTypes.add(optionNone);
        stackTypes.add(optionSubdir);
        stackTypes.add(optionAuthor);
        stackTypes.add(optionExtn);
        if (!showAuthorLinecount) {
            optionAuthor.setDisabled(true);
        }
        if (this.getChartType().equalsIgnoreCase("Pie")) {
            optionNone.setDisabled(true);
        }
        if (this.getStackType() == null) {
            optionNone.setSelected(true);
        } else {
            for (ChartOption option : stackTypes) {
                if (!option.getText().equalsIgnoreCase(this.getStackType())) continue;
                option.setSelected(true);
            }
        }
        return stackTypes;
    }

    public List<ChartOption> getChartTypeOptions() {
        return this.chartTypeOptions;
    }

    public List<ChartOption> getStackTypeOptions() {
        return this.stackTypeOptions;
    }

    public List<ChartOption> getAuthorOptions() {
        return this.authorOptions;
    }

    public List<ChartOption> getExtnOptions() {
        return this.extnOptions;
    }

    public String getDate2String() {
        if (this.isPie()) {
            return "Date";
        }
        return "End Date";
    }

    public boolean isEnableAuthorDropdown() {
        return this.showAuthorLinecount && !"Author".equalsIgnoreCase(this.stackType);
    }

    public boolean isEnableExtnDropdown() {
        return !"Extension".equalsIgnoreCase(this.stackType);
    }

    public Integer getMaxItems() {
        return this.maxItems;
    }

    public String getRename() {
        return this.rename;
    }

    public void setRename(String mRename) {
        this.rename = mRename;
    }

    public RenamingRules getRenameRules() {
        if (WaybackSpecChart.isEmpty(this.rename)) {
            return null;
        }
        return new RenamingRules(this.rename);
    }

    public ParameterSetRetrieve.BreakdownOption getBreakdownOption() {
        if (this.stackType == null || this.stackType.equalsIgnoreCase("None")) {
            return ParameterSetRetrieve.BreakdownOption.NONE;
        }
        if (this.stackType.equalsIgnoreCase("Author")) {
            return ParameterSetRetrieve.BreakdownOption.AUTHOR;
        }
        if (this.stackType.equalsIgnoreCase("Extension")) {
            return ParameterSetRetrieve.BreakdownOption.EXTN;
        }
        if (this.stackType.equalsIgnoreCase("Subdirectory")) {
            return ParameterSetRetrieve.BreakdownOption.SUBDIR;
        }
        return ParameterSetRetrieve.BreakdownOption.NONE;
    }

    public boolean isArea() {
        return this.chartType == null || this.chartType.equalsIgnoreCase("Area");
    }

    public boolean isLine() {
        return this.chartType != null && this.chartType.equalsIgnoreCase("Line");
    }

    public boolean isPie() {
        return this.chartType != null && this.chartType.equalsIgnoreCase("Pie");
    }

    public List<String> getAuthors() {
        return this.authors;
    }

    public void setAuthors(List<String> authors) {
        this.authors = authors;
    }

    public void setAuthors(String[] authors) {
        this.authors = new ArrayList<String>();
        for (String author : authors) {
            if (WaybackSpecChart.isEmpty(author)) continue;
            this.authors.add(author);
        }
    }
}

