/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.admin.actions;

import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.spi.ThrowableInformation;

public class HtmlTesterLayout
extends Layout {
    private static final Map DEFAULT_STYLE = new HashMap();
    private final Map mStyle;
    private final String ndc;

    public HtmlTesterLayout(Map mStyle, String ndc) {
        this.mStyle = mStyle;
        this.ndc = ndc;
    }

    public HtmlTesterLayout(String ndc) {
        this.ndc = ndc;
        this.mStyle = DEFAULT_STYLE;
    }

    public static Map getDefaultStyle() {
        return new HashMap(DEFAULT_STYLE);
    }

    public String format(LoggingEvent loggingEvent) {
        if (loggingEvent.getNDC() == null || !loggingEvent.getNDC().equals(this.ndc)) {
            return "";
        }
        Level level = loggingEvent.getLevel();
        String logStyle = this.mStyle != null ? (this.mStyle.containsKey(level) ? (String)this.mStyle.get(level) : "") : "";
        StringBuffer row = new StringBuffer();
        row.append("<p style=\"").append(logStyle).append("\">");
        row.append(loggingEvent.getMessage());
        ThrowableInformation ti = loggingEvent.getThrowableInformation();
        if (ti != null) {
            Throwable t = ti.getThrowable();
            do {
                String msg = t.getMessage();
                row.append("<br/>").append(t.getClass().getName());
                row.append(" - ").append(msg);
            } while (null != (t = t.getCause()));
        }
        row.append("</p>");
        return row.toString();
    }

    public String getContentType() {
        return "text/html";
    }

    public boolean ignoresThrowable() {
        return false;
    }

    public void activateOptions() {
    }

    static {
        DEFAULT_STYLE.put(Level.ERROR, "color: #c22; font-weight: bold;");
        DEFAULT_STYLE.put(Level.FATAL, "color: #c22; font-weight: bold;");
        DEFAULT_STYLE.put(Level.WARN, "color: #da0; font-weight: bold;");
        DEFAULT_STYLE.put(Level.INFO, "color: #2c2; font-weight: bold;");
        DEFAULT_STYLE.put(Level.DEBUG, "color: #999;");
    }
}

