/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.admin.actions;

import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.mail.MailMessage;
import com.cenqua.fisheye.mail.Mailer;
import com.cenqua.fisheye.user.FEUser;
import com.cenqua.fisheye.user.UserLogin;
import com.opensymphony.webwork.interceptor.ServletRequestAware;
import com.opensymphony.xwork.ActionSupport;
import java.io.StringWriter;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Appender;
import org.apache.log4j.Level;
import org.apache.log4j.NDC;

public class SendTestEmailAction
extends ActionSupport
implements ServletRequestAware {
    private String to;
    private String subject = "Test email from FishEye 1.5.4";
    private String message = "This is a test email from FishEye 1.5.4";
    private String maillog;
    private HttpServletRequest request;

    public String getTo() {
        return this.to;
    }

    public void setTo(String to) {
        this.to = to;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getMaillog() {
        return this.maillog;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String execute() throws Exception {
        if (SendTestEmailAction.nullOrEmpty(this.to)) {
            this.addFieldError("to", "Please enter a recipient address for the test email");
            return "input";
        }
        StringWriter logBuffer = new StringWriter();
        String ndc = "test-email-" + System.currentTimeMillis();
        Appender appender = Logs.makeTestAppender(logBuffer, ndc, null);
        Level currentLevel = Logs.MAIL_LOG.getLevel();
        try {
            NDC.push((String)ndc);
            Logs.MAIL_LOG.setLevel(Level.DEBUG);
            Logs.MAIL_LOG.addAppender(appender);
            AppConfig.getsConfig().getMailer().reload(AppConfig.getsConfig().getConfig().getSmtp());
            MailMessage msg = new MailMessage();
            msg.addRecipient(this.to);
            msg.setSubject(this.subject);
            msg.setBodyText("text/plain; charset=UTF-8", this.message);
            Mailer mailer = AppConfig.getsConfig().getMailer();
            if (mailer.sendMessage(msg)) {
                Logs.MAIL_LOG.info((Object)"Test mail sent successfully.");
            }
        }
        finally {
            Logs.MAIL_LOG.removeAppender(appender);
            Logs.MAIL_LOG.setLevel(currentLevel);
            NDC.pop();
        }
        this.maillog = logBuffer.toString();
        return "success";
    }

    public String doDefault() throws Exception {
        UserLogin user = AppConfig.getsConfig().getUserManager().getCurrentUser(this.request);
        if (user != null) {
            FEUser feu = AppConfig.getsConfig().getUserManager().getUser(user.getUsername());
            this.to = feu.getEmail();
        }
        return "success";
    }

    private static boolean nullOrEmpty(String s) {
        return s == null || s.trim().length() == 0;
    }

    public void setServletRequest(HttpServletRequest httpServletRequest) {
        this.request = httpServletRequest;
    }
}

