/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.admin.actions;

import com.cenqua.fisheye.config1.ConfigDocument;
import com.cenqua.fisheye.config1.RepositoryType;
import com.cenqua.fisheye.config1.TarballType;
import com.cenqua.fisheye.web.admin.actions.BaseRepositoryAction;

public class ToggleTarballAction
extends BaseRepositoryAction {
    private boolean enable;
    private boolean useRepDefaults;
    private boolean customize;

    public boolean isEnable() {
        return this.enable;
    }

    public void setEnable(boolean enable) {
        this.enable = enable;
    }

    public boolean isUseRepDefaults() {
        return this.useRepDefaults;
    }

    public void setUseRepDefaults(boolean useRepDefaults) {
        this.useRepDefaults = useRepDefaults;
    }

    public boolean isCustomize() {
        return this.customize;
    }

    public void setCustomize(boolean customize) {
        this.customize = customize;
    }

    public String execute() throws Exception {
        ConfigDocument.Config cfg = this.getCfg();
        if (this.isDefault()) {
            TarballType tarball = cfg.getRepositoryDefaults().getTarball();
            tarball.setEnabled(this.enable);
        } else {
            try {
                RepositoryType repository = cfg.getRepositoryArray(this.getRep());
                if (this.isCustomize()) {
                    TarballType tarball = repository.addNewTarball();
                    tarball.setEnabled(true);
                    if (tarball.isSetMaxFileCount()) {
                        tarball.unsetMaxFileCount();
                    }
                } else if (this.isUseRepDefaults()) {
                    if (repository.isSetTarball()) {
                        repository.unsetTarball();
                    }
                } else {
                    TarballType tarball = repository.getTarball();
                    tarball.setEnabled(this.enable);
                }
            }
            catch (IndexOutOfBoundsException e2) {
                this.addActionError("Bad repository index " + this.getRep());
                return "error";
            }
        }
        this.saveCfg();
        return "success";
    }
}

