/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.admin.actions.user;

import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.user.UserManager;
import com.cenqua.fisheye.util.StringUtil;
import com.cenqua.fisheye.web.admin.actions.BaseAdminAction;
import com.cenqua.fisheye.web.admin.actions.user.UserAddAction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GroupAddAction
extends BaseAdminAction {
    public static final Pattern GROUPNAME_PATTERN = UserAddAction.USERNAME_PATTERN;
    public static final String GROUP_PATTERN_DESC = "alphanumeric, underscore, at ('@'), dot or dash";
    private String groupname;

    public String getGroupname() {
        return this.groupname;
    }

    public void setGroupname(String groupname) {
        this.groupname = groupname;
    }

    public String execute() {
        try {
            UserManager um = GroupAddAction.getUserManager();
            um.addBuiltInGroup(this.groupname);
            return "success";
        }
        catch (DbException e2) {
            Logs.APP_LOG.warn((Object)"problem adding group", (Throwable)e2);
            this.addActionError("Internal problem adding user (check logs)");
            return "input";
        }
    }

    public void validate() {
        if (this.hasErrors()) {
            return;
        }
        if (StringUtil.nullOrEmpty(this.groupname)) {
            this.addFieldError("groupname", "Name required");
        } else {
            Matcher m = GROUPNAME_PATTERN.matcher(this.groupname);
            if (!m.matches()) {
                this.addFieldError("groupname", "Group name can only contain alphanumeric, underscore, at ('@'), dot or dash");
            }
            UserManager um = GroupAddAction.getUserManager();
            try {
                if (um.builtInGroupExists(this.groupname)) {
                    this.addFieldError("groupname", "Group already exists");
                }
            }
            catch (DbException e2) {
                Logs.APP_LOG.warn((Object)"problem adding group", (Throwable)e2);
                this.addActionError("Internal problem adding user (check logs)");
            }
        }
    }
}

