/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.dirtree;

import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.infinitydb.query3.AndQuery3;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.lucene.LuceneConnection;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.RepositoryEngine;
import com.cenqua.fisheye.util.LRUCache;
import com.cenqua.fisheye.web.WaybackSpec;
import com.cenqua.fisheye.web.dirtree.DirTreeContextImpl;

public class DirTreeCache {
    private static final int MAX_DIRINFO_ENTRIES = 1000;
    final RepositoryEngine eng;
    final LRUCache dirinfoCache = new LRUCache(1000, false, null);

    public DirTreeCache(RepositoryEngine eng) {
        this.eng = eng;
    }

    public void invalidate() {
        Logs.APP_LOG.debug((Object)("Invalidating cache for " + this.eng.getName()));
        this.dirinfoCache.expireAll();
    }

    public void calculateWith(WaybackSpec wb, Visitor v) throws DbException {
        LuceneConnection conn = this.eng.getLuceneConnection();
        DirTreeContextImpl c2 = new DirTreeContextImpl(this, wb);
        c2.calculateWith(conn, v);
    }

    public void warm() throws DbException {
        this.calculateWith(null, new Visitor(){

            public void visit(Context calc) {
                boolean rootEmpty = calc.isEmptyOfFiles(new Path());
                Logs.PERF_LOG.info((Object)("Warming " + DirTreeCache.this.eng.getName() + ", rootempty=" + rootEmpty));
            }
        });
    }

    static class Node {
        public final boolean isEmpty;

        public Node(boolean empty) {
            this.isEmpty = empty;
        }
    }

    static class CacheKey {
        public final AndQuery3 query;
        public final Path dir;

        public CacheKey(AndQuery3 query, Path dir) {
            this.query = query;
            this.dir = dir;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey key = (CacheKey)o;
            if (!this.dir.equals(key.dir)) {
                return false;
            }
            return this.query.equals(key.query);
        }

        public int hashCode() {
            int result = this.query.hashCode();
            result = 29 * result + this.dir.hashCode();
            return result;
        }
    }

    public static interface Visitor {
        public void visit(Context var1) throws DbException;
    }

    public static interface Context {
        public boolean isEmptyOfFiles(Path var1);
    }
}

